/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.animation.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.adrenix.nostalgic.mixin.access.PlayerAccess;
import mod.adrenix.nostalgic.mixin.duck.CameraPitching;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    Minecraft minecraft;
    @Unique
    private final FlagHolder nt$directionFlag = FlagHolder.off();

    @Inject(method={"bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(ordinal=1, shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V")})
    private void nt_player_animation$onBobView(PoseStack poseStack, float partialTick, CallbackInfo callback) {
        Entity entity;
        if (((Boolean)AnimationTweak.OLD_VERTICAL_BOBBING.get()).booleanValue() && (entity = this.minecraft.getCameraEntity()) instanceof Player) {
            Player player = (Player)entity;
            CameraPitching cameraPitching = (CameraPitching)player;
            float pitch = Mth.lerp((float)partialTick, (float)cameraPitching.nt$getPrevCameraPitch(), (float)cameraPitching.nt$getCameraPitch());
            poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        }
    }

    @Inject(method={"bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")})
    private void nt_player_animation$onBobHurt(PoseStack poseStack, float partialTick, CallbackInfo callback) {
        Entity entity;
        if (((Boolean)AnimationTweak.OLD_RANDOM_DAMAGE.get()).booleanValue() && (entity = this.minecraft.getCameraEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (player.getHurtDir() != 0.0f) {
                return;
            }
            if ((float)player.hurtTime - partialTick > 0.0f && this.nt$directionFlag.ifDisabledThenEnable()) {
                player.animateHurt((float)((int)(Math.random() * 2.0) * 180));
            } else if ((float)player.hurtTime - partialTick <= 0.0f) {
                this.nt$directionFlag.disable();
            }
        }
    }

    @Inject(method={"bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(ordinal=0, value="RETURN")})
    private void nt_player_animation$onGetHurtDir(PoseStack poseStack, float partialTick, CallbackInfo callback) {
        Entity entity;
        if (((Boolean)AnimationTweak.OLD_RANDOM_DAMAGE.get()).booleanValue() && (entity = this.minecraft.getCameraEntity()) instanceof Player) {
            Player player = (Player)entity;
            ((PlayerAccess)player).nt$setHurtDir(0.0f);
        }
    }
}

