/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.animation.held_item;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import mod.adrenix.nostalgic.helper.animation.HeldItemHelper;
import mod.adrenix.nostalgic.mixin.duck.SlotTracker;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.data.NumberHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    @Shadow
    private ItemStack mainHandItem;
    @Shadow
    private ItemStack offHandItem;
    @Shadow
    private float mainHandHeight;

    @ModifyExpressionValue(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F")})
    private float nt_held_item$getAttackStrengthScale(float scale) {
        return (Boolean)AnimationTweak.OLD_ITEM_COOLDOWN.get() != false ? 1.0f : scale;
    }

    @Inject(method={"tick()V"}, at={@At(ordinal=3, value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F")})
    private void nt_held_item$onItemInHandTick(CallbackInfo callback) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return;
        }
        Holder<ItemStack> handItem = Holder.create(this.mainHandItem);
        NumberHolder<Float> handHeight = NumberHolder.create(Float.valueOf(this.mainHandHeight));
        HeldItemHelper.oldReequipLogic(handItem, handHeight);
        this.mainHandItem = handItem.get();
        this.mainHandHeight = ((Float)handHeight.get()).floatValue();
    }

    @ModifyVariable(argsOnly=true, method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="HEAD"))
    private ItemStack nt_held_item$changeRendererItemStack(ItemStack itemStack, AbstractClientPlayer player, float partialTick, float pitch, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return itemStack;
        }
        return HeldItemHelper.getLastHeldItem(itemStack, this.mainHandItem, player.getMainHandItem(), (SlotTracker)player);
    }

    @ModifyArg(index=0, method={"tick()V"}, at=@At(ordinal=2, value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"))
    private float nt_held_item$onIncreaseMainHand(float current) {
        return (Boolean)AnimationTweak.OLD_ITEM_REEQUIP.get() != false ? 0.0f : current;
    }

    @ModifyArg(index=0, method={"tick()V"}, at=@At(ordinal=3, value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"))
    private float nt_held_item$onIncreaseOffHand(float current) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!((Boolean)AnimationTweak.OLD_ITEM_REEQUIP.get()).booleanValue() || player == null) {
            return current;
        }
        ItemStack offHandStack = player.getOffhandItem();
        if (this.offHandItem.is(offHandStack.getItem()) && this.offHandItem.getCount() != offHandStack.getCount()) {
            return 0.0f;
        }
        return current;
    }

    @ModifyExpressionValue(method={"tick()V"}, at={@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean nt_held_item$modifyHeldItemMatching(boolean isMatched) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return isMatched;
        }
        return (Boolean)AnimationTweak.OLD_ITEM_REEQUIP.get() == false && ItemStack.matches((ItemStack)this.mainHandItem, (ItemStack)player.getMainHandItem());
    }
}

