/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.listener.common;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaHelper;
import mod.adrenix.nostalgic.network.packet.sync.ClientboundHandshake;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.enums.Hotbar;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class PlayerListener {
    public static void register() {
        PlayerEvent.PLAYER_JOIN.register(PlayerListener::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(PlayerListener::onPlayerQuit);
        TickEvent.PLAYER_POST.register(PlayerListener::onTick);
    }

    public static void onTick(Player player) {
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        if (((Boolean)GameplayTweak.DISABLE_SPRINT.get()).booleanValue() && player.isSprinting()) {
            player.setSprinting(false);
        }
        if (((Boolean)GameplayTweak.DISABLE_SWIM.get()).booleanValue() && player.isSwimming()) {
            player.setSwimming(false);
        }
        StaminaHelper.tick(player);
        if (StaminaHelper.get(player).isExhausted()) {
            if (player.isSprinting()) {
                player.setSprinting(false);
            }
            if (player.isSwimming()) {
                player.setSwimming(false);
            }
        }
    }

    private static void onPlayerJoin(ServerPlayer player) {
        String loader = NostalgicTweaks.getLoader();
        String tiny = NostalgicTweaks.getTinyVersion();
        String beta = NostalgicTweaks.getBetaVersion();
        String version = beta.isEmpty() ? tiny : tiny + "-" + beta;
        String protocol = NostalgicTweaks.getProtocol();
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundHandshake(loader, version, protocol));
        PlayerListener.setCreativeHotbar(player);
    }

    private static void onPlayerQuit(ServerPlayer player) {
        StaminaHelper.remove((Player)player);
    }

    private static void setBlockInSlot(ServerPlayer player, int slot, Block block) {
        player.getInventory().add(slot, block.asItem().getDefaultInstance());
    }

    private static void setCreativeHotbar(ServerPlayer player) {
        boolean isNostalgic;
        Hotbar hotbar = (Hotbar)CandyTweak.OLD_CREATIVE_HOTBAR.get();
        boolean isCreative = player.gameMode.getGameModeForPlayer() == GameType.CREATIVE;
        boolean bl = isNostalgic = hotbar != Hotbar.MODERN;
        if (player.getInventory().isEmpty() && isCreative && isNostalgic) {
            PlayerListener.setBlockInSlot(player, 0, Blocks.STONE);
            PlayerListener.setBlockInSlot(player, 1, Blocks.COBBLESTONE);
            PlayerListener.setBlockInSlot(player, 2, Blocks.BRICKS);
            PlayerListener.setBlockInSlot(player, 3, Blocks.DIRT);
            PlayerListener.setBlockInSlot(player, 4, Blocks.OAK_PLANKS);
            PlayerListener.setBlockInSlot(player, 5, Blocks.OAK_LOG);
            PlayerListener.setBlockInSlot(player, 6, Blocks.OAK_LEAVES);
            PlayerListener.setBlockInSlot(player, 8, Blocks.SMOOTH_STONE_SLAB);
            if (hotbar == Hotbar.BETA) {
                PlayerListener.setBlockInSlot(player, 7, Blocks.TORCH);
            } else {
                PlayerListener.setBlockInSlot(player, 7, Blocks.GLASS);
            }
        }
    }
}

