/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.listener.common;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.helper.gameplay.combat.SwordBlockingHelper;
import mod.adrenix.nostalgic.mixin.access.AxeItemAccess;
import mod.adrenix.nostalgic.mixin.access.ShovelItemAccess;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.common.world.PlayerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class InteractionListener {
    public static void register() {
        InteractionEvent.RIGHT_CLICK_ITEM.register(InteractionListener::onRightClickItem);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(InteractionListener::onRightClickBlock);
        InteractionEvent.LEFT_CLICK_BLOCK.register(InteractionListener::onLeftClickBlock);
        InteractionEvent.INTERACT_ENTITY.register(InteractionListener::onInteractEntity);
    }

    private static CompoundEventResult<ItemStack> onRightClickItem(Player player, InteractionHand hand) {
        ItemStack itemStackInHand = player.getItemInHand(hand);
        Item itemInHand = itemStackInHand.getItem();
        if (((Boolean)GameplayTweak.INSTANT_BOW.get()).booleanValue() && itemInHand.equals(Items.BOW) && itemInHand instanceof BowItem) {
            BowItem bow = (BowItem)itemInHand;
            int timeCharged = 72000 - (int)((float)((Integer)GameplayTweak.ARROW_SPEED.get()).intValue() / 100.0f * 20.0f);
            bow.releaseUsing(itemStackInHand, player.level(), (LivingEntity)player, timeCharged);
            return CompoundEventResult.interruptTrue((Object)itemStackInHand);
        }
        if (SwordBlockingHelper.canBlock(player) && !player.isUsingItem()) {
            player.startUsingItem(hand);
            return CompoundEventResult.interruptTrue((Object)itemStackInHand);
        }
        return CompoundEventResult.pass();
    }

    private static EventResult onRightClickBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction face) {
        Level level = player.level();
        RandomSource randomSource = level.getRandom();
        BlockState blockState = level.getBlockState(blockPos);
        BlockState aboveState = level.getBlockState(blockPos.above());
        Item itemInHand = player.getItemInHand(hand).getItem();
        if (((Boolean)GameplayTweak.DISABLE_ANVIL.get()).booleanValue() && blockState.is(BlockTags.ANVIL)) {
            return EventResult.interruptTrue();
        }
        if (((Boolean)GameplayTweak.DISABLE_ENCHANT_TABLE.get()).booleanValue() && blockState.is(Blocks.ENCHANTING_TABLE)) {
            return EventResult.interruptTrue();
        }
        if (((Boolean)GameplayTweak.TILLED_GRASS_SEEDS.get()).booleanValue() && blockState.is(Blocks.GRASS_BLOCK) && itemInHand instanceof HoeItem) {
            if (!aboveState.isAir() || randomSource.nextInt(10) != 0) {
                return EventResult.pass();
            }
            double x = (double)blockPos.getX() + 0.5 + Mth.nextDouble((RandomSource)randomSource, (double)-0.05, (double)0.05);
            double y = (double)blockPos.getY() + 1.0;
            double z = (double)blockPos.getZ() + 0.5 + Mth.nextDouble((RandomSource)randomSource, (double)-0.05, (double)0.05);
            double dx = Mth.nextDouble((RandomSource)randomSource, (double)-0.1, (double)0.1);
            double dy = Mth.nextDouble((RandomSource)randomSource, (double)0.18, (double)0.2);
            double dz = Mth.nextDouble((RandomSource)randomSource, (double)-0.1, (double)0.1);
            ItemEntity seedEntity = new ItemEntity(level, x, y, z, new ItemStack((ItemLike)Items.WHEAT_SEEDS), dx, dy, dz);
            seedEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)seedEntity);
        }
        if (NostalgicTweaks.isServer()) {
            if (((Boolean)GameplayTweak.DISABLE_SHOVEL_PATHING.get()).booleanValue() && itemInHand instanceof ShovelItem && ShovelItemAccess.NT$FLATTENABLES().containsKey(blockState.getBlock())) {
                return EventResult.interruptTrue();
            }
            if (((Boolean)GameplayTweak.DISABLE_AXE_STRIPPING.get()).booleanValue() && itemInHand instanceof AxeItem && AxeItemAccess.NT$STRIPPABLES().containsKey(blockState.getBlock())) {
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    private static EventResult onLeftClickBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction face) {
        Level level = player.getCommandSenderWorld();
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)blockPos), face, blockPos, false);
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (((Boolean)GameplayTweak.PUNCH_TNT_IGNITION.get()).booleanValue() && !player.isCrouching() && block instanceof TntBlock) {
            TntBlock.explode((Level)level, (BlockPos)blockPos);
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 11);
            return EventResult.interruptTrue();
        }
        if (player.swinging) {
            return EventResult.pass();
        }
        if (((Boolean)GameplayTweak.LEFT_CLICK_DOOR.get()).booleanValue() && PlayerUtil.isSurvival(player) && (block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock)) {
            blockState.useWithoutItem(level, player, blockHitResult);
        }
        if (((Boolean)GameplayTweak.LEFT_CLICK_LEVER.get()).booleanValue() && PlayerUtil.isSurvival(player) && block instanceof LeverBlock) {
            blockState.useWithoutItem(level, player, blockHitResult);
        }
        if (((Boolean)GameplayTweak.LEFT_CLICK_BUTTON.get()).booleanValue() && PlayerUtil.isSurvival(player) && block instanceof ButtonBlock) {
            blockState.useWithoutItem(level, player, blockHitResult);
        }
        return EventResult.pass();
    }

    private static EventResult onInteractEntity(Player player, Entity entity, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (((Boolean)GameplayTweak.OLD_SQUID_MILKING.get()).booleanValue() && itemInHand.is(Items.BUCKET) && entity instanceof Squid) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance()));
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }
}

