/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.listener.client;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import mod.adrenix.nostalgic.client.gui.MouseManager;
import mod.adrenix.nostalgic.client.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.gui.screen.DynamicScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.pause.NostalgicPauseScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.progress.NostalgicLoadingScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.progress.NostalgicProgressScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.title.NostalgicTitleScreen;
import mod.adrenix.nostalgic.client.gui.screen.vanilla.world.select.NostalgicSelectWorldScreen;
import mod.adrenix.nostalgic.client.gui.toast.ModToast;
import mod.adrenix.nostalgic.client.gui.tooltip.Tooltip;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaData;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.enums.Corner;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.tweak.enums.PauseLayout;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.client.gui.CornerManager;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import mod.adrenix.nostalgic.util.common.world.PlayerUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.world.entity.player.Player;

public abstract class GuiListener {
    public static void register() {
        ClientGuiEvent.RENDER_PRE.register(GuiListener::setMousePosition);
        ClientGuiEvent.RENDER_POST.register(GuiListener::renderModGraphics);
        ClientGuiEvent.RENDER_HUD.register(GuiListener::renderInGameOverlay);
        ClientGuiEvent.SET_SCREEN.register(GuiListener::rerouteScreen);
    }

    private static CompoundEventResult<Screen> rerouteScreen(Screen screen) {
        if (screen == null) {
            return CompoundEventResult.pass();
        }
        Screen parentScreen = Minecraft.getInstance().screen;
        if (screen.getClass() == TitleScreen.class && ((Boolean)CandyTweak.OVERRIDE_TITLE_SCREEN.get()).booleanValue()) {
            return CompoundEventResult.interruptTrue((Object)new NostalgicTitleScreen());
        }
        if (screen.getClass() == NostalgicTitleScreen.class && !((Boolean)CandyTweak.OVERRIDE_TITLE_SCREEN.get()).booleanValue()) {
            return CompoundEventResult.interruptTrue((Object)new TitleScreen());
        }
        if (screen.getClass() == SelectWorldScreen.class && CandyTweak.OLD_WORLD_SELECT_SCREEN.get() != Generic.MODERN && parentScreen != null) {
            return CompoundEventResult.interruptTrue((Object)new NostalgicSelectWorldScreen(parentScreen));
        }
        if (screen instanceof PauseScreen) {
            boolean isHoldingF3 = KeyboardUtil.isDown(292);
            if (CandyTweak.OLD_PAUSE_MENU.get() != PauseLayout.MODERN && !isHoldingF3) {
                return CompoundEventResult.interruptTrue((Object)new NostalgicPauseScreen());
            }
        }
        if (((Boolean)CandyTweak.OLD_PROGRESS_SCREEN.get()).booleanValue()) {
            NostalgicProgressScreen progressScreen;
            if (screen instanceof ProgressScreen && ClassUtil.isNotInstanceOf(screen, NostalgicProgressScreen.class)) {
                return CompoundEventResult.interruptTrue((Object)((Object)new NostalgicProgressScreen((ProgressScreen)screen)));
            }
            if (screen instanceof LevelLoadingScreen) {
                StoringChunkProgressListener progressListener = Minecraft.getInstance().getProgressListener();
                MutableComponent header = Lang.Level.LOADING.get(new Object[0]);
                MutableComponent stage = Lang.Level.BUILDING.get(new Object[0]);
                if (progressListener != null) {
                    return CompoundEventResult.interruptTrue((Object)((Object)new NostalgicLoadingScreen(progressListener, (Component)header, (Component)stage)));
                }
            }
            if (screen instanceof GenericMessageScreen && (progressScreen = GuiListener.getProgressScreen(screen.getTitle().getString())).hasStage()) {
                return CompoundEventResult.interruptTrue((Object)((Object)progressScreen));
            }
        }
        return CompoundEventResult.pass();
    }

    private static NostalgicProgressScreen getProgressScreen(String title) {
        NostalgicProgressScreen progressScreen = new NostalgicProgressScreen(new ProgressScreen(false));
        if (title.equals(Lang.Vanilla.SAVE_LEVEL.getString(new Object[0]))) {
            progressScreen.setStage((Component)Lang.Level.SAVING.get(new Object[0]));
        }
        if (title.equals(Lang.Vanilla.WORLD_RESOURCE_LOAD.getString(new Object[0]))) {
            progressScreen.setHeader((Component)Lang.Level.LOADING.get(new Object[0]));
            progressScreen.setStage((Component)Lang.Vanilla.WORLD_RESOURCE_LOAD.get(new Object[0]));
        }
        if (title.equals(Lang.Vanilla.WORLD_DATA_READ.getString(new Object[0]))) {
            progressScreen.setHeader((Component)Lang.Level.LOADING.get(new Object[0]));
            progressScreen.setStage((Component)Lang.Vanilla.WORLD_DATA_READ.get(new Object[0]));
        }
        return progressScreen;
    }

    private static EventResult setMousePosition(Screen screen, GuiGraphics graphics, int mouseX, int mouseY, DeltaTracker deltaTracker) {
        MouseManager.setPosition(mouseX, mouseY);
        return EventResult.pass();
    }

    private static void renderModGraphics(Screen screen, GuiGraphics graphics, int mouseX, int mouseY, DeltaTracker deltaTracker) {
        Tooltip.render(screen, graphics);
        ModToast.update(screen);
        if (screen instanceof DynamicScreen || screen instanceof Overlay) {
            GuiUtil.renderDebug(graphics);
        }
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            GuiListener.renderTextOverlay(graphics, true);
        }
        RenderUtil.flush();
    }

    private static String getFoodColor(int food) {
        if (food <= 2) {
            return "\u00a74" + food + "\u00a7r";
        }
        if (food <= 6) {
            return "\u00a7c" + food + "\u00a7r";
        }
        if (food <= 10) {
            return "\u00a76" + food + "\u00a7r";
        }
        if (food <= 15) {
            return "\u00a7e" + food + "\u00a7r";
        }
        if (food < 20) {
            return "\u00a72" + food + "\u00a7r";
        }
        return "\u00a7a" + food + "\u00a7r";
    }

    private static String getStaminaColor(StaminaData data, Player player) {
        int level = (int)Math.floor((double)data.getStaminaLevel() / 20.0 * 100.0);
        if (!((Boolean)CandyTweak.USE_DYNAMIC_STAMINA_COLOR.get()).booleanValue()) {
            return String.valueOf(level);
        }
        if (data.isExhausted()) {
            return "\u00a77" + level + "\u00a7r";
        }
        if (data.isCooldown()) {
            return "\u00a7b" + level + "\u00a7r";
        }
        if (data.cannotRegain(player) || data.hasNegativeEffect(player)) {
            return "\u00a74" + level + "\u00a7r";
        }
        if (data.hasPositiveEffect(player)) {
            return "\u00a72" + level + "\u00a7r";
        }
        if (level <= 15) {
            return "\u00a75" + level + "\u00a7r";
        }
        if (level <= 25) {
            return "\u00a7d" + level + "\u00a7r";
        }
        if (level <= 40) {
            return "\u00a7c" + level + "\u00a7r";
        }
        if (level <= 55) {
            return "\u00a74" + level + "\u00a7r";
        }
        if (level <= 65) {
            return "\u00a76" + level + "\u00a7r";
        }
        if (level <= 80) {
            return "\u00a7e" + level + "\u00a7r";
        }
        if (level <= 99) {
            return "\u00a72" + level + "\u00a7r";
        }
        return "\u00a7a" + level + "\u00a7r";
    }

    private static void renderInGameOverlay(GuiGraphics graphics, DeltaTracker deltaTracker) {
        GuiListener.renderTextOverlay(graphics, false);
    }

    private static void renderTextOverlay(GuiGraphics graphics, boolean isInventory) {
        int yOffset;
        int xOffset;
        int yOffset2;
        int xOffset2;
        String text;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || minecraft.options.hideGui || minecraft.getDebugOverlay().showDebugScreen()) {
            return;
        }
        CornerManager corner = new CornerManager();
        boolean isCreative = PlayerUtil.isCreativeOrSpectator((Player)player);
        boolean isStaminaEnabled = (Boolean)GameplayTweak.STAMINA_SPRINT.get();
        boolean isHungerEnabled = (Boolean)GameplayTweak.DISABLE_HUNGER.get() == false;
        boolean isExperienceEnabled = (Boolean)GameplayTweak.DISABLE_ORB_SPAWN.get() == false;
        boolean isExperienceLevelCreative = isCreative && (Boolean)CandyTweak.SHOW_EXP_LEVEL_IN_CREATIVE.get() != false;
        boolean isExperienceProgressCreative = isCreative && (Boolean)CandyTweak.SHOW_EXP_PROGRESS_IN_CREATIVE.get() != false;
        int foodLevel = player.getFoodData().getFoodLevel();
        int experiencePercent = (int)(player.experienceProgress * 100.0f);
        int saturationPercent = (int)(player.getFoodData().getSaturationLevel() / 20.0f * 100.0f);
        RenderUtil.beginBatching();
        if (((Boolean)CandyTweak.OLD_VERSION_OVERLAY.get()).booleanValue() && !isInventory) {
            text = CandyTweak.OLD_OVERLAY_TEXT.parse(GameUtil.getVersion());
            xOffset2 = (Integer)CandyTweak.OLD_OVERLAY_OFFSET_X.get();
            yOffset2 = (Integer)CandyTweak.OLD_OVERLAY_OFFSET_Y.get();
            corner.drawText(graphics, text, (Corner)CandyTweak.OLD_OVERLAY_CORNER.get(), xOffset2, yOffset2, (Boolean)CandyTweak.OLD_OVERLAY_SHADOW.get());
        }
        if (((Boolean)CandyTweak.SHOW_EXP_LEVEL_TEXT.get()).booleanValue() && isExperienceEnabled && (!isCreative || isExperienceLevelCreative)) {
            text = CandyTweak.ALT_EXP_LEVEL_TEXT.parse(Integer.toString(player.experienceLevel));
            xOffset2 = (Integer)CandyTweak.ALT_EXP_LEVEL_OFFSET_X.get();
            yOffset2 = (Integer)CandyTweak.ALT_EXP_LEVEL_OFFSET_Y.get();
            if ((Boolean)CandyTweak.SHOW_EXP_LEVEL_ONLY_INVENTORY.get() == isInventory) {
                corner.drawText(graphics, text, (Corner)CandyTweak.ALT_EXP_LEVEL_CORNER.get(), xOffset2, yOffset2, (Boolean)CandyTweak.ALT_EXP_LEVEL_SHADOW.get());
            }
        }
        if (((Boolean)CandyTweak.SHOW_EXP_PROGRESS_TEXT.get()).booleanValue() && isExperienceEnabled && (!isCreative || isExperienceProgressCreative)) {
            String percent = (Boolean)CandyTweak.USE_DYNAMIC_PROGRESS_COLOR.get() != false ? TextUtil.getPercentColorLow(experiencePercent) : Integer.toString(experiencePercent);
            String text2 = CandyTweak.ALT_EXP_PROGRESS_TEXT.parse(percent);
            xOffset = (Integer)CandyTweak.ALT_EXP_PROGRESS_OFFSET_X.get();
            yOffset = (Integer)CandyTweak.ALT_EXP_PROGRESS_OFFSET_Y.get();
            if ((Boolean)CandyTweak.SHOW_EXP_PROGRESS_ONLY_INVENTORY.get() == isInventory) {
                corner.drawText(graphics, text2, (Corner)CandyTweak.ALT_EXP_PROGRESS_CORNER.get(), xOffset, yOffset, (Boolean)CandyTweak.ALT_EXP_PROGRESS_SHADOW.get());
            }
        }
        if (((Boolean)CandyTweak.SHOW_HUNGER_FOOD_TEXT.get()).booleanValue() && isHungerEnabled && !isCreative) {
            String food = (Boolean)CandyTweak.USE_DYNAMIC_FOOD_COLOR.get() != false ? GuiListener.getFoodColor(foodLevel) : Integer.toString(foodLevel);
            String text3 = CandyTweak.ALT_HUNGER_FOOD_TEXT.parse(food);
            xOffset = (Integer)CandyTweak.ALT_HUNGER_FOOD_OFFSET_X.get();
            yOffset = (Integer)CandyTweak.ALT_HUNGER_FOOD_OFFSET_Y.get();
            if ((Boolean)CandyTweak.SHOW_HUNGER_FOOD_ONLY_INVENTORY.get() == isInventory) {
                corner.drawText(graphics, text3, (Corner)CandyTweak.ALT_HUNGER_FOOD_CORNER.get(), xOffset, yOffset, (Boolean)CandyTweak.ALT_HUNGER_FOOD_SHADOW.get());
            }
        }
        if (((Boolean)CandyTweak.SHOW_HUNGER_SATURATION_TEXT.get()).booleanValue() && isHungerEnabled && !isCreative) {
            String saturation = (Boolean)CandyTweak.USE_DYNAMIC_SATURATION_COLOR.get() != false ? TextUtil.getPercentColorLow(saturationPercent) : Integer.toString(saturationPercent);
            String text4 = CandyTweak.ALT_HUNGER_SATURATION_TEXT.parse(saturation);
            xOffset = (Integer)CandyTweak.ALT_HUNGER_SATURATION_OFFSET_X.get();
            yOffset = (Integer)CandyTweak.ALT_HUNGER_SATURATION_OFFSET_Y.get();
            if ((Boolean)CandyTweak.SHOW_HUNGER_SATURATION_ONLY_INVENTORY.get() == isInventory) {
                corner.drawText(graphics, text4, (Corner)CandyTweak.ALT_HUNGER_SATURATION_CORNER.get(), xOffset, yOffset, (Boolean)CandyTweak.ALT_HUNGER_SATURATION_SHADOW.get());
            }
        }
        if (((Boolean)CandyTweak.SHOW_STAMINA_TEXT.get()).booleanValue() && isStaminaEnabled && !isCreative) {
            StaminaData data = StaminaHelper.get((Player)player);
            String text5 = CandyTweak.ALT_STAMINA_TEXT.parse(GuiListener.getStaminaColor(data, (Player)player));
            xOffset = (Integer)CandyTweak.ALT_STAMINA_OFFSET_X.get();
            yOffset = (Integer)CandyTweak.ALT_STAMINA_OFFSET_Y.get();
            if (((Boolean)CandyTweak.ALT_STAMINA_SHOW_ON_ACTIVE.get()).booleanValue()) {
                if (StaminaHelper.isActiveFor((Player)player)) {
                    corner.drawText(graphics, text5, (Corner)CandyTweak.ALT_STAMINA_CORNER.get(), xOffset, yOffset, (Boolean)CandyTweak.ALT_STAMINA_SHADOW.get());
                }
            } else {
                corner.drawText(graphics, text5, (Corner)CandyTweak.ALT_STAMINA_CORNER.get(), xOffset, yOffset, (Boolean)CandyTweak.ALT_STAMINA_SHADOW.get());
            }
        }
        RenderUtil.endBatching();
    }
}

