/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import java.util.List;
import mod.adrenix.nostalgic.helper.candy.block.ChestHelper;
import mod.adrenix.nostalgic.helper.sound.PositionSoundHandler;
import mod.adrenix.nostalgic.mixin.access.EntityAccess;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.tweak.config.SoundTweak;
import mod.adrenix.nostalgic.tweak.listing.StringSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class SoundHelper {
    public static boolean isEntityStepIgnored(Entity entity) {
        return entity instanceof Spider || entity instanceof Silverfish || entity instanceof Bee;
    }

    public static boolean isModdedStepIgnored(Entity entity) {
        return (Boolean)SoundTweak.IGNORE_MODDED_STEP.get() != false && !entity.getType().getDescriptionId().contains("minecraft");
    }

    @Nullable
    public static PositionSoundHandler getHandlerAt(ClientLevel level, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        if (level == null || sound == null) {
            return null;
        }
        PositionSoundHandler handler = PositionSoundHandler.create(level, x, y, z, sound, source, volume, pitch);
        handler.apply(SoundHelper::isDisabledHandled);
        handler.apply(SoundHelper::isFurnaceHandled);
        handler.apply(SoundHelper::isAttackHandled);
        handler.apply(SoundHelper::isGrowthHandled);
        handler.apply(SoundHelper::isRowingHandled);
        handler.apply(SoundHelper::isSquidHandled);
        handler.apply(SoundHelper::isChestHandled);
        handler.apply(SoundHelper::isLavaHandled);
        handler.apply(SoundHelper::isSwimHandled);
        handler.apply(SoundHelper::isFishHandled);
        handler.apply(SoundHelper::isStepHandled);
        handler.apply(SoundHelper::isDoorHandled);
        handler.apply(SoundHelper::isBedHandled);
        handler.apply(SoundHelper::isXpHandled);
        return handler;
    }

    private static boolean isDisabledHandled(PositionSoundHandler handler) {
        if (((StringSet)SoundTweak.DISABLED_POSITIONED_SOUNDS.get()).contains(handler.sound.getLocation().toString())) {
            return handler.mute(new SoundEvent[0]);
        }
        return false;
    }

    private static boolean isAttackHandled(PositionSoundHandler handler) {
        boolean isAttack;
        if (!((Boolean)SoundTweak.OLD_ATTACK.get()).booleanValue()) {
            return false;
        }
        boolean isCrit = handler.compare(SoundEvents.PLAYER_ATTACK_CRIT);
        boolean isKnock = handler.compare(SoundEvents.PLAYER_ATTACK_KNOCKBACK);
        boolean isDamage = handler.compare(SoundEvents.PLAYER_ATTACK_NODAMAGE);
        boolean isStrong = handler.compare(SoundEvents.PLAYER_ATTACK_STRONG);
        boolean isSweep = handler.compare(SoundEvents.PLAYER_ATTACK_SWEEP);
        boolean isWeak = handler.compare(SoundEvents.PLAYER_ATTACK_WEAK);
        boolean bl = isAttack = isCrit || isKnock || isDamage || isStrong || isSweep || isWeak;
        if (isAttack) {
            handler.mute(new SoundEvent[0]);
        }
        return isAttack;
    }

    private static boolean isFurnaceHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_FURNACE.get()).booleanValue() && handler.blockState.getBlock() instanceof FurnaceBlock) {
            return handler.mute(SoundEvents.FURNACE_FIRE_CRACKLE);
        }
        if (((Boolean)SoundTweak.DISABLE_BLAST_FURNACE.get()).booleanValue() && handler.blockState.getBlock() instanceof BlastFurnaceBlock) {
            return handler.mute(SoundEvents.BLASTFURNACE_FIRE_CRACKLE);
        }
        return false;
    }

    private static boolean isGrowthHandled(PositionSoundHandler handler) {
        return (Boolean)SoundTweak.DISABLE_GROWTH.get() != false && handler.mute(SoundEvents.BONE_MEAL_USE);
    }

    private static boolean isRowingHandled(PositionSoundHandler handler) {
        if (!((Boolean)AnimationTweak.HIDE_BOAT_ROWING.get()).booleanValue() || !handler.compare(SoundEvents.BOAT_PADDLE_WATER, SoundEvents.BOAT_PADDLE_LAND)) {
            return false;
        }
        List boats = handler.level.getEntitiesOfClass(Boat.class, new AABB(handler.blockPos).inflate(3.0));
        if (boats.isEmpty()) {
            return false;
        }
        handler.mute(SoundEvents.BOAT_PADDLE_WATER, SoundEvents.BOAT_PADDLE_LAND);
        return true;
    }

    private static boolean isSquidHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_SQUID.get()).booleanValue() && handler.mute(SoundEvents.SQUID_AMBIENT, SoundEvents.SQUID_DEATH, SoundEvents.SQUID_HURT, SoundEvents.SQUID_SQUIRT)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_GLOW_SQUID_OTHER.get()).booleanValue() && handler.mute(SoundEvents.GLOW_SQUID_DEATH, SoundEvents.GLOW_SQUID_HURT, SoundEvents.GLOW_SQUID_SQUIRT)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_GLOW_SQUID_AMBIENCE.get()).booleanValue()) {
            return handler.mute(SoundEvents.GLOW_SQUID_AMBIENT);
        }
        return false;
    }

    private static boolean isLavaHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_LAVA_AMBIENCE.get()).booleanValue() && handler.mute(SoundEvents.LAVA_AMBIENT)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_LAVA_POP.get()).booleanValue()) {
            return handler.mute(SoundEvents.LAVA_POP);
        }
        return false;
    }

    private static boolean isSwimHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_GENERIC_SWIM.get()).booleanValue()) {
            return handler.mute(SoundEvents.GENERIC_SWIM, SoundEvents.PLAYER_SWIM);
        }
        return false;
    }

    private static boolean isFishHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_FISH_SWIM.get()).booleanValue() && handler.mute(SoundEvents.FISH_SWIM)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_FISH_HURT.get()).booleanValue() && handler.mute(SoundEvents.COD_HURT, SoundEvents.PUFFER_FISH_HURT, SoundEvents.SALMON_HURT, SoundEvents.TADPOLE_HURT, SoundEvents.TROPICAL_FISH_HURT)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_FISH_DEATH.get()).booleanValue()) {
            return handler.mute(SoundEvents.COD_DEATH, SoundEvents.PUFFER_FISH_DEATH, SoundEvents.SALMON_DEATH, SoundEvents.TADPOLE_DEATH, SoundEvents.TROPICAL_FISH_DEATH);
        }
        return false;
    }

    private static boolean isDoorHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_DOOR_PLACE.get()).booleanValue() && handler.blockState.getBlock() instanceof DoorBlock && handler.sound == handler.blockState.getSoundType().getPlaceSound()) {
            return handler.mute(new SoundEvent[0]);
        }
        return false;
    }

    private static boolean isBedHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_BED_PLACE.get()).booleanValue() && handler.blockState.getBlock() instanceof BedBlock && handler.sound == handler.blockState.getSoundType().getPlaceSound()) {
            return handler.mute(new SoundEvent[0]);
        }
        return false;
    }

    private static boolean isChestHandled(PositionSoundHandler handler) {
        boolean isChestSound;
        boolean isOpenSound = handler.compare(SoundEvents.CHEST_OPEN, SoundEvents.ENDER_CHEST_OPEN);
        boolean isCloseSound = handler.compare(SoundEvents.CHEST_CLOSE, SoundEvents.ENDER_CHEST_CLOSE);
        boolean bl = isChestSound = isOpenSound || isCloseSound;
        if (!isChestSound) {
            return false;
        }
        if (((Boolean)SoundTweak.DISABLE_CHEST.get()).booleanValue() && ChestHelper.isOld(handler.blockState)) {
            handler.mute(new SoundEvent[0]);
        }
        if (((Boolean)SoundTweak.OLD_CHEST.get()).booleanValue()) {
            handler.sound = SoundEvents.WOODEN_DOOR_OPEN;
            if (handler.compare(SoundEvents.CHEST_CLOSE, SoundEvents.ENDER_CHEST_CLOSE)) {
                handler.sound = SoundEvents.WOODEN_DOOR_CLOSE;
            }
            handler.pitch = handler.randomSource().nextFloat() * 0.1f + 0.9f;
        }
        return true;
    }

    private static boolean isXpHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_XP_PICKUP.get()).booleanValue()) {
            return handler.mute(SoundEvents.EXPERIENCE_ORB_PICKUP);
        }
        if (((Boolean)SoundTweak.OLD_XP.get()).booleanValue() && handler.compare(SoundEvents.EXPERIENCE_ORB_PICKUP)) {
            handler.sound = SoundEvents.ITEM_PICKUP;
            handler.pitch = handler.randomSource().nextFloat() - handler.randomSource().nextFloat() * 0.1f + 0.01f;
            return true;
        }
        return false;
    }

    private static boolean isStepHandled(PositionSoundHandler handler) {
        String path = handler.sound.getLocation().getPath();
        boolean isEntityStep = path.contains("entity.") && path.contains(".step");
        boolean isSingleplayer = Minecraft.getInstance().hasSingleplayerServer();
        if (!((Boolean)SoundTweak.OLD_STEP.get()).booleanValue() || !isEntityStep || isSingleplayer) {
            return false;
        }
        List entities = handler.level.getEntitiesOfClass(LivingEntity.class, new AABB(handler.blockPos).inflate(3.0));
        if (entities.isEmpty()) {
            return false;
        }
        BlockState standingOn = handler.level.getBlockState(handler.blockPos.below());
        LivingEntity entity = (LivingEntity)entities.getFirst();
        if (SoundHelper.isEntityStepIgnored((Entity)entity) || standingOn.isAir()) {
            return handler.mute(new SoundEvent[0]);
        }
        if (SoundHelper.isModdedStepIgnored((Entity)entity) || !standingOn.getFluidState().isEmpty()) {
            return false;
        }
        SoundType soundType = handler.getSoundTypeAt(((EntityAccess)entity).nt$getPrimaryStepSoundBlockPos(handler.blockPos.below()));
        handler.source = entity.getSoundSource();
        handler.volume = soundType.getVolume() * 0.15f;
        handler.sound = soundType.getStepSound();
        handler.pitch = soundType.getPitch();
        return true;
    }
}

