/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class PositionSoundHandler {
    final double x;
    final double y;
    final double z;
    float pitch;
    float volume;
    final ClientLevel level;
    final BlockState blockState;
    final BlockPos blockPos;
    SoundEvent sound;
    SoundSource source;
    boolean handled;

    static PositionSoundHandler create(ClientLevel level, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        return new PositionSoundHandler(level, x, y, z, sound, source, volume, pitch);
    }

    private PositionSoundHandler(ClientLevel level, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.pitch = pitch;
        this.volume = volume;
        this.source = source;
        this.blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        this.blockState = level.getBlockState(this.blockPos);
    }

    public boolean isHandled() {
        return this.handled;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundSource getSource() {
        return this.source;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    RandomSource randomSource() {
        return this.level.random;
    }

    SoundType getSoundTypeAt(BlockPos blockPos) {
        return this.level.getBlockState(blockPos).getSoundType();
    }

    void apply(Predicate<PositionSoundHandler> handler) {
        if (this.handled) {
            return;
        }
        this.handled = handler.test(this);
    }

    boolean compare(SoundEvent ... to) {
        for (SoundEvent event : to) {
            if (!event.equals(this.sound)) continue;
            return true;
        }
        return false;
    }

    boolean mute(SoundEvent ... sounds) {
        if (sounds.length == 0 || this.compare(sounds)) {
            this.volume = 0.0f;
            return true;
        }
        return false;
    }
}

