/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import mod.adrenix.nostalgic.client.ClientSound;
import mod.adrenix.nostalgic.tweak.config.SoundTweak;
import mod.adrenix.nostalgic.tweak.enums.MusicType;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class MusicHelper {
    public static final NullableHolder<SoundInstance> CURRENT_SONG = NullableHolder.empty();

    private static SoundInstance setAndGetOrElse(SoundEvent sound, SoundInstance fallback) {
        return sound != null ? CURRENT_SONG.setAndGet((SoundInstance)SimpleSoundInstance.forMusic((SoundEvent)sound)) : fallback;
    }

    public static SoundInstance apply(SoundInstance sound) {
        ResourceLocation soundLocation = sound.getLocation();
        if (soundLocation.equals((Object)((SoundEvent)SoundEvents.MUSIC_MENU.value()).getLocation())) {
            MusicType musicType = (MusicType)SoundTweak.MUSIC_FOR_MENU.get();
            if (musicType == MusicType.MODERN) {
                return sound;
            }
            return MusicHelper.setAndGetOrElse(switch (musicType) {
                case MusicType.ALPHA -> (SoundEvent)ClientSound.MUSIC_ALPHA.getOrNull();
                case MusicType.BETA -> (SoundEvent)ClientSound.MUSIC_MENU_BETA.getOrNull();
                case MusicType.BLENDED -> (SoundEvent)ClientSound.MUSIC_MENU_BLENDED.getOrNull();
                default -> (SoundEvent)ClientSound.BLANK.getOrNull();
            }, sound);
        }
        if (soundLocation.equals((Object)((SoundEvent)SoundEvents.MUSIC_CREATIVE.value()).getLocation())) {
            MusicType musicType = (MusicType)SoundTweak.MUSIC_FOR_CREATIVE.get();
            if (musicType == MusicType.MODERN) {
                return sound;
            }
            return MusicHelper.setAndGetOrElse(switch (musicType) {
                case MusicType.ALPHA -> (SoundEvent)ClientSound.MUSIC_ALPHA.getOrNull();
                case MusicType.BETA -> (SoundEvent)ClientSound.MUSIC_CREATIVE_BETA.getOrNull();
                case MusicType.BLENDED -> (SoundEvent)ClientSound.MUSIC_CREATIVE_BLENDED.getOrNull();
                default -> (SoundEvent)ClientSound.BLANK.getOrNull();
            }, sound);
        }
        if (((Boolean)SoundTweak.REPLACE_OVERWORLD_BIOME_MUSIC.get()).booleanValue() && GameUtil.isInOverworld()) {
            if (soundLocation.getPath().contains("music.overworld")) {
                return MusicHelper.setAndGetOrElse((SoundEvent)ClientSound.MUSIC_ALPHA.getOrNull(), sound);
            }
            if (soundLocation.equals((Object)((SoundEvent)SoundEvents.MUSIC_UNDER_WATER.value()).getLocation())) {
                return MusicHelper.setAndGetOrElse((SoundEvent)ClientSound.MUSIC_ALPHA.getOrNull(), sound);
            }
        }
        if (((Boolean)SoundTweak.REPLACE_NETHER_BIOME_MUSIC.get()).booleanValue() && GameUtil.isInNether() && soundLocation.getPath().contains("music.nether")) {
            return MusicHelper.setAndGetOrElse((SoundEvent)ClientSound.MUSIC_ALPHA.getOrNull(), sound);
        }
        if (((Boolean)SoundTweak.REPLACE_GAMEPLAY_MUSIC.get()).booleanValue() && soundLocation.equals((Object)((SoundEvent)SoundEvents.MUSIC_GAME.value()).getLocation())) {
            return MusicHelper.setAndGetOrElse((SoundEvent)ClientSound.MUSIC_ALPHA.getOrNull(), sound);
        }
        return sound;
    }
}

