/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import mod.adrenix.nostalgic.util.common.LocateResource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class CaveSoundManager {
    private int tickCountdown;
    private final RandomSource randomSource;
    private final SoundManager soundManager;
    private final LocalPlayer player;
    private final ClientLevel level;

    public CaveSoundManager(LocalPlayer player, SoundManager soundManager) {
        this.player = player;
        this.level = player.clientLevel;
        this.randomSource = player.clientLevel.getRandom();
        this.soundManager = soundManager;
        this.tickCountdown = this.randomSource.nextInt(12000);
    }

    public static SimpleSoundInstance getSound(RandomSource randomSource, double x, double y, double z) {
        return new SimpleSoundInstance(LocateResource.mod("cave"), SoundSource.AMBIENT, 0.7f, 0.8f + randomSource.nextFloat() * 0.2f, randomSource, false, 0, SoundInstance.Attenuation.LINEAR, x, y, z, false);
    }

    public void tickAndPlayIfPossible(BlockPos blockPos) {
        if (this.level.dimensionType().hasCeiling() || !this.level.dimensionType().hasSkyLight()) {
            return;
        }
        if (this.tickCountdown > 0) {
            --this.tickCountdown;
        }
        if (this.tickCountdown != 0) {
            return;
        }
        if (this.isCaveLike(blockPos)) {
            if (!BlockPos.betweenClosedStream((BoundingBox)new BoundingBox(blockPos).inflatedBy(1)).allMatch(this::isCaveLike)) {
                return;
            }
            AmbientMoodSettings ambientMoodSettings = AmbientMoodSettings.LEGACY_CAVE_SETTINGS;
            double blockX = (double)blockPos.getX() + 0.5;
            double blockY = (double)blockPos.getY() + 0.5;
            double blockZ = (double)blockPos.getZ() + 0.5;
            double dx = blockX - this.player.getX();
            double dy = blockY - this.player.getEyeY();
            double dz = blockZ - this.player.getZ();
            double normal = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double offset = normal + ambientMoodSettings.getSoundPositionOffset();
            double x = this.player.getX() + dx / normal * offset;
            double y = this.player.getEyeY() + dy / normal * offset;
            double z = this.player.getZ() + dz / normal * offset;
            this.soundManager.play((SoundInstance)CaveSoundManager.getSound(this.randomSource, x, y, z));
            this.tickCountdown = this.randomSource.nextInt(12000) + 6000;
        }
    }

    private boolean isCaveLike(BlockPos blockPos) {
        if (this.level.getBlockState(blockPos).getBlock() instanceof AirBlock) {
            int blockLight = this.level.getBrightness(LightLayer.BLOCK, blockPos);
            int skyLight = this.level.getBrightness(LightLayer.SKY, blockPos);
            return blockLight <= 0 && skyLight <= 0;
        }
        return false;
    }
}

