/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay.stamina;

import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaData;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.timer.FlagTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class StaminaRenderer {
    public static final FlagHolder HAS_BEGUN_TO_DRAIN = FlagHolder.off();
    public static final FlagTimer FULL_FLASH_TIMER = FlagTimer.create(150L, TimeUnit.MILLISECONDS).maxRepeat(4).startWith(true).build();
    public static final FlagTimer LOW_FLASH_TIMER = FlagTimer.create(200L, TimeUnit.MILLISECONDS).startWith(true).build();

    public static boolean isVisible() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || ((Boolean)CandyTweak.HIDE_STAMINA_BAR.get()).booleanValue() || !((Boolean)GameplayTweak.STAMINA_SPRINT.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)CandyTweak.HIDE_STAMINA_BAR_INACTIVE.get()).booleanValue() && !StaminaHelper.isActiveFor((Player)player)) {
            return false;
        }
        Entity vehicle = player.getVehicle();
        boolean isMounted = vehicle != null && vehicle.showVehicleHealth();
        boolean isInSurvival = minecraft.gameMode != null && minecraft.gameMode.canHurtPlayer();
        boolean isPlayerCamera = minecraft.getCameraEntity() instanceof Player;
        return !minecraft.options.hideGui && !isMounted && isInSurvival && isPlayerCamera;
    }

    public static void render(GuiGraphics graphics, int rightHeight) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || !StaminaRenderer.isVisible()) {
            return;
        }
        RenderUtil.beginBatching();
        StaminaData data = StaminaHelper.get((Player)player);
        int width = GuiUtil.getGuiWidth();
        int height = GuiUtil.getGuiHeight();
        int left = width / 2 + 91;
        int top = height - rightHeight;
        int stamina = data.getStaminaLevel();
        boolean isCooldown = data.isCooldown();
        boolean isExhausted = data.isExhausted();
        boolean hasPositiveEffect = data.hasPositiveEffect((Player)player);
        boolean hasNegativeEffect = data.hasNegativeEffect((Player)player);
        boolean cannotRegain = data.cannotRegain((Player)player);
        if (((Boolean)CandyTweak.FLASH_STAMINA_BAR_WHEN_FULL.get()).booleanValue() && stamina < 20) {
            HAS_BEGUN_TO_DRAIN.enable();
        }
        for (int i = 0; i < 10; ++i) {
            int flashAt;
            ResourceLocation sprite = isExhausted ? ModSprite.STAMINA_RECHARGE : ModSprite.STAMINA_LEVEL;
            int x = left - i * 8 - 9;
            int icon = i * 2 + 1;
            if (hasPositiveEffect) {
                sprite = ModSprite.STAMINA_POSITIVE;
            }
            if (cannotRegain && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_MOVING.get()).booleanValue()) {
                sprite = ModSprite.STAMINA_NEGATIVE;
            }
            if (hasNegativeEffect) {
                sprite = ModSprite.STAMINA_NEGATIVE;
            }
            if (isCooldown && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_COOLDOWN.get()).booleanValue()) {
                sprite = ModSprite.STAMINA_COOLING;
            }
            RenderUtil.blitSprite(ModSprite.STAMINA_EMPTY, graphics, x, top, 9, 9);
            if (icon > stamina) {
                sprite = ModSprite.STAMINA_EMPTY;
            } else if (icon == stamina && MathUtil.isOdd(stamina)) {
                ResourceLocation resourceLocation = sprite = isExhausted ? ModSprite.STAMINA_RECHARGE_HALF : ModSprite.STAMINA_LEVEL_HALF;
                if (hasPositiveEffect) {
                    sprite = ModSprite.STAMINA_POSITIVE_HALF;
                }
                if (cannotRegain && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_MOVING.get()).booleanValue()) {
                    sprite = ModSprite.STAMINA_NEGATIVE_HALF;
                }
                if (hasNegativeEffect) {
                    sprite = ModSprite.STAMINA_NEGATIVE_HALF;
                }
                if (isCooldown && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_COOLDOWN.get()).booleanValue()) {
                    sprite = ModSprite.STAMINA_COOLING_HALF;
                }
            }
            RenderUtil.blitSprite(sprite, graphics, x, top, 9, 9);
            boolean shouldHighlight = false;
            if (((Boolean)CandyTweak.HIGHLIGHT_STAMINA_BAR.get()).booleanValue() && stamina != 20) {
                shouldHighlight = player.isSprinting();
            }
            if (((Boolean)HAS_BEGUN_TO_DRAIN.get()).booleanValue() && stamina == 20) {
                shouldHighlight = FULL_FLASH_TIMER.getFlag();
            } else {
                FULL_FLASH_TIMER.reset();
            }
            if (FULL_FLASH_TIMER.hasReachedMax()) {
                FULL_FLASH_TIMER.reset();
                HAS_BEGUN_TO_DRAIN.disable();
                shouldHighlight = false;
            }
            if ((flashAt = ((Integer)CandyTweak.FLASH_STAMINA_BAR_AT.get()).intValue()) > 0 && flashAt >= stamina && player.isSprinting()) {
                shouldHighlight = LOW_FLASH_TIMER.getFlag();
            }
            if (!shouldHighlight) continue;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 1.0f);
            RenderUtil.blitSprite(ModSprite.STAMINA_HIGHLIGHT, graphics, x, top, 9, 9);
            graphics.pose().popPose();
        }
        RenderUtil.endBatching();
    }
}

