/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay.stamina;

import java.util.HashMap;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaData;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.world.entity.player.Player;

public abstract class StaminaHelper {
    private static final HashMap<String, StaminaData> PLAYER_DATA = new HashMap();

    public static void init() {
        GameplayTweak.STAMINA_SPRINT.whenChanged(StaminaHelper::reset);
    }

    public static StaminaData get(Player player) {
        if (!PLAYER_DATA.containsKey(player.getStringUUID())) {
            PLAYER_DATA.put(player.getStringUUID(), new StaminaData());
        }
        return PLAYER_DATA.get(player.getStringUUID());
    }

    public static void remove(Player player) {
        PLAYER_DATA.remove(player.getStringUUID());
    }

    public static void tick(Player player) {
        StaminaHelper.get(player).tick(player);
    }

    public static boolean isActiveFor(Player player) {
        StaminaData data = StaminaHelper.get(player);
        return data.getStaminaLevel() < 20 || data.isExhausted() || player.isSprinting();
    }

    public static void reset() {
        PLAYER_DATA.clear();
    }
}

