/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay.combat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public abstract class SwordBlockingRenderer {
    public static void applyFirstPerson(PoseStack poseStack, Player player, InteractionHand hand) {
        HumanoidArm mainArm = player.getMainArm();
        HumanoidArm usingArm = InteractionHand.MAIN_HAND == hand ? mainArm : mainArm.getOpposite();
        int mirror = HumanoidArm.RIGHT == usingArm ? 1 : -1;
        poseStack.translate((float)mirror * -0.14f, 0.15f, 0.1f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-102.25f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)mirror * 13.37f));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)mirror * 78.05f));
    }

    public static void applyThirdPerson(Player player, ModelPart leftArm, ModelPart rightArm) {
        if (player.getMainArm() == HumanoidArm.LEFT) {
            leftArm.xRot -= 0.62831855f;
        } else {
            rightArm.xRot -= 0.62831855f;
        }
    }

    public static void renderModelBlockingInHand(PoseStack poseStack, ItemStack itemStack, ItemDisplayContext displayContext, Player player, HumanoidArm arm, ArmedModel armedModel, MultiBufferSource buffer, int packedLight) {
        boolean leftArm = arm == HumanoidArm.LEFT;
        poseStack.pushPose();
        armedModel.translateToHand(arm, poseStack);
        poseStack.translate((leftArm ? 1.0f : -1.0f) / 16.0f, 0.4375f, 0.0625f);
        poseStack.translate(leftArm ? -0.035f : 0.05f, leftArm ? 0.045f : 0.0f, leftArm ? -0.135f : -0.1f);
        poseStack.mulPose(Axis.YP.rotationDegrees((leftArm ? -1.0f : 1.0f) * -50.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-10.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees((leftArm ? -1.0f : 1.0f) * -60.0f));
        poseStack.translate(0.0f, 0.1875f, 0.0f);
        poseStack.scale(0.625f, 0.625f, 0.625f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XN.rotationDegrees(-100.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees(leftArm ? 35.0f : 45.0f));
        poseStack.translate(0.0f, -0.3f, 0.0f);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(50.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(335.0f));
        poseStack.translate(-0.9375f, -0.0625f, 0.0f);
        poseStack.translate(0.5f, 0.5f, 0.25f);
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 0.0f, 0.28125f);
        BakedModel itemModel = Minecraft.getInstance().getItemRenderer().getModel(itemStack, player.level(), (LivingEntity)player, 0);
        ItemTransform transform = itemModel.getTransforms().getTransform(displayContext);
        if (transform != ItemTransform.NO_TRANSFORM) {
            float angle = (float)Math.PI / 180;
            float x = transform.rotation.x() * angle;
            float y = transform.rotation.y() * angle;
            float z = transform.rotation.z() * angle;
            if (leftArm) {
                y *= -1.0f;
                z *= -1.0f;
            }
            Quaternionf quaternion = new Quaternionf().rotationXYZ(x, y, z);
            quaternion.conjugate();
            poseStack.scale(1.0f / transform.scale.x(), 1.0f / transform.scale.y(), 1.0f / transform.scale.z());
            poseStack.mulPose(quaternion);
            poseStack.translate((leftArm ? -1.0f : 1.0f) * -transform.translation.x(), -transform.translation.y(), -transform.translation.z());
        }
        Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem((LivingEntity)player, itemStack, displayContext, leftArm, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

