/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay.combat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public abstract class DamageHelper {
    private static final Map<String, ItemAttributeModifiers> DAMAGE_MODIFIERS = new ConcurrentHashMap<String, ItemAttributeModifiers>();

    private static float getAttackDamage(TieredItem tieredItem) {
        TieredItem tieredItem2 = tieredItem;
        Objects.requireNonNull(tieredItem2);
        TieredItem tieredItem3 = tieredItem2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SwordItem.class, AxeItem.class, PickaxeItem.class, ShovelItem.class}, (Object)tieredItem3, n)) {
            case 0 -> {
                SwordItem sword = (SwordItem)tieredItem3;
                yield sword.getTier().getAttackDamageBonus() + 4.0f;
            }
            case 1 -> {
                AxeItem axe = (AxeItem)tieredItem3;
                yield axe.getTier().getAttackDamageBonus() + 3.0f;
            }
            case 2 -> {
                PickaxeItem pickaxe = (PickaxeItem)tieredItem3;
                yield pickaxe.getTier().getAttackDamageBonus() + 2.0f;
            }
            case 3 -> {
                ShovelItem shovel = (ShovelItem)tieredItem3;
                yield shovel.getTier().getAttackDamageBonus() + 1.0f;
            }
            default -> tieredItem.getTier().getAttackDamageBonus();
        };
    }

    public static boolean isApplicable(TieredItem tieredItem) {
        TieredItem tieredItem2 = tieredItem;
        Objects.requireNonNull(tieredItem2);
        TieredItem tieredItem3 = tieredItem2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SwordItem.class, AxeItem.class, PickaxeItem.class, ShovelItem.class, HoeItem.class}, (Object)tieredItem3, n)) {
            case 0 -> {
                SwordItem ignored = (SwordItem)tieredItem3;
                yield true;
            }
            case 1 -> {
                AxeItem ignored = (AxeItem)tieredItem3;
                yield true;
            }
            case 2 -> {
                PickaxeItem ignored = (PickaxeItem)tieredItem3;
                yield true;
            }
            case 3 -> {
                ShovelItem ignored = (ShovelItem)tieredItem3;
                yield true;
            }
            case 4 -> {
                HoeItem ignored = (HoeItem)tieredItem3;
                yield true;
            }
            default -> false;
        };
    }

    public static ItemAttributeModifiers get(TieredItem tieredItem, ItemAttributeModifiers attributes) {
        return DAMAGE_MODIFIERS.computeIfAbsent(tieredItem.getDescriptionId(), itemClass -> {
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            attributes.modifiers().forEach(entry -> {
                if (entry.attribute() != Attributes.ATTACK_DAMAGE) {
                    builder.add(entry.attribute(), entry.modifier(), entry.slot());
                } else if (tieredItem instanceof DiggerItem || tieredItem instanceof SwordItem) {
                    builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)DamageHelper.getAttackDamage(tieredItem), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                } else {
                    builder.add(entry.attribute(), entry.modifier(), entry.slot());
                }
            });
            return builder.build();
        });
    }
}

