/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import mod.adrenix.nostalgic.mixin.access.SheepAccess;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.factory.TweakFlag;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class MobLootHelper {
    private static final Map<EntityType<?>, EntityLoot> LOOT_MAP = new HashMap();
    private static final BiFunction<RegistryAccess, ItemLike, LootTable> WOOL_TABLE = Util.memoize((registries, item) -> MobLootHelper.makeTable(registries, item, 1));

    private static LootTable.Builder addToTable(LootTable.Builder builder, RegistryAccess registries, ItemLike item, int max, boolean canSmelt) {
        if (canSmelt) {
            return builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)max))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true))))))));
        }
        return builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)max))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    private static LootTable makeTable(RegistryAccess registries, ItemLike item, int max) {
        return MobLootHelper.addToTable(LootTable.lootTable(), registries, item, max, false).build();
    }

    private static LootTable makePorkTable(RegistryAccess registries) {
        return MobLootHelper.addToTable(LootTable.lootTable(), registries, (ItemLike)Items.PORKCHOP, 2, true).build();
    }

    private static LootTable makeSkeletonTable(RegistryAccess registries) {
        LootTable.Builder builder = LootTable.lootTable();
        MobLootHelper.addToTable(builder, registries, (ItemLike)Items.ARROW, 2, false);
        MobLootHelper.addToTable(builder, registries, (ItemLike)Items.BONE, 2, false);
        return builder.build();
    }

    public static void init(ServerLevel level) {
        RegistryAccess registries = level.registryAccess();
        LootTable COOKED_PORK_CHOP_TABLE = MobLootHelper.makeTable(registries, (ItemLike)Items.COOKED_PORKCHOP, 2);
        LootTable FEATHER_TABLE = MobLootHelper.makeTable(registries, (ItemLike)Items.FEATHER, 2);
        LootTable STRING_TABLE = MobLootHelper.makeTable(registries, (ItemLike)Items.STRING, 2);
        LootTable LEATHER_TABLE = MobLootHelper.makeTable(registries, (ItemLike)Items.LEATHER, 2);
        LootTable RABBIT_HIDE_TABLE = MobLootHelper.makeTable(registries, (ItemLike)Items.RABBIT_HIDE, 1);
        LootTable PORK_CHOP_TABLE = MobLootHelper.makePorkTable(registries);
        LootTable ARROW_BONE_TABLE = MobLootHelper.makeSkeletonTable(registries);
        new EntityLoot(EntityType.ZOMBIFIED_PIGLIN, GameplayTweak.OLD_ZOMBIE_PIGMEN_DROPS, COOKED_PORK_CHOP_TABLE);
        new EntityLoot(EntityType.ZOMBIE, GameplayTweak.OLD_ZOMBIE_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.ZOMBIE_VILLAGER, GameplayTweak.OLD_STYLE_ZOMBIE_VILLAGER_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.DROWNED, GameplayTweak.OLD_STYLE_DROWNED_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.HUSK, GameplayTweak.OLD_STYLE_HUSK_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.SPIDER, GameplayTweak.OLD_SPIDER_DROPS, STRING_TABLE);
        new EntityLoot(EntityType.CAVE_SPIDER, GameplayTweak.OLD_STYLE_CAVE_SPIDER_DROPS, STRING_TABLE);
        new EntityLoot(EntityType.COW, GameplayTweak.OLD_COW_DROPS, LEATHER_TABLE);
        new EntityLoot(EntityType.MOOSHROOM, GameplayTweak.OLD_STYLE_MOOSHROOM_DROPS, LEATHER_TABLE);
        new EntityLoot(EntityType.RABBIT, GameplayTweak.OLD_STYLE_RABBIT_DROPS, RABBIT_HIDE_TABLE);
        new EntityLoot(EntityType.CHICKEN, GameplayTweak.OLD_CHICKEN_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.PIG, GameplayTweak.OLD_PIG_DROPS, PORK_CHOP_TABLE);
        new EntityLoot(EntityType.STRAY, GameplayTweak.OLD_STYLE_STRAY_DROPS, ARROW_BONE_TABLE);
    }

    public static LootTable getTable(Entity entity, LootTable vanilla) {
        EntityType entityType = entity.getType();
        if (LOOT_MAP.containsKey(entityType)) {
            return LOOT_MAP.get(entityType).getTable(vanilla);
        }
        if (entityType == EntityType.SHEEP && ((Boolean)GameplayTweak.OLD_SHEEP_DROPS.get()).booleanValue()) {
            Sheep sheep = (Sheep)entityType.tryCast(entity);
            RegistryAccess registries = entity.level().registryAccess();
            if (sheep != null && !sheep.isSheared()) {
                return WOOL_TABLE.apply(registries, SheepAccess.NT$ITEM_BY_DYE().get(sheep.getColor()));
            }
            return LootTable.EMPTY;
        }
        return vanilla;
    }

    private record EntityLoot(EntityType<?> entityType, TweakFlag tweak, LootTable lootTable) {
        EntityLoot(EntityType<?> entityType, TweakFlag tweak, LootTable lootTable) {
            LOOT_MAP.put(entityType, this);
            this.entityType = entityType;
            this.tweak = tweak;
            this.lootTable = lootTable;
        }

        LootTable getTable(LootTable vanilla) {
            if (((Boolean)this.tweak.get()).booleanValue()) {
                return this.lootTable;
            }
            return vanilla;
        }
    }
}

