/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import mod.adrenix.nostalgic.mixin.access.FireBlockAccess;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public abstract class FireBlockHelper {
    private static void checkBurnOut(FireBlockAccess fire, ServerLevel level, BlockPos blockPos, RandomSource randomSource, int randomizeBound) {
        BlockState blockState = level.getBlockState(blockPos);
        int burnOdds = fire.nt$getBurnOdds(blockState);
        if (randomSource.nextInt(randomizeBound) < burnOdds) {
            if (randomSource.nextInt(2) == 0 && !level.isRainingAt(blockPos)) {
                level.setBlock(blockPos, fire.nt$getStateWithAge((LevelAccessor)level, blockPos, 0), 3);
            } else {
                level.removeBlock(blockPos, false);
            }
            if (blockState.getBlock() instanceof TntBlock) {
                TntBlock.explode((Level)level, (BlockPos)blockPos);
            }
        }
    }

    public static void tick(FireBlockAccess fire, ServerLevel level, BlockPos blockPos, BlockState blockState, RandomSource randomSource, CallbackInfo callback) {
        int nextAge;
        BlockPos belowPos = blockPos.below();
        BlockState belowState = level.getBlockState(belowPos);
        boolean isAboveInfiniteBurn = belowState.is(level.dimensionType().infiniburn());
        int fireAge = (Integer)blockState.getValue((Property)FireBlock.AGE);
        if (fireAge != (nextAge = Math.min(15, fireAge + 1))) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)FireBlock.AGE, (Comparable)Integer.valueOf(nextAge)), 4);
        }
        if (!isAboveInfiniteBurn) {
            if (!fire.nt$isValidFireLocation((BlockGetter)level, blockPos)) {
                if (!level.getBlockState(belowPos).isFaceSturdy((BlockGetter)level, belowPos, Direction.UP) || fireAge > 3) {
                    level.removeBlock(blockPos, false);
                }
                callback.cancel();
                return;
            }
            if (fireAge == 15 && randomSource.nextInt(4) == 0 && !fire.nt$canBurn(belowState)) {
                level.removeBlock(blockPos, false);
                callback.cancel();
                return;
            }
        }
        if (fireAge % 2 == 0 && fireAge > 2) {
            FireBlockHelper.checkBurnOut(fire, level, blockPos.east(), randomSource, 300);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.west(), randomSource, 300);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.below(), randomSource, 250);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.above(), randomSource, 250);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.north(), randomSource, 300);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.south(), randomSource, 300);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    for (int offsetY = -1; offsetY <= 4; ++offsetY) {
                        if (offsetX == 0 && offsetY == 0 && offsetZ == 0) continue;
                        int bound = 100;
                        if (offsetY > 1) {
                            bound += (offsetY - 1) * 100;
                        }
                        mutablePos.setWithOffset((Vec3i)blockPos, offsetX, offsetY, offsetZ);
                        int igniteOdds = fire.nt$getIgniteOdds((LevelReader)level, (BlockPos)mutablePos);
                        if (igniteOdds <= 0 || randomSource.nextInt(bound) > igniteOdds || level.isRaining() && fire.nt$isNearRain((Level)level, (BlockPos)mutablePos)) continue;
                        level.setBlock((BlockPos)mutablePos, fire.nt$getStateWithAge((LevelAccessor)level, (BlockPos)mutablePos, 0), 3);
                    }
                }
            }
        }
        if (fireAge == 15 && !((Boolean)GameplayTweak.INFINITE_BURN.get()).booleanValue()) {
            FireBlockHelper.checkBurnOut(fire, level, blockPos.east(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.west(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.below(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.above(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.north(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.south(), randomSource, 1);
        }
        callback.cancel();
    }
}

