/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class ClimbableHelper {
    private static boolean isClimbableWithinTwoBlocks(Level level, BlockPos blockPos) {
        boolean isBelowClimbable = level.getBlockState(blockPos.below()).is(BlockTags.CLIMBABLE);
        boolean isBelowNextClimbable = level.getBlockState(blockPos.below().below()).is(BlockTags.CLIMBABLE);
        return isBelowClimbable || isBelowNextClimbable;
    }

    public static boolean isClimbable(Level level, BlockState blockState, BlockPos blockPos) {
        if (blockState.getBlock() instanceof TrapDoorBlock && ((Boolean)blockState.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && ClimbableHelper.isClimbableWithinTwoBlocks(level, blockPos)) {
            return true;
        }
        BlockPos posAbove = blockPos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        if (stateAbove.getBlock() instanceof TrapDoorBlock && ((Boolean)stateAbove.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && ClimbableHelper.isClimbableWithinTwoBlocks(level, posAbove)) {
            return true;
        }
        return blockState.is(BlockTags.CLIMBABLE) || stateAbove.is(BlockTags.CLIMBABLE);
    }
}

