/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public abstract class BoatHelper {
    public static boolean isWaterLift(Boat.Status status) {
        return status == Boat.Status.UNDER_WATER || status == Boat.Status.UNDER_FLOWING_WATER;
    }

    public static double getGravityAmount(Boat boat, Boat.Status status) {
        return boat.getDeltaMovement().y + (boat.isNoGravity() || BoatHelper.isWaterLift(status) ? 0.0 : -0.04);
    }

    public static double getLiftAmount(double y) {
        return Mth.clamp((double)(y + 0.025), (double)y, (double)0.5);
    }

    public static void applyParticles(Boat boat) {
        Vec3 movement = boat.getDeltaMovement();
        double motionX = movement.x;
        double motionY = movement.y;
        double motionZ = movement.z;
        double prevDistance = Math.sqrt(motionX * motionX + motionZ * motionZ);
        if (prevDistance > 0.2625) {
            RandomSource randomSource = RandomSource.create();
            Vec3 position = boat.position();
            double posX = position.x;
            double posY = position.y;
            double posZ = position.z;
            double rotationYaw = boat.getYRot();
            double x = Math.cos(rotationYaw * Math.PI / 180.0);
            double y = Math.sin(rotationYaw * Math.PI / 180.0);
            int i = 0;
            while ((double)i < 1.0 + prevDistance * 60.0) {
                double randX = randomSource.nextFloat() * 2.0f - 1.0f;
                double randY = (double)(randomSource.nextInt(2) * 2 - 1) * 0.7;
                if (randomSource.nextBoolean()) {
                    double px = posX - x * randX * 0.8 + y * randY;
                    double py = posY + 0.5;
                    double pz = posZ - y * randX * 0.8 - x * randY;
                    boat.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, px, py, pz, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }
}

