/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import java.util.HashSet;
import java.util.Optional;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.listing.StringSet;
import mod.adrenix.nostalgic.util.common.LocateResource;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public abstract class AnimalSpawnHelper {
    private static final HashSet<ChunkPos> CHUNKS_TO_POLL = new HashSet();
    private static final IntegerHolder NUMBER_OF_ANIMALS = IntegerHolder.create(0);

    public static boolean isInList(EntityType<?> entityType) {
        return ((StringSet)GameplayTweak.OLD_ANIMAL_SPAWN_LIST.get()).contains(EntityType.getKey(entityType).toString());
    }

    public static boolean isPersistent(AgeableMob ageableMob) {
        return (Boolean)GameplayTweak.OLD_ANIMAL_SPAWNING.get() != false && (Boolean)GameplayTweak.KEEP_BABY_ANIMAL_WHILE_OLD_SPAWN.get() != false && AnimalSpawnHelper.isInList(ageableMob.getType());
    }

    public static void tickLevel(ServerLevel level, boolean spawnFriendlies) {
        if (!spawnFriendlies) {
            return;
        }
        CHUNKS_TO_POLL.clear();
        NUMBER_OF_ANIMALS.set(0);
        for (int i = 0; i < level.players().size(); ++i) {
            Player player = (Player)level.players().get(i);
            int dx = Mth.floor((double)(player.getX() / 16.0));
            int dz = Mth.floor((double)(player.getZ() / 16.0));
            for (int x = -8; x <= 8; ++x) {
                for (int z = -8; z <= 8; ++z) {
                    CHUNKS_TO_POLL.add(new ChunkPos(x + dx, z + dz));
                }
            }
        }
        for (Entity entity : level.getAllEntities()) {
            Animal animal;
            if (!(entity instanceof Animal) || !AnimalSpawnHelper.isInList((animal = (Animal)entity).getType()) || animal.isPersistenceRequired()) continue;
            NUMBER_OF_ANIMALS.increment();
        }
    }

    public static void tickChunk(LevelChunk chunk, ServerLevel level, boolean spawnFriendlies) {
        if (!spawnFriendlies || (Integer)NUMBER_OF_ANIMALS.get() > (Integer)GameplayTweak.ANIMAL_SPAWN_CAP.get() * CHUNKS_TO_POLL.size() / 256) {
            return;
        }
        BlockPos blockPos = AnimalSpawnHelper.getRandomPosWithin(level, chunk);
        if (blockPos.getY() < level.getMinBuildHeight() + 1) {
            return;
        }
        WeightedRandomList creatures = ((Biome)level.getBiomeManager().getBiome(blockPos).value()).getMobSettings().getMobs(MobCategory.CREATURE);
        int spawnCount = 0;
        block2: for (int i = 0; i < 3; ++i) {
            SpawnGroupData spawnGroupData = null;
            int x = blockPos.getX();
            int y = blockPos.getY();
            int z = blockPos.getZ();
            for (int j = 0; j < 4; ++j) {
                float oz;
                float oy;
                BlockPos spawnPos;
                float ox;
                float distance;
                float dz;
                float dy;
                float dx;
                x += level.random.nextInt(6) - level.random.nextInt(6);
                y += level.random.nextInt(1) - level.random.nextInt(1);
                z += level.random.nextInt(6) - level.random.nextInt(6);
                Optional spawnerData = creatures.getRandom(level.random);
                if (spawnerData.isEmpty()) continue block2;
                EntityType entityType = ((MobSpawnSettings.SpawnerData)spawnerData.get()).type;
                if (((Boolean)GameplayTweak.IGNORE_ANIMAL_BIOME_RESTRICTIONS.get()).booleanValue() && level.dimension().equals(Level.OVERWORLD)) {
                    int randomIndex;
                    String[] spawnList = (String[])((StringSet)GameplayTweak.OLD_ANIMAL_SPAWN_LIST.get()).stream().toArray(String[]::new);
                    Optional maybeEntity = BuiltInRegistries.ENTITY_TYPE.getOptional(LocateResource.from(spawnList[randomIndex = level.random.nextInt(spawnList.length)]));
                    if (maybeEntity.isEmpty()) continue block2;
                    entityType = (EntityType)maybeEntity.get();
                }
                if (!SpawnPlacements.isSpawnPositionOk((EntityType)entityType, (LevelReader)level, (BlockPos)blockPos) || level.getNearestPlayer((double)(dx = (float)x + 0.5f), (double)(dy = (float)y), (double)(dz = (float)z + 0.5f), 24.0, false) != null || !((distance = (ox = dx - (float)(spawnPos = level.getLevelData().getSpawnPos()).getX()) * ox + (oy = dy - (float)spawnPos.getY()) * oy + (oz = dz - (float)spawnPos.getZ()) * oz) >= 576.0f)) continue;
                Mob mob = null;
                try {
                    Entity entity = entityType.create((Level)level);
                    if (entity instanceof Mob) {
                        mob = (Mob)entity;
                    }
                }
                catch (Exception exception) {
                    NostalgicTweaks.LOGGER.warn("Failed to create mob\n%s", exception);
                }
                if (mob == null) {
                    return;
                }
                mob.moveTo((double)dx, (double)dy, (double)dz, level.random.nextFloat() * 360.0f, 0.0f);
                if (!AnimalSpawnHelper.isValidSpawnPositionForMob(level, mob)) continue;
                spawnGroupData = mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.NATURAL, spawnGroupData);
                level.addFreshEntityWithPassengers((Entity)mob);
                if (++spawnCount < mob.getMaxSpawnClusterSize()) continue;
                return;
            }
        }
    }

    public static BlockPos getRandomPosWithin(ServerLevel level, LevelChunk chunk) {
        ChunkPos chunkPos = chunk.getPos();
        int x = chunkPos.getMinBlockX() + level.random.nextInt(16);
        int z = chunkPos.getMinBlockZ() + level.random.nextInt(16);
        int height = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
        int y = Mth.randomBetweenInclusive((RandomSource)level.random, (int)level.getMinBuildHeight(), (int)height);
        return new BlockPos(x, y, z);
    }

    public static boolean isValidSpawnPositionForMob(ServerLevel level, Mob mob) {
        BlockPos blockPos = mob.blockPosition();
        if (level.getMaxLocalRawBrightness(blockPos) <= 8) {
            return false;
        }
        EntityType mobType = mob.getType();
        if (!AnimalSpawnHelper.isInList(mobType) || !mobType.canSummon()) {
            return false;
        }
        if (!SpawnPlacements.checkSpawnRules((EntityType)mobType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)blockPos, (RandomSource)level.random)) {
            return false;
        }
        return level.noCollision(mobType.getSpawnAABB((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5));
    }
}

