/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.screen.inventory;

import mod.adrenix.nostalgic.helper.candy.screen.inventory.SlotTracker;
import mod.adrenix.nostalgic.mixin.access.AbstractContainerScreenAccess;
import mod.adrenix.nostalgic.mixin.access.ImageButtonAccess;
import mod.adrenix.nostalgic.mixin.access.ScreenAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.InventoryShield;
import mod.adrenix.nostalgic.tweak.enums.RecipeBook;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryScreenHelper {
    private static final WidgetSprites SMALL_RECIPE_BUTTON = new WidgetSprites(ModSprite.RECIPE_BUTTON_SMALL, ModSprite.RECIPE_BUTTON_SMALL_HIGHLIGHTED);
    private static final WidgetSprites LARGE_RECIPE_BUTTON = new WidgetSprites(ModSprite.RECIPE_BUTTON_LARGE, ModSprite.RECIPE_BUTTON_LARGE_HIGHLIGHTED);

    @Nullable
    public static Slot setPositionsForSlots(NonNullList<Slot> slots, RecipeBookComponent recipes) {
        InventoryShield shield = (InventoryShield)CandyTweak.INVENTORY_SHIELD.get();
        Slot offHand = null;
        for (Slot slot : slots) {
            SlotTracker.CRAFT_TOP_LEFT.moveOrReset(slot, 88, 26);
            SlotTracker.CRAFT_TOP_RIGHT.moveOrReset(slot, 106, 26);
            SlotTracker.CRAFT_BOTTOM_LEFT.moveOrReset(slot, 88, 44);
            SlotTracker.CRAFT_BOTTOM_RIGHT.moveOrReset(slot, 106, 44);
            SlotTracker.CRAFT_RESULT.moveOrReset(slot, 144, 36);
            if (!SlotTracker.OFF_HAND.isEqualTo(slot)) continue;
            offHand = slot;
            if (InventoryShield.MODERN == shield) {
                SlotTracker.OFF_HAND.moveOrReset(slot, 152, 62);
            }
            switch (shield) {
                case INVISIBLE: {
                    SlotTracker.OFF_HAND.move(slot, -9999, -9999);
                    break;
                }
                case MIDDLE_RIGHT: {
                    SlotTracker.OFF_HAND.move(slot, 152, 62);
                    break;
                }
                case BOTTOM_LEFT: {
                    if (recipes.isVisible()) {
                        SlotTracker.OFF_HAND.move(slot, 174, 142);
                        break;
                    }
                    SlotTracker.OFF_HAND.move(slot, -14, 142);
                }
            }
        }
        return offHand;
    }

    private static ImageButton getLargeBook(AbstractContainerScreenAccess inventory, ImageButton original) {
        Button.OnPress onPress = button -> {
            original.onPress();
            button.setPosition(inventory.nt$getLeftPos() + 151, inventory.nt$getTopPos() + 7);
        };
        return new ImageButton(inventory.nt$getLeftPos() + 151, inventory.nt$getTopPos() + 7, 18, 18, LARGE_RECIPE_BUTTON, onPress);
    }

    private static ImageButton getSmallBook(AbstractContainerScreenAccess inventory, ImageButton original) {
        Button.OnPress onPress = button -> {
            original.onPress();
            button.setPosition(inventory.nt$getLeftPos() + 160, inventory.nt$getTopPos() + 7);
        };
        return new ImageButton(inventory.nt$getLeftPos() + 160, inventory.nt$getTopPos() + 7, 9, 10, SMALL_RECIPE_BUTTON, onPress);
    }

    public static void setRecipeButton(AbstractContainerScreenAccess inventory, RecipeBook bookType) {
        ImageButton recipeButton = null;
        Screen screen = Minecraft.getInstance().screen;
        if (screen == null) {
            throw new NullPointerException("Tried adding recipe book button to a null screen");
        }
        for (GuiEventListener widget : screen.children()) {
            ImageButton button;
            if (!(widget instanceof ImageButton) || !((ImageButtonAccess)(button = (ImageButton)widget)).nt$getSprites().equals((Object)RecipeBookComponent.RECIPE_BUTTON_SPRITES)) continue;
            recipeButton = button;
            break;
        }
        if (recipeButton == null) {
            return;
        }
        switch (bookType) {
            case DISABLED: {
                recipeButton.active = false;
                recipeButton.visible = false;
                break;
            }
            case LARGE: {
                ((ScreenAccess)screen).nt$removeWidget((GuiEventListener)recipeButton);
                ((ScreenAccess)screen).nt$addRenderableWidget(InventoryScreenHelper.getLargeBook(inventory, recipeButton));
                break;
            }
            case SMALL: {
                ((ScreenAccess)screen).nt$removeWidget((GuiEventListener)recipeButton);
                ((ScreenAccess)screen).nt$addRenderableWidget(InventoryScreenHelper.getSmallBook(inventory, recipeButton));
            }
        }
    }

    public static void renderOffHandSlot(GuiGraphics graphics, RecipeBookComponent recipes, @Nullable Slot offHand, int leftPos, int height) {
        boolean isModernOverride;
        InventoryShield shield = (InventoryShield)CandyTweak.INVENTORY_SHIELD.get();
        boolean bl = isModernOverride = (Boolean)CandyTweak.OLD_INVENTORY.get() != false && shield == InventoryShield.MODERN;
        if (InventoryShield.BOTTOM_LEFT == shield && offHand != null) {
            if (recipes.isVisible()) {
                graphics.blit(TextureLocation.INVENTORY, leftPos + 172, height / 2 + 51, 200, 33, 26, 32);
                SlotTracker.OFF_HAND.move(offHand, 174, 142);
            } else {
                graphics.blit(TextureLocation.INVENTORY, leftPos - 22, height / 2 + 51, 200, 0, 25, 32);
                SlotTracker.OFF_HAND.move(offHand, -14, 142);
            }
        } else if (InventoryShield.MIDDLE_RIGHT == shield || isModernOverride) {
            graphics.blit(TextureLocation.INVENTORY, leftPos + 151, height / 2 - 22, 178, 56, 18, 18);
        }
        if (!((Boolean)CandyTweak.OLD_INVENTORY.get()).booleanValue() && InventoryShield.MODERN != shield) {
            graphics.blit(TextureLocation.INVENTORY, leftPos + 76, height / 2 - 22, 178, 74, 18, 18);
        }
    }
}

