/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.screen;

import mod.adrenix.nostalgic.client.gui.widget.WidgetBackground;
import mod.adrenix.nostalgic.mixin.access.AbstractWidgetAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.resources.ResourceLocation;

public abstract class WidgetHelper {
    public static int getTextColor(AbstractWidget widget, float alpha) {
        Color color = Color.empty();
        if (!widget.isActive()) {
            color.set(Color.QUICK_SILVER);
        } else if (widget.isHoveredOrFocused() && widget.isActive()) {
            color.set(Color.LEMON_YELLOW);
        } else {
            color.set(Color.NOSTALGIC_GRAY);
        }
        color.setAlpha(alpha);
        return color.get();
    }

    public static boolean isOldStyleTabs() {
        return Minecraft.getInstance().screen instanceof CreateWorldScreen && (Boolean)CandyTweak.OLD_STYLE_CREATE_WORLD_TABS.get() != false;
    }

    public static void renderOldStyleTabs(AbstractWidget widget, GuiGraphics graphics, boolean isSelected) {
        ResourceLocation sprite = WidgetBackground.BUTTON.get(widget.isActive(), widget.isHoveredOrFocused() || isSelected);
        int color = isSelected ? Color.LEMON_YELLOW.get() : WidgetHelper.getTextColor(widget, 1.0f);
        widget.setY(1);
        widget.setHeight(20);
        int minX = widget.getX() + 1;
        int minY = widget.getY();
        int maxX = widget.getX() + widget.getWidth() - 1;
        int maxY = widget.getY() + widget.getHeight();
        WidgetBackground.BUTTON.render(graphics, sprite, widget.getX(), widget.getY(), widget.getWidth() - 1, widget.getHeight());
        AbstractWidgetAccess.nt$renderScrollingString(graphics, GuiUtil.font(), widget.getMessage(), minX, minY, maxX, maxY, color);
    }
}

