/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.screen;

import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.GuiBackground;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public abstract class ScreenHelper {
    public static boolean hasDirtBackground(ResourceLocation backgroundLocation) {
        if (!((Boolean)CandyTweak.OLD_DIRT_SCREEN_BACKGROUND.get()).booleanValue()) {
            return false;
        }
        boolean hasRowList = NullableResult.getOrElse(GuiUtil.getScreenOrNull(), false, screen -> screen.children().stream().anyMatch(widget -> ClassUtil.isInstanceOf(widget, AbstractSelectionList.class)));
        return Screen.MENU_BACKGROUND == backgroundLocation || hasRowList;
    }

    public static boolean renderColoredBackground(GuiGraphics graphics, int width, int height) {
        if (Minecraft.getInstance().level == null || GuiUtil.getScreenAs(ProgressScreen.class).isPresent()) {
            return true;
        }
        if (((Boolean)CandyTweak.APPLY_GUI_COLOR_BACKGROUND.get()).booleanValue()) {
            if (((Boolean)CandyTweak.CUSTOM_GUI_BACKGROUND.get()).booleanValue()) {
                int top = HexUtil.parseInt((String)CandyTweak.CUSTOM_GUI_TOP_GRADIENT.get());
                int bottom = HexUtil.parseInt((String)CandyTweak.CUSTOM_GUI_BOTTOM_GRADIENT.get());
                graphics.fillGradient(0, 0, width, height, top, bottom);
            } else {
                switch ((GuiBackground)CandyTweak.OLD_GUI_BACKGROUND.get()) {
                    case SOLID_BLACK: {
                        graphics.fillGradient(0, 0, width, height, -1072689136, -804253680);
                        break;
                    }
                    case SOLID_BLUE: {
                        graphics.fillGradient(0, 0, width, height, -1607454624, -1607454624);
                        break;
                    }
                    case GRADIENT_BLUE: {
                        graphics.fillGradient(0, 0, width, height, 0x60050500, -1607454624);
                    }
                }
            }
            return false;
        }
        return true;
    }
}

