/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.light;

import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.GameUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import org.jetbrains.annotations.NotNull;

public class NostalgicDataLayer
extends DataLayer {
    private final DataLayer parent;
    private final LightLayer layer;
    private final long sectionPos;

    public NostalgicDataLayer(DataLayer parent, LightLayer layer, long sectionPos) {
        this.parent = parent;
        this.layer = layer;
        this.sectionPos = sectionPos;
    }

    @NotNull
    public DataLayer copy() {
        return new NostalgicDataLayer(this.parent.copy(), this.layer, this.sectionPos);
    }

    public int get(int x, int y, int z) {
        int lightValue = this.parent.get(x, y, z);
        if (GameUtil.isOnIntegratedSeverThread()) {
            return lightValue;
        }
        return NostalgicDataLayer.getLightValue(this.layer, SectionPos.of((long)this.sectionPos).origin().offset(x, y, z), lightValue);
    }

    public static int getLightValue(LightLayer layer, BlockPos blockPos, int lightValue) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return lightValue;
        }
        if (((Boolean)CandyTweak.OLD_CLASSIC_ENGINE.get()).booleanValue()) {
            if (layer == LightLayer.BLOCK) {
                return 13;
            }
            return LightingHelper.getClassicLight(lightValue, level, blockPos);
        }
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue()) {
            if (layer == LightLayer.BLOCK) {
                return lightValue;
            }
            return LightingHelper.getCombinedLight(lightValue, level.getBrightness(LightLayer.BLOCK, blockPos));
        }
        return lightValue;
    }

    public void set(int x, int y, int z, int value) {
        this.parent.set(x, y, z, value);
    }

    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    public void fill(int defaultValue) {
        this.parent.fill(defaultValue);
    }

    public byte @NotNull [] getData() {
        return this.parent.getData();
    }

    public boolean isDefinitelyHomogenous() {
        return this.parent.isDefinitelyHomogenous();
    }

    public boolean isDefinitelyFilledWith(int value) {
        return this.parent.isDefinitelyFilledWith(value);
    }
}

