/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.light;

import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import mod.adrenix.nostalgic.helper.candy.block.ChestHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.data.Pair;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.Nullable;

public abstract class LightingHelper {
    private static final IntegerHolder TIME_SKYLIGHT = IntegerHolder.create(-1);
    private static final IntegerHolder WEATHER_SKYLIGHT = IntegerHolder.create(-1);
    private static final FlagHolder ENQUEUE_RELIGHT = FlagHolder.off();
    public static final ConcurrentHashMap<Block, Integer> LIGHT_BLOCK_CACHE = new ConcurrentHashMap();
    public static final ConcurrentLinkedDeque<Pair<Long, Byte>> PACKED_RELIGHT_QUEUE = new ConcurrentLinkedDeque();
    public static final ConcurrentLinkedDeque<Pair<Long, Long>> PACKED_CHUNK_BLOCK_QUEUE = new ConcurrentLinkedDeque();
    public static final ConcurrentLinkedDeque<Long> CHUNK_RELIGHT_QUEUE = new ConcurrentLinkedDeque();
    public static final HashSet<Long> SODIUM_REBUILD_QUEUE = new HashSet();
    public static final FlagHolder RELIGHT_ALL_CHUNKS = FlagHolder.off();

    public static void init() {
        CandyTweak.OLD_WATER_LIGHTING.whenChanged(LightingHelper::invalidateAndRelight);
        CandyTweak.CHEST_LIGHT_BLOCK.whenChanged(LightingHelper::invalidateAndRelight);
    }

    private static void invalidateAndRelight() {
        LIGHT_BLOCK_CACHE.clear();
        RELIGHT_ALL_CHUNKS.enable();
    }

    public static void resetLightingCache() {
        TIME_SKYLIGHT.set(-1);
        WEATHER_SKYLIGHT.set(-1);
        ENQUEUE_RELIGHT.disable();
        CHUNK_RELIGHT_QUEUE.clear();
        SODIUM_REBUILD_QUEUE.clear();
        PACKED_RELIGHT_QUEUE.clear();
        PACKED_CHUNK_BLOCK_QUEUE.clear();
    }

    public static boolean isRelightCheckEnqueued() {
        return (Boolean)ENQUEUE_RELIGHT.get();
    }

    public static void setRelightingAsFinished() {
        ENQUEUE_RELIGHT.disable();
    }

    public static void onTick() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        int skylightFromTime = LightingHelper.getSkyLightFromTime((Level)level);
        int skylightFromWeather = LightingHelper.getSkyLightFromWeather((Level)level);
        if ((Integer)TIME_SKYLIGHT.get() == -1 || (Integer)TIME_SKYLIGHT.get() != skylightFromTime) {
            TIME_SKYLIGHT.set(skylightFromTime);
            ENQUEUE_RELIGHT.enable();
        }
        if ((Integer)WEATHER_SKYLIGHT.get() == -1 || (Integer)WEATHER_SKYLIGHT.get() != skylightFromWeather) {
            WEATHER_SKYLIGHT.set(skylightFromWeather);
            if ((Integer)TIME_SKYLIGHT.get() > 4) {
                ENQUEUE_RELIGHT.enable();
            }
        }
    }

    public static void checkRelightQueues() {
        ClientLevel level = Minecraft.getInstance().level;
        LevelRenderer renderer = Minecraft.getInstance().levelRenderer;
        if (level == null) {
            return;
        }
        if (!PACKED_RELIGHT_QUEUE.isEmpty()) {
            Pair<Long, Byte> packedRelight = PACKED_RELIGHT_QUEUE.pop();
            ChunkPos chunkPos = new ChunkPos(packedRelight.left().longValue());
            LevelChunk chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
            if (chunk != null) {
                LightingHelper.relightChunk(chunk, packedRelight.right());
            } else if (renderer.isSectionCompiled(chunkPos.getWorldPosition())) {
                PACKED_RELIGHT_QUEUE.add(packedRelight);
            }
        }
        while (!CHUNK_RELIGHT_QUEUE.isEmpty()) {
            level.getChunkSource().onLightUpdate(LightLayer.BLOCK, SectionPos.of((long)CHUNK_RELIGHT_QUEUE.pop()));
        }
        for (int i = 0; i < 4096 && !PACKED_CHUNK_BLOCK_QUEUE.isEmpty(); ++i) {
            Pair<Long, Long> packedQueue = PACKED_CHUNK_BLOCK_QUEUE.pop();
            ChunkPos chunkPos = new ChunkPos(packedQueue.left().longValue());
            LevelChunk chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
            if (chunk != null) {
                BlockPos blockPos = BlockPos.of((long)packedQueue.right());
                int x = blockPos.getX() & 0xF;
                int y = blockPos.getY() & 0xF;
                int z = blockPos.getZ() & 0xF;
                NullableAction.attempt(chunk.getSkyLightSources(), skyLightSources -> skyLightSources.update((BlockGetter)chunk, x, y, z));
                chunk.getLevel().getLightEngine().checkBlock(blockPos);
                continue;
            }
            if (!renderer.isSectionCompiled(chunkPos.getWorldPosition())) continue;
            PACKED_CHUNK_BLOCK_QUEUE.add(packedQueue);
        }
    }

    public static int getNonEmissiveLightColor(BlockAndTintGetter level, BlockPos blockPos) {
        int skyLight = level.getBrightness(LightLayer.SKY, blockPos);
        int blockLight = level.getBrightness(LightLayer.BLOCK, blockPos);
        return skyLight << 20 | blockLight << 4;
    }

    public static int getWaterLight(BlockAndTintGetter level, BlockPos blockPos) {
        int center = LightingHelper.getNonEmissiveLightColor(level, blockPos);
        int above = LightingHelper.getNonEmissiveLightColor(level, blockPos.above());
        int below = LightingHelper.getNonEmissiveLightColor(level, blockPos.below());
        int north = LightingHelper.getNonEmissiveLightColor(level, blockPos.north());
        int south = LightingHelper.getNonEmissiveLightColor(level, blockPos.south());
        int west = LightingHelper.getNonEmissiveLightColor(level, blockPos.west());
        int east = LightingHelper.getNonEmissiveLightColor(level, blockPos.east());
        return MathUtil.getLargest(center, above, below, north, south, west, east);
    }

    public static int getSkyLightFromTime(Level level) {
        if (level.dimensionType().hasCeiling() || !level.dimensionType().hasSkyLight()) {
            return 0;
        }
        float time = level.getTimeOfDay(1.0f) * ((float)Math.PI * 2);
        int skyLight = 15;
        if (MathUtil.isInRange(time, 1.8235918f, 4.459594f)) {
            skyLight = 4;
        } else if (MathUtil.isInRange(time, 4.459884f, 4.5061855f) || MathUtil.isInRange(time, 1.7769997f, 1.8233016f)) {
            skyLight = 5;
        } else if (MathUtil.isInRange(time, 4.5064745f, 4.55252f) || MathUtil.isInRange(time, 1.7306658f, 1.7767112f)) {
            skyLight = 6;
        } else if (MathUtil.isInRange(time, 4.552807f, 4.5983024f) || MathUtil.isInRange(time, 1.684883f, 1.7303787f)) {
            skyLight = 7;
        } else if (MathUtil.isInRange(time, 4.598588f, 4.6440983f) || MathUtil.isInRange(time, 1.6390872f, 1.6845976f)) {
            skyLight = 8;
        } else if (MathUtil.isInRange(time, 4.6443815f, 4.689612f) || MathUtil.isInRange(time, 1.5938551f, 1.6388037f)) {
            skyLight = 9;
        } else if (MathUtil.isInRange(time, 4.6898937f, 4.735117f) || MathUtil.isInRange(time, 1.548349f, 1.5935733f)) {
            skyLight = 10;
        } else if (MathUtil.isInRange(time, 4.7353964f, 4.7805977f) || MathUtil.isInRange(time, 1.5028657f, 1.548069f)) {
            skyLight = 11;
        } else if (MathUtil.isInRange(time, 4.780876f, 4.826043f) || MathUtil.isInRange(time, 1.4571424f, 1.5025874f)) {
            skyLight = 12;
        } else if (MathUtil.isInRange(time, 4.826319f, 4.8719864f) || MathUtil.isInRange(time, 1.4111987f, 1.4568661f)) {
            skyLight = 13;
        } else if (MathUtil.isInRange(time, 4.8722606f, 4.9184027f) || MathUtil.isInRange(time, 1.3650552f, 1.4109247f)) {
            skyLight = 14;
        }
        return skyLight;
    }

    public static int getSkyLightFromWeather(Level level) {
        float partialTick = PartialTick.get();
        float rain = level.getRainLevel(partialTick);
        float thunder = level.getThunderLevel(partialTick);
        int rainDiff = 0;
        int thunderDiff = 0;
        if (rain >= 0.3f) {
            rainDiff = 1;
        }
        if (rain >= 0.6f) {
            rainDiff = 2;
        }
        if (rain >= 0.9f) {
            rainDiff = 3;
        }
        if (thunder >= 0.8f) {
            thunderDiff = 5;
        }
        return Math.max(rainDiff, thunderDiff);
    }

    public static int getCombinedLight(int skyLight, int blockLight) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || skyLight <= 0) {
            return 0;
        }
        int maxLightLevel = level.getMaxLightLevel();
        int lightFromTime = (Integer)TIME_SKYLIGHT.get();
        int weatherDiff = (Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0 : (Integer)WEATHER_SKYLIGHT.get();
        int minSkyLight = Math.max(0, (level.dimensionType().hasFixedTime() ? lightFromTime : maxLightLevel) - 11);
        int minLight = skyLight >= maxLightLevel ? minSkyLight : 0;
        int maxLight = Math.max(blockLight, (Integer)CandyTweak.MAX_BLOCK_LIGHT.get());
        int oldSkyLight = lightFromTime - weatherDiff;
        int offsetSkyLight = maxLightLevel - skyLight;
        if (skyLight != maxLightLevel && oldSkyLight <= minSkyLight) {
            oldSkyLight += weatherDiff;
        }
        return Mth.clamp((int)Math.max(oldSkyLight - offsetSkyLight, blockLight), (int)minLight, (int)maxLight);
    }

    public static int getClassicLight(int skyLight, ClientLevel level, BlockPos blockPos) {
        BlockPos abovePos = blockPos.above();
        if (!level.dimensionType().hasSkyLight()) {
            return 0;
        }
        if (skyLight >= level.getMaxLightLevel() || skyLight <= 0) {
            return skyLight;
        }
        while (abovePos.getY() < level.getMaxBuildHeight()) {
            boolean isSolid;
            BlockState blockState = level.getBlockState(abovePos);
            boolean isWater = blockState.is(Blocks.WATER);
            boolean bl = isSolid = level.getBlockState(abovePos).getLightBlock((BlockGetter)level, abovePos) >= level.getMaxLightLevel();
            if (isWater || isSolid) {
                return 0;
            }
            abovePos = abovePos.above();
        }
        return level.getMaxLightLevel();
    }

    public static void findBlocks(LevelChunk chunk, Predicate<BlockState> predicate, BiConsumer<BlockPos, BlockState> output) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = chunk.getMinSection(); i < chunk.getMaxSection(); ++i) {
            LevelChunkSection section = chunk.getSection(chunk.getSectionIndexFromSectionY(i));
            BlockPos blockPos = SectionPos.of((ChunkPos)chunk.getPos(), (int)i).origin();
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        BlockState blockState = section.getBlockState(x, y, z);
                        if (!predicate.test(blockState)) continue;
                        output.accept((BlockPos)mutablePos.setWithOffset((Vec3i)blockPos, x, y, z), blockState);
                    }
                }
            }
        }
    }

    public static void relightChunk(@Nullable LevelChunk chunk, byte allChanged) {
        if (chunk == null) {
            return;
        }
        boolean isChestLightBlocked = (Boolean)CandyTweak.CHEST_LIGHT_BLOCK.get();
        boolean isWaterDarker = (Boolean)CandyTweak.OLD_WATER_LIGHTING.get();
        if (!isChestLightBlocked && !isWaterDarker && allChanged != 1) {
            return;
        }
        CompletableFuture.runAsync(() -> LightingHelper.findBlocks(chunk, blockState -> {
            if (allChanged == 1) {
                return BlockUtil.isWaterLike(blockState) || BlockUtil.isChestLike(blockState);
            }
            boolean relightChest = isChestLightBlocked && ChestHelper.isOld(blockState);
            boolean relightWater = isWaterDarker && BlockUtil.isWaterLike(blockState);
            return relightChest || relightWater;
        }, (blockPos, blockState) -> {
            long packedChunk = chunk.getPos().toLong();
            long packedBlock = blockPos.asLong();
            PACKED_CHUNK_BLOCK_QUEUE.add(new Pair<Long, Long>(packedChunk, packedBlock));
        }), Util.backgroundExecutor());
    }
}

