/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.light;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.timer.LerpTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class LightTextureHelper {
    private static final FlagHolder CACHE_INITIALIZER = FlagHolder.off();
    private static final LerpTimer[][] LIGHTMAP_TIMERS = new LerpTimer[16][16];

    public static void resetLightingCache() {
        CACHE_INITIALIZER.disable();
    }

    public static void setClassicTexture(NativeImage lightPixels) {
        for (int skyLight = 0; skyLight < 16; ++skyLight) {
            for (int blockLight = 0; blockLight < 16; ++blockLight) {
                if (skyLight >= 14 || blockLight >= 14) {
                    lightPixels.setPixelRGBA(blockLight, skyLight, -1);
                    continue;
                }
                lightPixels.setPixelRGBA(blockLight, skyLight, -6710887);
            }
        }
    }

    public static float getLightmapBrightness(int i, boolean isSkyLight) {
        float brightness;
        double gammaSetting = (Double)Minecraft.getInstance().options.gamma().get();
        float light = 1.0f - (float)i / 15.0f;
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue()) {
            if (i <= 4 && !isSkyLight) {
                brightness = 3.0f;
            } else if (isSkyLight) {
                brightness = i >= 14 ? 0.0f : 2.6f;
            } else if (i < 14) {
                brightness = switch (i) {
                    case 13 -> 2.7f;
                    case 12 -> 3.0f;
                    default -> 3.4f;
                };
            } else {
                brightness = 1.8f;
            }
        } else if (i <= 4 && isSkyLight) {
            brightness = 2.6f;
        } else if (isSkyLight) {
            brightness = i >= 14 ? 0.0f : 2.6f;
        } else {
            brightness = switch (i) {
                case 15 -> 0.6f;
                case 14 -> 1.2f;
                case 13 -> 1.8f;
                case 11, 12 -> 2.4f;
                case 5, 9 -> 2.5f;
                case 4 -> 2.9f;
                default -> 2.6f;
            };
        }
        float lightmapBrightness = (1.0f - light) / (light * brightness + 1.0f) * 0.95f + 0.05f;
        if (gammaSetting > 0.0 && isSkyLight && i < 5 && ((Boolean)CandyTweak.DYNAMIC_LIGHT_BRIGHTNESS.get()).booleanValue()) {
            float ofGamma = switch (i) {
                case 1 -> 0.09f;
                case 2 -> 0.1f;
                case 3 -> 0.11f;
                case 4 -> 0.12f;
                default -> 0.08f;
            };
            float maxBrightness = LightTextureHelper.getLightmapBrightness(5, true) - 0.05f;
            float shiftBrightness = lightmapBrightness + (float)((double)ofGamma * gammaSetting);
            lightmapBrightness = Mth.clamp((float)shiftBrightness, (float)lightmapBrightness, (float)maxBrightness);
        }
        return lightmapBrightness;
    }

    public static int getSkylightSubtracted(ClientLevel level) {
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue()) {
            return 0;
        }
        boolean isNether = level.dimension() == Level.NETHER && (Boolean)CandyTweak.OLD_NETHER_LIGHTING.get() == false;
        float forceBrightness = isNether ? 7.0f : 15.0f;
        float skyDarken = 1.0f - (Mth.cos((float)(level.getTimeOfDay(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f);
        float rainLevel = (Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getRainLevel(1.0f);
        float thunderLevel = (Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getThunderLevel(1.0f);
        skyDarken = 1.0f - Mth.clamp((float)skyDarken, (float)0.0f, (float)1.0f);
        skyDarken = (float)((double)skyDarken * (1.0 - (double)(rainLevel * 5.0f) / 16.0));
        skyDarken = (float)((double)skyDarken * (1.0 - (double)(thunderLevel * 5.0f) / 16.0));
        skyDarken = 1.0f - skyDarken;
        return (int)(skyDarken * (forceBrightness - 4.0f) + (15.0f - forceBrightness));
    }

    public static void setGrayscaleTexture(NativeImage lightPixels, float darknessEffect, float partialTick) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (level == null || player == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        double gammaSetting = (Double)minecraft.options.gamma().get();
        float darkenAmount = minecraft.gameRenderer.getDarkenWorldAmount(partialTick);
        float waterVision = player.getWaterVision();
        float potionEffect = player.hasEffect(MobEffects.NIGHT_VISION) ? GameRenderer.getNightVisionScale((LivingEntity)player, (float)partialTick) : (waterVision > 0.0f && player.hasEffect(MobEffects.CONDUIT_POWER) ? waterVision : 0.0f);
        boolean isCacheInitialized = (Boolean)CACHE_INITIALIZER.get();
        boolean isSmoothTransition = (Boolean)CandyTweak.SMOOTH_LIGHT_TRANSITION.get() != false && (Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get() == false;
        boolean isGammaDisabled = (Boolean)CandyTweak.DISABLE_LIGHT_BRIGHTNESS.get();
        boolean isDynamicGamma = (Boolean)CandyTweak.DYNAMIC_LIGHT_BRIGHTNESS.get();
        boolean isFlashPresent = level.getSkyFlashTime() > 0 && (Boolean)minecraft.options.hideLightningFlash().get() == false;
        boolean isWorldDarkening = darkenAmount > 0.0f;
        int skyLightSubtracted = LightTextureHelper.getSkylightSubtracted(level);
        if (isFlashPresent) {
            skyLightSubtracted = 1;
        } else if (isWorldDarkening) {
            skyLightSubtracted = Mth.clamp((int)(skyLightSubtracted + (int)Math.ceil(3.0f * darkenAmount)), (int)1, (int)15);
        }
        float ambientLight = level.dimensionType().ambientLight();
        float minSkyLight = LightTextureHelper.getLightmapBrightness(15, true) * ambientLight;
        float minBlockLight = LightTextureHelper.getLightmapBrightness(15, false) * ambientLight;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float rgba;
                if (LIGHTMAP_TIMERS[x][y] == null) {
                    LightTextureHelper.LIGHTMAP_TIMERS[x][y] = LerpTimer.create(1L, TimeUnit.SECONDS);
                }
                float fromBlockLight = Math.max(LightTextureHelper.getLightmapBrightness(x, false), minBlockLight);
                float fromSkyLight = Math.max(LightTextureHelper.getLightmapBrightness(Math.max(y - skyLightSubtracted, 0), true), minSkyLight);
                if (level.dimension() == Level.END) {
                    fromSkyLight = 0.22f + fromSkyLight * 0.75f;
                }
                if (level.dimension() == Level.NETHER) {
                    fromSkyLight = 0.05f + fromSkyLight * 0.75f;
                }
                if (potionEffect > 0.0f) {
                    float shiftBrightness = potionEffect * 0.7f;
                    float adjustBlockColor = (1.0f - fromBlockLight - 0.5f) * (shiftBrightness * fromBlockLight) + 0.5f * potionEffect;
                    float skyAdjust = (1.0f - fromSkyLight - 0.5f) * (shiftBrightness * fromSkyLight) + 0.5f * potionEffect;
                    fromBlockLight += adjustBlockColor;
                    fromSkyLight += skyAdjust;
                }
                if (darknessEffect > 0.0f && x != 15) {
                    fromBlockLight -= darknessEffect;
                    fromSkyLight -= darknessEffect;
                    fromBlockLight = Mth.clamp((float)fromBlockLight, (float)0.025f, (float)1.0f);
                    fromSkyLight = Mth.clamp((float)fromSkyLight, (float)0.025f, (float)1.0f);
                }
                double gamma = isGammaDisabled || isDynamicGamma ? 0.0 : gammaSetting;
                float skyLight = Mth.clamp((float)(fromSkyLight * 255.0f * ((float)gamma + 1.0f)), (float)6.375f, (float)255.0f);
                float blockLight = Mth.clamp((float)(fromBlockLight * 255.0f * ((float)gamma + 1.0f)), (float)6.375f, (float)255.0f);
                float f = rgba = fromBlockLight > fromSkyLight ? blockLight : skyLight;
                if (isSmoothTransition && isCacheInitialized) {
                    rgba = LIGHTMAP_TIMERS[x][y].setAndGetTarget(Float.valueOf(rgba), LerpTimer::lerpFloat).floatValue();
                }
                int light = Math.round(rgba);
                lightPixels.setPixelRGBA(x, y, 0xFF000000 | light << 16 | light << 8 | light);
            }
        }
        if (!isCacheInitialized) {
            CACHE_INITIALIZER.enable();
        }
    }
}

