/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level.fog;

import com.mojang.blaze3d.shaders.FogShape;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.helper.candy.level.fog.OverworldFogRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.WorldFog;
import mod.adrenix.nostalgic.util.client.CameraUtil;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import mod.adrenix.nostalgic.util.common.timer.LerpTimer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.FogType;

public abstract class WaterFogRenderer {
    private static final ArrayList<LerpTimer> LERP_TIMERS = new ArrayList();
    private static final LerpTimer DENSITY = WaterFogRenderer.makeTimer();
    private static final LerpTimer FOG_RED = WaterFogRenderer.makeTimer();
    private static final LerpTimer FOG_GREEN = WaterFogRenderer.makeTimer();
    private static final LerpTimer FOG_BLUE = WaterFogRenderer.makeTimer();

    private static LerpTimer makeTimer() {
        LerpTimer timer = LerpTimer.create(2L, TimeUnit.SECONDS);
        LERP_TIMERS.add(timer);
        return timer;
    }

    public static void reset() {
        LERP_TIMERS.forEach(LerpTimer::clear);
    }

    private static float getRed(int brightness, float respiration) {
        float red = switch (brightness) {
            case 12, 13, 14, 15 -> 9.0f;
            case 9, 10, 11 -> 6.0f;
            case 3, 4, 5, 6, 7, 8 -> 5.0f;
            default -> 4.0f;
        };
        FOG_RED.setTarget(Float.valueOf((respiration > 0.0f ? 19.0f : red) / 255.0f));
        return (Boolean)CandyTweak.SMOOTH_WATER_COLOR.get() != false ? FOG_RED.lerpFloat() : FOG_RED.endFloat();
    }

    private static float getGreen(int brightness, float respiration) {
        float green = switch (brightness) {
            case 12, 13, 14, 15 -> 16.0f;
            case 9, 10, 11 -> 11.0f;
            case 6, 7, 8 -> 8.0f;
            case 3, 4, 5 -> 7.0f;
            default -> 5.0f;
        };
        FOG_GREEN.setTarget(Float.valueOf((respiration > 0.0f ? 35.0f : green) / 255.0f));
        return (Boolean)CandyTweak.SMOOTH_WATER_COLOR.get() != false ? FOG_GREEN.lerpFloat() : FOG_GREEN.endFloat();
    }

    private static float getBlue(int brightness, float respiration) {
        float blue = switch (brightness) {
            case 12, 13, 14, 15 -> 73.0f;
            case 9, 10, 11 -> 58.0f;
            case 6, 7, 8 -> 50.0f;
            case 3, 4, 5 -> 45.0f;
            default -> 41.0f;
        };
        FOG_BLUE.setTarget(Float.valueOf((respiration > 0.0f ? 150.0f : blue) / 255.0f));
        return (Boolean)CandyTweak.SMOOTH_WATER_COLOR.get() != false ? FOG_BLUE.lerpFloat() : FOG_BLUE.endFloat();
    }

    public static boolean setupFog(Camera camera, Consumer<FogShape> fogShape, Consumer<Float> fogStart, Consumer<Float> fogEnd) {
        if (!((Boolean)CandyTweak.OLD_WATER_FOG_DENSITY.get()).booleanValue() || camera.getFluidInCamera() != FogType.WATER) {
            return false;
        }
        float density = 16.0f;
        fogShape.accept(FogShape.SPHERE);
        fogStart.accept(Float.valueOf(-16.0f));
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity instanceof LivingEntity) {
            double respiration;
            LivingEntity entity2 = (LivingEntity)entity;
            if (MobEffectUtil.hasWaterBreathing((LivingEntity)entity2)) {
                density = (float)OverworldFogRenderer.getFarPlaneDistance((WorldFog)CandyTweak.OLD_WORLD_FOG.get()) * 0.3f;
            }
            if ((respiration = NullableResult.getOrElse(entity2.getAttribute(Attributes.OXYGEN_BONUS), 0.0, AttributeInstance::getValue).doubleValue()) > 0.0) {
                density = Math.max(density, density * (float)respiration * 3.0f);
            }
        }
        DENSITY.setTarget(Float.valueOf(Math.min(density, (float)OverworldFogRenderer.getFarPlaneDistance(WorldFog.MODERN))));
        fogEnd.accept(Float.valueOf((Boolean)CandyTweak.SMOOTH_WATER_DENSITY.get() != false ? DENSITY.lerpFloat() : DENSITY.endFloat()));
        return true;
    }

    public static boolean setupColor(Camera camera, Consumer<Float> red, Consumer<Float> green, Consumer<Float> blue) {
        if (Minecraft.getInstance().level == null || camera.getFluidInCamera() != FogType.WATER || CameraUtil.isBlind(camera)) {
            return false;
        }
        if (((Boolean)CandyTweak.OLD_WATER_FOG_COLOR.get()).booleanValue() && !((Boolean)GameUtil.MOB_EFFECT_ACTIVE.get()).booleanValue()) {
            int brightness = Minecraft.getInstance().level.getBrightness(LightLayer.SKY, camera.getBlockPosition());
            double bonus = NullableResult.getOrElse(((LivingEntity)camera.getEntity()).getAttribute(Attributes.OXYGEN_BONUS), 0.0, AttributeInstance::getValue);
            float respiration = (float)bonus * 0.2f;
            red.accept(Float.valueOf(WaterFogRenderer.getRed(brightness, respiration)));
            green.accept(Float.valueOf(WaterFogRenderer.getGreen(brightness, respiration)));
            blue.accept(Float.valueOf(WaterFogRenderer.getBlue(brightness, respiration)));
            return true;
        }
        return false;
    }
}

