/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level.fog;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.helper.candy.level.ClientLevelHelper;
import mod.adrenix.nostalgic.helper.candy.level.fog.OverworldFogRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.CameraUtil;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.timer.LerpTimer;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public abstract class VoidFogRenderer {
    private static final ArrayList<LerpTimer> LERP_TIMERS = new ArrayList();
    private static final LerpTimer CELESTIAL_TRANSPARENCY = VoidFogRenderer.makeTimer();
    private static final LerpTimer CLOUDS_TRANSPARENCY = VoidFogRenderer.makeTimer();
    private static final LerpTimer STARS_TRANSPARENCY = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_START = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_END = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_RED = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_GREEN = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_BLUE = VoidFogRenderer.makeTimer();
    private static final LerpTimer VOID_RED = VoidFogRenderer.makeTimer();
    private static final LerpTimer VOID_GREEN = VoidFogRenderer.makeTimer();
    private static final LerpTimer VOID_BLUE = VoidFogRenderer.makeTimer();
    private static final LerpTimer SKY_RED = VoidFogRenderer.makeTimer();
    private static final LerpTimer SKY_GREEN = VoidFogRenderer.makeTimer();
    private static final LerpTimer SKY_BLUE = VoidFogRenderer.makeTimer();

    private static LerpTimer makeTimer() {
        LerpTimer timer = LerpTimer.create(2L, TimeUnit.SECONDS);
        LERP_TIMERS.add(timer);
        return timer;
    }

    public static void reset() {
        LERP_TIMERS.forEach(LerpTimer::clear);
    }

    private static void setTarget(LerpTimer timer, float target) {
        if (timer.isFinished() && VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            timer.stopAndSetTarget(Float.valueOf(target));
        } else {
            timer.setTarget(Float.valueOf(target));
        }
    }

    public static void setStarsTransparency(float alpha) {
        VoidFogRenderer.setTarget(STARS_TRANSPARENCY, Mth.clamp((float)alpha, (float)0.0f, (float)1.0f));
    }

    public static void setSkyRed(float red) {
        if (VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            VoidFogRenderer.setTarget(SKY_RED, Mth.clamp((float)red, (float)0.0f, (float)1.0f));
        }
    }

    public static void setSkyGreen(float green) {
        if (VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            VoidFogRenderer.setTarget(SKY_GREEN, Mth.clamp((float)green, (float)0.0f, (float)1.0f));
        }
    }

    public static void setSkyBlue(float blue) {
        if (VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            VoidFogRenderer.setTarget(SKY_BLUE, Mth.clamp((float)blue, (float)0.0f, (float)1.0f));
        }
    }

    public static float getSkyRed() {
        return SKY_RED.lerpFloat();
    }

    public static float getSkyGreen() {
        return SKY_GREEN.lerpFloat();
    }

    public static float getSkyBlue() {
        return SKY_BLUE.lerpFloat();
    }

    public static void setVoidRGB(float red, float green, float blue) {
        if (!VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            return;
        }
        VoidFogRenderer.setTarget(VOID_RED, Mth.clamp((float)red, (float)0.0f, (float)1.0f));
        VoidFogRenderer.setTarget(VOID_GREEN, Mth.clamp((float)green, (float)0.0f, (float)1.0f));
        VoidFogRenderer.setTarget(VOID_BLUE, Mth.clamp((float)blue, (float)0.0f, (float)1.0f));
    }

    public static float[] getVoidRGB() {
        return new float[]{VOID_RED.lerpFloat(), VOID_GREEN.lerpFloat(), VOID_BLUE.lerpFloat()};
    }

    public static float getStarsTransparency() {
        return STARS_TRANSPARENCY.lerpFloat();
    }

    public static boolean isRendering() {
        return (Boolean)CandyTweak.RENDER_VOID_FOG.get();
    }

    private static boolean isDisabled(Camera camera) {
        boolean isNotSurvival = GameUtil.isNotSurvivalMode();
        boolean isHeightOutOfBounds = (double)((Integer)CandyTweak.VOID_FOG_START.get()).intValue() < camera.getEntity().getY() + 0.5;
        boolean isCreativeOverride = (Boolean)CandyTweak.CREATIVE_VOID_FOG.get() == false && isNotSurvival;
        boolean isVoidFogDisabled = (Boolean)CandyTweak.RENDER_VOID_FOG.get() == false;
        return isVoidFogDisabled || isHeightOutOfBounds || isCreativeOverride || VoidFogRenderer.isAboveHorizon();
    }

    public static boolean isGameOverride(Camera camera) {
        return VoidFogRenderer.isDisabled(camera) || CameraUtil.canSeeSky(camera) || CameraUtil.isInFluid(camera);
    }

    public static void setCelestialTransparency() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        float weather = (Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getRainLevel(PartialTick.get());
        float alpha = Math.min(1.0f - weather, CELESTIAL_TRANSPARENCY.lerpFloat());
        float[] rgb = RenderSystem.getShaderColor();
        RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
    }

    public static void setCloudTransparency() {
        float[] rgb = RenderSystem.getShaderColor();
        float alpha = CLOUDS_TRANSPARENCY.lerpFloat();
        RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
    }

    private static boolean isAboveHorizon() {
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            return true;
        }
        return !(player.getEyePosition((float)PartialTick.get()).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level) < 0.0);
    }

    private static int getMinBuildHeight(Entity entity) {
        return entity.level().getMinBuildHeight();
    }

    private static double getAbsoluteY(Entity entity) {
        return entity.getY() - (double)VoidFogRenderer.getMinBuildHeight(entity);
    }

    private static float getFogStart(Camera camera, float distance) {
        return CameraUtil.isFoggy(camera) ? distance * 0.05f : distance * Math.max(0.0f, 0.55f * (1.0f - (distance - 5.0f) / 127.0f));
    }

    private static float getFogEnd(Camera camera, float distance) {
        return CameraUtil.isFoggy(camera) ? Math.min(distance, 192.0f) / 2.0f : distance;
    }

    private static int getMaxLight(Entity entity) {
        int light = (Boolean)CandyTweak.LIGHT_REMOVES_VOID_FOG.get() != false ? entity.level().getMaxLocalRawBrightness(entity.blockPosition()) : ClientLevelHelper.getSkyLight(entity);
        int encroachment = (int)((1.0f - (float)((Integer)CandyTweak.VOID_FOG_ENCROACH.get()).intValue() / 100.0f) * 15.0f);
        return Mth.clamp((int)(light + encroachment), (int)0, (int)15);
    }

    private static float getDarknessValue(Camera camera) {
        int fogStart = (Integer)CandyTweak.VOID_FOG_START.get();
        int skyLight = ClientLevelHelper.getSkyLight(camera.getEntity());
        int maxHeight = fogStart - VoidFogRenderer.getMinBuildHeight(camera.getEntity());
        float heightShift = (float)VoidFogRenderer.getAbsoluteY(camera.getEntity()) / (float)maxHeight;
        return Math.max((float)Math.pow(Math.max(heightShift, (float)skyLight / 15.0f), 4.0), 0.05f);
    }

    private static float getDistance(Entity entity) {
        float renderDistance = Minecraft.getInstance().gameRenderer.getRenderDistance();
        double fogStart = ((Integer)CandyTweak.VOID_FOG_START.get()).intValue();
        double fogDistance = (double)VoidFogRenderer.getMaxLight(entity) / 16.0 + VoidFogRenderer.getAbsoluteY(entity) / (fogStart == 0.0 ? 1.0 : fogStart);
        return fogDistance >= 1.0 ? renderDistance : (float)Mth.clamp((double)(100.0 * Math.pow(Math.max(fogDistance, 0.0), 2.0)), (double)5.0, (double)renderDistance);
    }

    private static float getDistanceDelta(Entity entity) {
        return Math.max(1.0f, Math.min(1.0f, 1.0f - ((float)VoidFogRenderer.getAbsoluteY(entity) - (float)((Integer)CandyTweak.VOID_FOG_START.get()).intValue() - 15.0f) / 15.0f));
    }

    public static void addParticles(RandomSource randomSource) {
        boolean isDisabled;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        ClientLevel level = Minecraft.getInstance().level;
        boolean isFogDisabled = (Boolean)CandyTweak.RENDER_VOID_FOG.get() == false || VoidFogRenderer.isAboveHorizon();
        boolean isCreativeDisabled = (Boolean)CandyTweak.CREATIVE_VOID_PARTICLES.get() == false && GameUtil.isCreativeMode();
        boolean bl = isDisabled = isFogDisabled || isCreativeDisabled;
        if (isDisabled || entity == null || level == null) {
            return;
        }
        BlockPos playerPos = entity.blockPosition();
        int radius = (Integer)CandyTweak.VOID_PARTICLE_RADIUS.get();
        int particleStart = (Integer)CandyTweak.VOID_PARTICLE_START.get();
        float density = (float)((Integer)CandyTweak.VOID_PARTICLE_DENSITY.get()).intValue() / 100.0f;
        if (GameUtil.isInOverworld() && Math.random() <= (double)density && entity.getY() <= (double)particleStart) {
            BlockPos randX = BlockUtil.getRandom(randomSource, radius);
            BlockPos randY = BlockUtil.getRandom(randomSource, radius);
            BlockPos randPos = randX.subtract((Vec3i)randY).offset((Vec3i)playerPos);
            BlockState blockState = level.getBlockState(randPos);
            FluidState fluidState = level.getFluidState(randPos);
            if (blockState.isAir() && fluidState.isEmpty() && randPos.getY() <= particleStart && randomSource.nextInt(8) <= particleStart - level.getMinBuildHeight()) {
                double px = (float)randPos.getX() + randomSource.nextFloat();
                double py = (float)randPos.getY() + randomSource.nextFloat();
                double pz = (float)randPos.getZ() + randomSource.nextFloat();
                boolean nearBedrock = BlockUtil.isNearBedrock(randPos, (Level)level);
                double ySpeed = nearBedrock ? (double)randomSource.nextFloat() : 0.0;
                SimpleParticleType particle = nearBedrock ? ParticleTypes.ASH : ParticleTypes.MYCELIUM;
                level.addParticle((ParticleOptions)particle, px, py, pz, 0.0, ySpeed, 0.0);
            }
        }
    }

    private static void lerpColor(float darkness, Color color, LerpTimer red, LerpTimer green, LerpTimer blue) {
        float saturation = Math.max(darkness * color.getSaturation(), 0.02f);
        float brightness = Math.max(darkness * color.getBrightness(), 0.02f);
        float[] rgb = Color.getHSBColor(color.getHue(), saturation, brightness).getComponents();
        VoidFogRenderer.setTarget(red, rgb[0]);
        VoidFogRenderer.setTarget(green, rgb[1]);
        VoidFogRenderer.setTarget(blue, rgb[2]);
    }

    public static void setupColor(Camera camera, Supplier<Float> red, Supplier<Float> green, Supplier<Float> blue, Consumer<Float> redSetter, Consumer<Float> greenSetter, Consumer<Float> blueSetter) {
        if (!((Boolean)CandyTweak.RENDER_VOID_FOG.get()).booleanValue() || !GameUtil.isInOverworld() || CameraUtil.isInFluid(camera)) {
            return;
        }
        if (VoidFogRenderer.isGameOverride(camera)) {
            VoidFogRenderer.setTarget(FOG_RED, red.get().floatValue());
            VoidFogRenderer.setTarget(FOG_GREEN, green.get().floatValue());
            VoidFogRenderer.setTarget(FOG_BLUE, blue.get().floatValue());
        } else {
            float DARKNESS = VoidFogRenderer.getDarknessValue(camera);
            Color OVERWORLD_COLOR = new Color(red.get().floatValue(), green.get().floatValue(), blue.get().floatValue());
            VoidFogRenderer.lerpColor(DARKNESS, OVERWORLD_COLOR, FOG_RED, FOG_GREEN, FOG_BLUE);
            VoidFogRenderer.lerpColor(DARKNESS, OVERWORLD_COLOR, SKY_RED, SKY_GREEN, SKY_BLUE);
            VoidFogRenderer.lerpColor(DARKNESS, OVERWORLD_COLOR, VOID_RED, VOID_GREEN, VOID_BLUE);
        }
        redSetter.accept(Float.valueOf(FOG_RED.lerpFloat()));
        greenSetter.accept(Float.valueOf(FOG_GREEN.lerpFloat()));
        blueSetter.accept(Float.valueOf(FOG_BLUE.lerpFloat()));
    }

    public static boolean setupFog(Camera camera, FogRenderer.FogMode fogMode, Supplier<Float> fogStart, Supplier<Float> fogEnd, Consumer<Float> fogStartSetter, Consumer<Float> fogEndSetter) {
        LivingEntity living;
        if (fogMode != FogRenderer.FogMode.FOG_TERRAIN || !((Boolean)CandyTweak.RENDER_VOID_FOG.get()).booleanValue() || !GameUtil.isInOverworld() || CameraUtil.isInFluid(camera)) {
            return false;
        }
        Entity entity = camera.getEntity();
        boolean isDisabled = VoidFogRenderer.isDisabled(camera) || OverworldFogRenderer.isGameOverride(camera);
        float darkness = VoidFogRenderer.getDarknessValue(camera);
        float distance = VoidFogRenderer.getDistance(entity);
        float encroach = VoidFogRenderer.getDistanceDelta(entity);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION)) {
            distance *= 4.0f * GameRenderer.getNightVisionScale((LivingEntity)living, (float)PartialTick.get());
        }
        float celestialTarget = !isDisabled && darkness < 0.5f && ClientLevelHelper.getSkyLight(entity) == 0 ? 0.0f : 1.0f;
        float cloudsTarget = !isDisabled && darkness < 0.5f && ClientLevelHelper.getSkyLight(entity) == 0 ? 0.0f : 1.0f;
        float starsTarget = !isDisabled && darkness < 0.5f && ClientLevelHelper.getSkyLight(entity) == 0 ? 0.0f : STARS_TRANSPARENCY.endFloat();
        float startTarget = Mth.lerp((float)Math.abs(darkness - 1.0f), (float)fogStart.get().floatValue(), (float)(VoidFogRenderer.getFogStart(camera, distance) * encroach));
        float endTarget = Mth.lerp((float)Math.abs(darkness - 1.0f), (float)fogEnd.get().floatValue(), (float)(VoidFogRenderer.getFogEnd(camera, distance) * encroach));
        VoidFogRenderer.setTarget(CELESTIAL_TRANSPARENCY, celestialTarget);
        VoidFogRenderer.setTarget(CLOUDS_TRANSPARENCY, cloudsTarget);
        VoidFogRenderer.setTarget(STARS_TRANSPARENCY, starsTarget);
        VoidFogRenderer.setTarget(FOG_START, Math.min(fogStart.get().floatValue(), isDisabled ? fogStart.get().floatValue() : startTarget));
        VoidFogRenderer.setTarget(FOG_END, Math.min(fogEnd.get().floatValue(), isDisabled ? fogEnd.get().floatValue() : endTarget));
        fogStartSetter.accept(Float.valueOf(FOG_START.lerpFloat()));
        fogEndSetter.accept(Float.valueOf(FOG_END.lerpFloat()));
        return !isDisabled || !FOG_START.isFinished() || !FOG_END.isFinished();
    }
}

