/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level.fog;

import com.mojang.blaze3d.shaders.FogShape;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.helper.candy.level.ClientLevelHelper;
import mod.adrenix.nostalgic.helper.candy.level.fog.VoidFogRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.FogColor;
import mod.adrenix.nostalgic.tweak.enums.WorldFog;
import mod.adrenix.nostalgic.util.client.CameraUtil;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.timer.LerpTimer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;

public abstract class OverworldFogRenderer {
    private static final ArrayList<LerpTimer> LERP_TIMERS = new ArrayList();
    private static final LerpTimer DARKNESS = OverworldFogRenderer.makeTimer(1L, TimeUnit.SECONDS);
    private static final LerpTimer TERRAIN_START = OverworldFogRenderer.makeTimer(500L, TimeUnit.MILLISECONDS);
    private static final LerpTimer TERRAIN_END = OverworldFogRenderer.makeTimer(500L, TimeUnit.MILLISECONDS);
    private static final LerpTimer SKY_START = OverworldFogRenderer.makeTimer(500L, TimeUnit.MILLISECONDS);
    private static final LerpTimer SKY_END = OverworldFogRenderer.makeTimer(500L, TimeUnit.MILLISECONDS);
    private static final LerpTimer FOG_RED = OverworldFogRenderer.makeTimer(1L, TimeUnit.SECONDS);
    private static final LerpTimer FOG_GREEN = OverworldFogRenderer.makeTimer(1L, TimeUnit.SECONDS);
    private static final LerpTimer FOG_BLUE = OverworldFogRenderer.makeTimer(1L, TimeUnit.SECONDS);

    private static LerpTimer makeTimer(long duration, TimeUnit timeUnit) {
        LerpTimer timer = LerpTimer.create(duration, timeUnit);
        LERP_TIMERS.add(timer);
        return timer;
    }

    public static void reset() {
        LERP_TIMERS.forEach(LerpTimer::clear);
    }

    public static boolean isGameOverride(Camera camera) {
        return CameraUtil.isInFluid(camera) || CameraUtil.isBlind(camera) || (Boolean)GameUtil.MOB_EFFECT_ACTIVE.get() != false;
    }

    public static int getFarPlaneDistance(WorldFog worldFog) {
        boolean isOldFog = worldFog == WorldFog.CLASSIC || worldFog == WorldFog.ALPHA_R164;
        int renderDistance = GameUtil.getRenderDistance();
        return renderDistance * 16 * (!isOldFog || renderDistance > 28 ? 1 : 2);
    }

    private static void setTerrain(FogRenderer.FogMode fogMode, WorldFog worldFog, Consumer<Float> fogStart, Consumer<Float> fogEnd) {
        float f;
        if (fogMode != FogRenderer.FogMode.FOG_TERRAIN) {
            return;
        }
        boolean isOldFog = worldFog == WorldFog.CLASSIC || worldFog == WorldFog.ALPHA_R164;
        int farPlaneDistance = OverworldFogRenderer.getFarPlaneDistance(worldFog);
        if (!isOldFog) {
            f = 0.8f;
        } else {
            switch (GameUtil.getRenderDistance()) {
                case 9: 
                case 10: 
                case 11: {
                    f = 0.7f;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    f = 0.65f;
                    break;
                }
                case 4: 
                case 5: {
                    f = 0.55f;
                    break;
                }
                case 2: 
                case 3: {
                    f = 0.48f;
                    break;
                }
                default: {
                    f = 0.8f;
                }
            }
        }
        float density = f;
        fogStart.accept(Float.valueOf(0.0f));
        fogEnd.accept(Float.valueOf((float)farPlaneDistance * density));
    }

    private static void setHorizon(FogRenderer.FogMode fogMode, WorldFog worldFog, Consumer<Float> fogStart, Consumer<Float> fogEnd) {
        if (fogMode != FogRenderer.FogMode.FOG_SKY) {
            return;
        }
        int farPlaneDistance = OverworldFogRenderer.getFarPlaneDistance(worldFog);
        if (worldFog == WorldFog.CLASSIC) {
            float density = switch (GameUtil.getRenderDistance()) {
                case 2, 3, 4, 5 -> 0.2f;
                case 6, 7, 8, 9 -> 0.4f;
                default -> 0.8f;
            };
            fogStart.accept(Float.valueOf(0.0f));
            fogEnd.accept(Float.valueOf((float)farPlaneDistance * density));
            return;
        }
        if (worldFog == WorldFog.ALPHA_R164) {
            float density = switch (GameUtil.getRenderDistance()) {
                case 6, 7, 8, 9 -> 0.65f;
                case 4, 5 -> 0.5f;
                case 2, 3 -> 0.2f;
                default -> 0.8f;
            };
            fogStart.accept(Float.valueOf(0.0f));
            fogEnd.accept(Float.valueOf((float)farPlaneDistance * density));
            return;
        }
        fogStart.accept(Float.valueOf(0.0f));
        fogEnd.accept(Float.valueOf((float)farPlaneDistance * 0.8f));
    }

    private static boolean setState(FogRenderer.FogMode fogMode, Consumer<FogShape> fogShape, Consumer<Float> fogStart, Consumer<Float> fogEnd) {
        float customFogEnd;
        float customFogStart;
        WorldFog worldFog = (WorldFog)CandyTweak.OLD_WORLD_FOG.get();
        int farPlaneDistance = OverworldFogRenderer.getFarPlaneDistance(worldFog);
        boolean isModified = false;
        if (worldFog != WorldFog.MODERN) {
            if (worldFog != WorldFog.R17_R118) {
                OverworldFogRenderer.setTerrain(fogMode, worldFog, fogStart, fogEnd);
                OverworldFogRenderer.setHorizon(fogMode, worldFog, fogStart, fogEnd);
            } else if (fogMode == FogRenderer.FogMode.FOG_TERRAIN) {
                fogStart.accept(Float.valueOf((float)farPlaneDistance * 0.75f));
                fogEnd.accept(Float.valueOf(farPlaneDistance));
            } else {
                fogStart.accept(Float.valueOf(0.0f));
                fogEnd.accept(Float.valueOf(farPlaneDistance));
            }
            if (GameUtil.isInNether() && ((Boolean)CandyTweak.OLD_NETHER_FOG.get()).booleanValue()) {
                fogStart.accept(Float.valueOf(0.0f));
            }
            fogShape.accept(FogShape.SPHERE);
            isModified = true;
        }
        if (GameUtil.isInOverworld() && ((Boolean)CandyTweak.USE_CUSTOM_OVERWORLD_FOG_DENSITY.get()).booleanValue()) {
            customFogStart = 1.0f - (float)((Integer)CandyTweak.CUSTOM_OVERWORLD_FOG_START.get()).intValue() / 100.0f;
            customFogEnd = 1.0f - (float)((Integer)CandyTweak.CUSTOM_OVERWORLD_FOG_END.get()).intValue() / 100.0f;
            fogStart.accept(Float.valueOf((float)farPlaneDistance * customFogStart));
            fogEnd.accept(Float.valueOf((float)farPlaneDistance * customFogEnd));
            isModified = true;
        }
        if (GameUtil.isInNether() && ((Boolean)CandyTweak.USE_CUSTOM_NETHER_FOG_DENSITY.get()).booleanValue()) {
            customFogStart = 1.0f - (float)((Integer)CandyTweak.CUSTOM_NETHER_FOG_START.get()).intValue() / 100.0f;
            customFogEnd = 1.0f - (float)((Integer)CandyTweak.CUSTOM_NETHER_FOG_END.get()).intValue() / 100.0f;
            fogStart.accept(Float.valueOf((float)farPlaneDistance * customFogStart));
            fogEnd.accept(Float.valueOf((float)farPlaneDistance * customFogEnd));
            isModified = true;
        }
        return isModified;
    }

    private static void calculateLightInfluence(float[] FOG_COLOR) {
        Camera camera = CameraUtil.get();
        int renderDistance = GameUtil.getOldRenderDistance();
        int maxLight = ClientLevelHelper.getMaxLight(camera.getEntity());
        if (!VoidFogRenderer.isGameOverride(camera)) {
            maxLight = ClientLevelHelper.getSkyLight(camera.getEntity());
        }
        float light = (float)Math.pow(0.8, 15.0 - (double)maxLight);
        float offset = (float)(3 - renderDistance) / 3.0f;
        float darkenTarget = light * (1.0f - offset) + offset;
        if (!((Boolean)CandyTweak.OLD_DARK_FOG.get()).booleanValue() || ((Boolean)CandyTweak.OLD_CLASSIC_ENGINE.get()).booleanValue()) {
            darkenTarget = 1.0f;
        }
        DARKNESS.setTarget(Float.valueOf(darkenTarget));
        float darkenAmount = DARKNESS.lerpFloat();
        FOG_COLOR[0] = FOG_COLOR[0] * darkenAmount;
        FOG_COLOR[1] = FOG_COLOR[1] * darkenAmount;
        FOG_COLOR[2] = FOG_COLOR[2] * darkenAmount;
    }

    private static float[] getCustomInfluence(float[] CUSTOM_FOG) {
        float[] ENV_RGB = ClientLevelHelper.getStandardEnvironmentInfluence();
        OverworldFogRenderer.calculateLightInfluence(ENV_RGB);
        float r = ENV_RGB[0];
        float g = ENV_RGB[1];
        float b = ENV_RGB[2];
        r = Mth.clamp((float)r, (float)0.04f, (float)1.0f) * CUSTOM_FOG[0];
        g = Mth.clamp((float)g, (float)0.04f, (float)1.0f) * CUSTOM_FOG[1];
        b = Mth.clamp((float)b, (float)0.04f, (float)1.0f) * CUSTOM_FOG[2];
        return new float[]{r, g, b};
    }

    private static float[] getOldInfluence(float[] FOG_COLOR) {
        float thunderLevel;
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        if (CandyTweak.OLD_WORLD_FOG.get() == WorldFog.CLASSIC) {
            int renderDistance = GameUtil.getRenderDistance();
            if (renderDistance <= 3) {
                FOG_COLOR[0] = 1.0f;
                FOG_COLOR[1] = 1.0f;
                FOG_COLOR[2] = 1.0f;
            } else if (renderDistance == 4) {
                FOG_COLOR[0] = 0.9372549f;
                FOG_COLOR[1] = 0.96862745f;
                FOG_COLOR[2] = 1.0f;
            } else if (renderDistance <= 8) {
                FOG_COLOR[0] = 0.9019608f;
                FOG_COLOR[1] = 0.9529412f;
                FOG_COLOR[2] = 1.0f;
            }
        }
        OverworldFogRenderer.calculateLightInfluence(FOG_COLOR);
        float partialTick = PartialTick.get();
        float timeOfDay = level.getTimeOfDay(partialTick);
        float boundedTime = Mth.clamp((float)(Mth.cos((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float fogRed = (float)((double)FOG_COLOR[0] * (double)(boundedTime * 0.96f + 0.04f));
        float fogGreen = (float)((double)FOG_COLOR[1] * (double)(boundedTime * 0.96f + 0.04f));
        float fogBlue = (float)((double)FOG_COLOR[2] * (double)(boundedTime * 0.947f + 0.063f));
        float rainLevel = (Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getRainLevel(partialTick);
        float f = thunderLevel = (Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getThunderLevel(partialTick);
        if (rainLevel > 0.0f) {
            float redGreenShift = 1.0f - rainLevel * 0.5f;
            float blueShift = 1.0f - rainLevel * 0.4f;
            fogRed *= redGreenShift;
            fogGreen *= redGreenShift;
            fogBlue *= blueShift;
        }
        if (thunderLevel > 0.0f) {
            float shift = 1.0f - thunderLevel * 0.5f;
            fogRed *= shift;
            fogGreen *= shift;
            fogBlue *= shift;
        }
        return new float[]{fogRed, fogGreen, fogBlue};
    }

    private static float[] getColorFromBiome() {
        float saturation = 0.26f;
        float temp = ClientLevelHelper.getBiomeTemperature() / 2.0f;
        int renderDistance = GameUtil.getRenderDistance();
        if (renderDistance <= 8) {
            saturation = switch (renderDistance) {
                case 6, 7, 8 -> 0.235f;
                case 4, 5 -> 0.22f;
                case 2, 3 -> 0.18f;
                default -> 0.26f;
            };
        }
        return Color.getHSBColor(0.648f - temp * 0.05f, saturation + temp * 0.1f, 1.0f).getComponents();
    }

    public static void setupColor(Camera camera, Supplier<Float> red, Supplier<Float> green, Supplier<Float> blue, Consumer<Float> redSetter, Consumer<Float> greenSetter, Consumer<Float> blueSetter) {
        if (CameraUtil.isInFluid(camera)) {
            return;
        }
        float currentRed = red.get().floatValue();
        float currentGreen = green.get().floatValue();
        float currentBlue = blue.get().floatValue();
        boolean isFogOverride = OverworldFogRenderer.isGameOverride(camera);
        Consumer<float[]> setFogRGB = rgb -> {
            redSetter.accept(Float.valueOf(rgb[0]));
            greenSetter.accept(Float.valueOf(rgb[1]));
            blueSetter.accept(Float.valueOf(rgb[2]));
        };
        if (GameUtil.isInOverworld()) {
            FogColor fogColor = (FogColor)CandyTweak.UNIVERSAL_FOG_COLOR.get();
            if (((Boolean)CandyTweak.USE_CUSTOM_OVERWORLD_FOG_COLOR.get()).booleanValue()) {
                setFogRGB.accept(OverworldFogRenderer.getCustomInfluence(HexUtil.parseFloatRGBA((String)CandyTweak.CUSTOM_OVERWORLD_FOG_COLOR.get())));
            } else if (((Boolean)CandyTweak.OLD_DYNAMIC_FOG_COLOR.get()).booleanValue()) {
                setFogRGB.accept(OverworldFogRenderer.getOldInfluence(OverworldFogRenderer.getColorFromBiome()));
            } else if (fogColor != FogColor.DISABLED) {
                switch (fogColor) {
                    case ALPHA_BETA: {
                        setFogRGB.accept(OverworldFogRenderer.getOldInfluence(HexUtil.parseFloatRGBA("0xC0D8FF")));
                        break;
                    }
                    case CLASSIC: {
                        setFogRGB.accept(OverworldFogRenderer.getOldInfluence(HexUtil.parseFloatRGBA("0xE1F0FF")));
                        break;
                    }
                    case INF_DEV: {
                        setFogRGB.accept(OverworldFogRenderer.getOldInfluence(HexUtil.parseFloatRGBA("0xB0D0FF")));
                    }
                }
            }
        }
        if (GameUtil.isInNether()) {
            if (((Boolean)CandyTweak.USE_CUSTOM_NETHER_FOG_COLOR.get()).booleanValue()) {
                setFogRGB.accept(HexUtil.parseFloatRGBA((String)CandyTweak.CUSTOM_NETHER_FOG_COLOR.get()));
            } else if (((Boolean)CandyTweak.OLD_NETHER_FOG.get()).booleanValue()) {
                setFogRGB.accept(HexUtil.parseFloatRGBA("0x210505"));
            }
        }
        if (isFogOverride) {
            FOG_RED.setTarget(Float.valueOf(Math.min(currentRed, red.get().floatValue())));
            FOG_GREEN.setTarget(Float.valueOf(Math.min(currentGreen, green.get().floatValue())));
            FOG_BLUE.setTarget(Float.valueOf(Math.min(currentBlue, blue.get().floatValue())));
        } else {
            FOG_RED.ifEndThenSetTarget(red.get());
            FOG_GREEN.ifEndThenSetTarget(green.get());
            FOG_BLUE.ifEndThenSetTarget(blue.get());
        }
        float[] RGB = new float[]{FOG_RED.lerpFloat(), FOG_GREEN.lerpFloat(), FOG_BLUE.lerpFloat()};
        setFogRGB.accept(RGB);
    }

    public static boolean setupFog(Camera camera, FogRenderer.FogMode fogMode, Supplier<Float> fogStart, Supplier<Float> fogEnd, Consumer<FogShape> fogShapeSetter, Consumer<Float> fogStartSetter, Consumer<Float> fogEndSetter) {
        float modFogEnd;
        if (CameraUtil.isInFluid(camera)) {
            return false;
        }
        float currentFogStart = fogStart.get().floatValue();
        float currentFogEnd = fogEnd.get().floatValue();
        boolean isFogOverride = OverworldFogRenderer.isGameOverride(camera);
        boolean isModified = false;
        if (GameUtil.isInOverworld() || GameUtil.isInNether()) {
            isModified = OverworldFogRenderer.setState(fogMode, fogShapeSetter, fogStartSetter, fogEndSetter);
        }
        float modFogStart = isFogOverride ? currentFogStart : fogStart.get().floatValue();
        float f = modFogEnd = isFogOverride ? currentFogEnd : fogEnd.get().floatValue();
        if (fogMode == FogRenderer.FogMode.FOG_TERRAIN) {
            TERRAIN_START.setTarget(Float.valueOf(modFogStart));
            TERRAIN_END.setTarget(Float.valueOf(modFogEnd));
            fogStartSetter.accept(Float.valueOf(TERRAIN_START.lerpFloat()));
            fogEndSetter.accept(Float.valueOf(TERRAIN_END.lerpFloat()));
        } else {
            SKY_START.setTarget(Float.valueOf(modFogStart));
            SKY_END.setTarget(Float.valueOf(modFogEnd));
            fogStartSetter.accept(Float.valueOf(SKY_START.lerpFloat()));
            fogEndSetter.accept(Float.valueOf(SKY_END.lerpFloat()));
        }
        return isModified;
    }
}

