/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level;

import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.data.NumberHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;

public abstract class ClientLevelHelper {
    private static final NumberHolder<Float> BIOME_TEMPERATURE = NumberHolder.create(Float.valueOf(Float.NaN));

    public static float getBiomeTemperature() {
        LocalPlayer player = Minecraft.getInstance().player;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (player == null) {
            return 0.0f;
        }
        float temperature = ((Biome)player.level().getBiome(camera.getBlockPosition()).value()).getBaseTemperature();
        if (Float.isNaN(((Float)BIOME_TEMPERATURE.get()).floatValue())) {
            BIOME_TEMPERATURE.set(Float.valueOf(temperature));
        } else {
            BIOME_TEMPERATURE.set(Float.valueOf(MathUtil.moveTowards(((Float)BIOME_TEMPERATURE.get()).floatValue(), temperature, 1.0E-5f)));
        }
        return ((Float)BIOME_TEMPERATURE.get()).floatValue();
    }

    public static float[] getStandardEnvironmentInfluence() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float partialTick = PartialTick.get();
        float timeOfDay = level.getTimeOfDay(partialTick);
        float boundedTime = Mth.clamp((float)(Mth.cos((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float rain = 1.0f - ((Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getRainLevel(partialTick)) + 0.4f;
        float thunder = 1.0f - ((Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : level.getThunderLevel(partialTick)) + 0.2f;
        float weather = Mth.clamp((float)Math.min(rain, thunder), (float)0.0f, (float)1.0f);
        float r = boundedTime * weather;
        float g = boundedTime * weather;
        float b = boundedTime * weather;
        return new float[]{r, g, b};
    }

    public static int getSkyLight(Entity entity) {
        return entity.level().getBrightness(LightLayer.SKY, entity.blockPosition().above());
    }

    public static int getMaxLight(Entity entity) {
        return Mth.clamp((int)entity.level().getMaxLocalRawBrightness(entity.blockPosition().above()), (int)0, (int)15);
    }
}

