/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import mod.adrenix.nostalgic.helper.candy.hud.HudElement;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaRenderer;
import mod.adrenix.nostalgic.mixin.access.GuiAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class HudHelper {
    private static final FlagHolder HUD_MANAGED = FlagHolder.off();
    private static final FlagHolder FOOD_LEVEL_PUSHED = FlagHolder.off();
    private static final FlagHolder ARMOR_LEVEL_PUSHED = FlagHolder.off();
    private static final FlagHolder AIR_LEVEL_PUSHED = FlagHolder.off();
    private static final List<FlagHolder> PUSHED_ELEMENTS = List.of(FOOD_LEVEL_PUSHED, ARMOR_LEVEL_PUSHED, AIR_LEVEL_PUSHED);

    public static void runAfterSave() {
        GuiAccess gui = (GuiAccess)Minecraft.getInstance().gui;
        if (ModTracker.EXORDIUM.isInstalled()) {
            gui.nt$setHealthBlinkTime(gui.nt$getTickCount() + 20);
        }
    }

    @Nullable
    private static Player getPlayer() {
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    private static boolean isVehicleHealthShown() {
        Player player = HudHelper.getPlayer();
        if (player != null) {
            return player.getVehicle() instanceof LivingEntity;
        }
        return false;
    }

    private static boolean isJumpMeterShown() {
        Player player = HudHelper.getPlayer();
        if (player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            return local.jumpableVehicle() != null;
        }
        return false;
    }

    private static int getHeightOffsetFromHearts() {
        int absorptionAmount = Mth.ceil((float)NullableResult.getOrElse(HudHelper.getPlayer(), Float.valueOf(0.0f), Player::getAbsorptionAmount).floatValue());
        int currentHealth = Mth.ceil((float)NullableResult.getOrElse(HudHelper.getPlayer(), Float.valueOf(0.0f), LivingEntity::getHealth).floatValue());
        int displayHealth = ((GuiAccess)Minecraft.getInstance().gui).nt$getDisplayHealth();
        float playerHealth = NullableResult.getOrElse(HudHelper.getPlayer(), Float.valueOf(0.0f), player -> Float.valueOf((float)player.getAttributeValue(Attributes.MAX_HEALTH))).floatValue();
        float maxHealth = Math.max(playerHealth, (float)Math.max(displayHealth, currentHealth));
        int numberOfRows = Mth.ceil((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (numberOfRows - 2), 3);
        return 39 + (numberOfRows - 1) * rowHeight + 10;
    }

    private static int getHeightOffsetForStamina() {
        int armorValue;
        int heightOffset = 49;
        boolean isFoodOff = (Boolean)CandyTweak.HIDE_HUNGER_BAR.get();
        LocalPlayer player = Minecraft.getInstance().player;
        if (isFoodOff && (armorValue = NullableResult.getOrElse(player, 0, LivingEntity::getArmorValue).intValue()) == 0) {
            heightOffset -= 10;
        }
        return heightOffset;
    }

    public static void begin(GuiGraphics graphics) {
        if (HUD_MANAGED.ifDisabledThenEnable()) {
            graphics.pose().pushPose();
        }
    }

    public static void end(GuiGraphics graphics) {
        if (HUD_MANAGED.ifEnabledThenDisable()) {
            PUSHED_ELEMENTS.stream().filter(FlagHolder::ifEnabledThenDisable).forEach(holder -> graphics.pose().popPose());
            graphics.pose().popPose();
        }
    }

    public static void pop(GuiGraphics graphics) {
        if (((Boolean)HUD_MANAGED.get()).booleanValue() && PUSHED_ELEMENTS.stream().anyMatch(FlagHolder::ifEnabledThenDisable)) {
            graphics.pose().popPose();
        }
    }

    public static void apply(GuiGraphics graphics, HudElement overlay) {
        if (!((Boolean)HUD_MANAGED.get()).booleanValue()) {
            return;
        }
        switch (overlay) {
            case VEHICLE_HEALTH: {
                int armorValue = NullableResult.getOrElse(HudHelper.getPlayer(), 0, LivingEntity::getArmorValue);
                if (!HudHelper.isVehicleHealthShown() || armorValue <= 0) break;
                graphics.pose().translate(0.0f, -10.0f, 0.0f);
                break;
            }
            case EXPERIENCE_BAR: {
                if (HudHelper.isJumpMeterShown()) break;
                graphics.pose().translate(0.0f, 7.0f, 0.0f);
                break;
            }
            case FOOD: {
                FOOD_LEVEL_PUSHED.enable();
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 9.0E10f, 0.0f);
                break;
            }
            case ARMOR: {
                ARMOR_LEVEL_PUSHED.enable();
                graphics.pose().pushPose();
                graphics.pose().translate((float)(GuiUtil.getGuiWidth() / 2 + 90), 0.0f, 0.0f);
                HudHelper.renderArmor(graphics, 39, 0);
                break;
            }
            case AIR: {
                if (((Boolean)CandyTweak.HIDE_HUNGER_BAR.get()).booleanValue()) {
                    AIR_LEVEL_PUSHED.enable();
                    graphics.pose().pushPose();
                    graphics.pose().translate((float)(GuiUtil.getGuiWidth() / 2 - 100), 0.0f, 0.0f);
                    HudHelper.renderAir(graphics, HudHelper.getHeightOffsetFromHearts(), 0);
                    break;
                }
                if (!StaminaRenderer.isVisible()) break;
                AIR_LEVEL_PUSHED.enable();
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, -10.0f, 0.0f);
                break;
            }
            case STAMINA: {
                if (AIR_LEVEL_PUSHED.ifEnabledThenDisable()) {
                    graphics.pose().popPose();
                }
                StaminaRenderer.render(graphics, HudHelper.getHeightOffsetForStamina());
            }
        }
    }

    private static void renderInverseHalfArmor(GuiGraphics graphics, int x, int y) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(GuiAccess.NT$ARMOR_HALF_SPRITE());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = graphics.pose().last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + 9), 0.0f).setUv(sprite.getU1(), sprite.getV1());
        builder.addVertex(matrix, (float)(x + 9), (float)(y + 9), 0.0f).setUv(sprite.getU0(), sprite.getV1());
        builder.addVertex(matrix, (float)(x + 9), (float)y, 0.0f).setUv(sprite.getU0(), sprite.getV0());
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(sprite.getU1(), sprite.getV0());
        NullableAction.attempt(builder.build(), BufferUploader::drawWithShader);
    }

    public static void renderArmor(GuiGraphics graphics, int offsetHeight, int offsetRight) {
        int right = offsetRight;
        int armor = NullableResult.getOrElse(HudHelper.getPlayer(), 0, LivingEntity::getArmorValue);
        int top = GuiUtil.getGuiHeight() - offsetHeight;
        RenderSystem.enableBlend();
        for (int i = 1; armor > 0 && i < 20; i += 2) {
            right -= 8;
            if (i == armor) {
                HudHelper.renderInverseHalfArmor(graphics, right, top);
                continue;
            }
            if (i < armor) {
                graphics.blitSprite(GuiAccess.NT$ARMOR_FULL_SPRITE(), right, top, 9, 9);
                continue;
            }
            graphics.blitSprite(GuiAccess.NT$ARMOR_EMPTY_SPRITE(), right, top, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    public static void renderAir(GuiGraphics graphics, int offsetHeight, int offsetLeft) {
        int air = NullableResult.getOrElse(HudHelper.getPlayer(), 0, Entity::getAirSupply);
        int top = GuiUtil.getGuiHeight() - offsetHeight;
        int full = Mth.ceil((double)((double)(air - 2) * 10.0 / 300.0));
        int partial = Mth.ceil((double)((double)air * 10.0 / 300.0)) - full;
        RenderSystem.enableBlend();
        for (int i = 0; i < full + partial; ++i) {
            graphics.blitSprite(i < full ? GuiAccess.NT$AIR_SPRITE() : GuiAccess.NT$AIR_BURSTING_SPRITE(), offsetLeft + i * 8 + 9, top, 9, 9);
        }
        RenderSystem.disableBlend();
    }
}

