/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.flatten;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mod.adrenix.nostalgic.helper.candy.flatten.FlatItemHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FlatModel
implements BakedModel {
    private final BakedModel model;
    private final PoseStack poseStack;
    private final ItemDisplayContext displayContext;

    public FlatModel(BakedModel model, PoseStack poseStack, ItemDisplayContext displayContext) {
        this.model = model;
        this.poseStack = poseStack;
        this.displayContext = displayContext;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        List<BakedQuad> quads = this.model.getQuads(state, direction, random);
        if (((Boolean)CandyTweak.OLD_2D_RENDERING.get()).booleanValue() && this.displayContext != ItemDisplayContext.FIXED) {
            quads = FlatItemHelper.getFrontQuad(quads);
        }
        for (BakedQuad quad : quads) {
            if (quad == null) continue;
            FlatItemHelper.setUnitNormals(this.poseStack.last(), quad);
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.model.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.model.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.model.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.model.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.model.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.model.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.model.getOverrides();
    }
}

