/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.flatten;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public abstract class FlatItemHelper {
    private static final FlagHolder RENDERING_FLAT = FlagHolder.off();

    public static void enableFlatRendering() {
        RENDERING_FLAT.enable();
    }

    public static void disableFlatRendering() {
        RENDERING_FLAT.disable();
    }

    public static boolean isRendering2D() {
        return (Boolean)RENDERING_FLAT.get();
    }

    public static void flattenScaling(PoseStack poseStack) {
        poseStack.scale(1.0f, 1.0f, 0.001f);
    }

    public static List<BakedQuad> getFrontQuad(List<BakedQuad> quads) {
        if (!((Boolean)RENDERING_FLAT.get()).booleanValue()) {
            return quads;
        }
        ArrayList<BakedQuad> southQuads = new ArrayList<BakedQuad>();
        for (BakedQuad baked : quads) {
            if (baked.getDirection() != Direction.SOUTH) continue;
            southQuads.add(baked);
        }
        return southQuads;
    }

    public static void setUnitNormals(PoseStack.Pose pose, BakedQuad quad) {
        float sign = MathUtil.sign(Minecraft.getInstance().gameRenderer.getMainCamera().getXRot());
        pose.normal().m20(1.0f);
        pose.normal().m21(1.0f);
        pose.normal().m22(sign);
        if (quad.getDirection() == Direction.NORTH) {
            pose.normal().m20(-1.0f);
            pose.normal().m21(-1.0f);
            pose.normal().m22(-1.0f * sign);
        }
    }
}

