/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public abstract class TorchHelper {
    public static final float SHEAR = 0.401f;
    public static final float Y_SHIFT = 0.198f;
    public static final float XZ_SHIFT = 0.579f;

    public static boolean isLikeTorch(BlockState blockState) {
        return BlockUtil.match(blockState, Blocks.TORCH, Blocks.REDSTONE_TORCH, Blocks.SOUL_TORCH, Blocks.WALL_TORCH, Blocks.REDSTONE_WALL_TORCH, Blocks.SOUL_WALL_TORCH);
    }

    public static boolean isNotLikeTorch(BlockState blockState) {
        return !TorchHelper.isLikeTorch(blockState);
    }

    public static boolean isOldWall(BlockState blockState) {
        return (Boolean)CandyTweak.OLD_TORCH_MODEL.get() != false && blockState.is(Blocks.WALL_TORCH);
    }

    public static boolean isOldSoulWall(BlockState blockState) {
        return (Boolean)CandyTweak.OLD_SOUL_TORCH_MODEL.get() != false && blockState.is(Blocks.SOUL_WALL_TORCH);
    }

    public static boolean isOldRedstoneWall(BlockState blockState) {
        return (Boolean)CandyTweak.OLD_REDSTONE_TORCH_MODEL.get() != false && blockState.is(Blocks.REDSTONE_WALL_TORCH);
    }

    public static boolean isSheared(BlockState blockState) {
        return TorchHelper.isOldWall(blockState) || TorchHelper.isOldSoulWall(blockState) || TorchHelper.isOldRedstoneWall(blockState);
    }

    public static BakedModel getModel(BlockState blockState) {
        BlockState defaultTorch = Blocks.TORCH.defaultBlockState();
        if (TorchHelper.isOldRedstoneWall(blockState)) {
            defaultTorch = Blocks.REDSTONE_TORCH.withPropertiesOf(blockState);
        } else if (TorchHelper.isOldSoulWall(blockState)) {
            defaultTorch = Blocks.SOUL_TORCH.withPropertiesOf(blockState);
        }
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(defaultTorch);
    }

    public static boolean isBright(BlockState blockState) {
        if (BlockUtil.match(blockState, Blocks.REDSTONE_TORCH, Blocks.REDSTONE_WALL_TORCH)) {
            return (Boolean)CandyTweak.OLD_TORCH_BRIGHTNESS.get() != false && (Boolean)blockState.getValue((Property)RedstoneTorchBlock.LIT) != false;
        }
        return (Boolean)CandyTweak.OLD_TORCH_BRIGHTNESS.get();
    }

    public static void applyShear(PoseStack poseStack, BlockState blockState) {
        Matrix4f matrix = poseStack.last().pose();
        Direction direction = (Direction)blockState.getValue((Property)WallTorchBlock.FACING);
        switch (direction) {
            case NORTH: {
                matrix.m12(-0.401f);
                poseStack.translate(0.0f, 0.198f, 0.579f);
                break;
            }
            case SOUTH: {
                matrix.m12(0.401f);
                poseStack.translate(0.0f, 0.198f, -0.579f);
                break;
            }
            case EAST: {
                matrix.m10(0.401f);
                poseStack.translate(-0.579f, 0.198f, 0.0f);
                break;
            }
            case WEST: {
                matrix.m10(-0.401f);
                poseStack.translate(0.579f, 0.198f, 0.0f);
            }
        }
    }

    public static void applyShear(Matrix4f matrix, BlockState blockState) {
        Direction direction = (Direction)blockState.getValue((Property)WallTorchBlock.FACING);
        switch (direction) {
            case NORTH: {
                matrix.m12(-0.401f);
                matrix.translate(0.0f, 0.198f, 0.579f);
                break;
            }
            case SOUTH: {
                matrix.m12(0.401f);
                matrix.translate(0.0f, 0.198f, -0.579f);
                break;
            }
            case EAST: {
                matrix.m10(0.401f);
                matrix.translate(-0.579f, 0.198f, 0.0f);
                break;
            }
            case WEST: {
                matrix.m10(-0.401f);
                matrix.translate(0.579f, 0.198f, 0.0f);
            }
        }
    }

    public static void writeVertices(PoseStack poseStack, BlockAndTintGetter blockAndTintGetter, VertexConsumer vertexConsumer, BakedModel model, BlockState blockState, BlockPos blockPos, RandomSource random) {
        int brightness;
        int blockLight = blockAndTintGetter.getBrightness(LightLayer.BLOCK, blockPos);
        int skyLight = blockAndTintGetter.getBrightness(LightLayer.SKY, blockPos);
        int n = brightness = TorchHelper.isBright(blockState) ? 0xF000F0 : LightTexture.pack((int)blockLight, (int)skyLight);
        if (!TorchHelper.isSheared(blockState)) {
            for (BakedQuad quad : model.getQuads(blockState, null, random)) {
                vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, brightness, OverlayTexture.NO_OVERLAY);
            }
            return;
        }
        boolean isBottomDisabled = (Boolean)CandyTweak.OLD_TORCH_BOTTOM.get();
        poseStack.pushPose();
        TorchHelper.applyShear(poseStack, blockState);
        for (BakedQuad quad : TorchHelper.getModel(blockState).getQuads(blockState, null, random)) {
            if (isBottomDisabled && quad.getDirection() == Direction.DOWN) continue;
            vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, brightness, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }
}

