/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.helper.candy.block.ChestHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.AnimationType;
import mod.adrenix.nostalgic.tweak.enums.ColorType;
import mod.adrenix.nostalgic.tweak.listing.ItemSet;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public abstract class HitboxHelper {
    public static final FlagHolder CUSTOM_HITBOX_OUTLINE = FlagHolder.off();
    public static final Animation PULSATE_ANIMATION = Animate.linear(1L, TimeUnit.SECONDS);
    public static final RenderType OVERLAY_RENDER_TYPE = RenderType.create((String)"nt_hitbox_overlay", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));

    public static VoxelShape getShape(VoxelShape original, Block block) {
        boolean isFullChest = ChestHelper.isOld(block);
        boolean isFullOutline = ((ItemSet)CandyTweak.FULL_BLOCK_OUTLINES.get()).containsBlock(block);
        boolean isFullCollision = ((ItemSet)CandyTweak.FULL_BLOCK_COLLISIONS.get()).containsBlock(block);
        if (isFullChest || isFullOutline || isFullCollision) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return original;
    }

    public static void renderOverlay(Matrix4f matrix, VoxelShape shape, double rx, double ry, double rz) {
        float pulseMin = ((Float)CandyTweak.MINIMUM_PULSATION_TRANSPARENCY.get()).floatValue();
        float pulseMax = ((Float)CandyTweak.MAXIMUM_PULSATION_TRANSPARENCY.get()).floatValue();
        float minAlpha = Math.min(pulseMin, pulseMax);
        float maxAlpha = Math.max(pulseMin, pulseMax);
        PULSATE_ANIMATION.animateWith(((AnimationType)CandyTweak.PULSATE_OVERLAY_ANIMATION.get()).getAnimation());
        PULSATE_ANIMATION.setDuration((long)(((Float)CandyTweak.BLOCK_OVERLAY_SPEED.get()).floatValue() * 1000.0f), TimeUnit.MILLISECONDS);
        PULSATE_ANIMATION.playOrRewind();
        NullableHolder vertexHolder = NullableHolder.empty();
        IntegerHolder top = IntegerHolder.create(HexUtil.parseInt((String)CandyTweak.BLOCK_OVERLAY_COLOR.get()));
        IntegerHolder bottom = IntegerHolder.create((Integer)top.get());
        BufferBuilder builder = null;
        if (Minecraft.useShaderTransparency()) {
            vertexHolder.set(Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(OVERLAY_RENDER_TYPE));
        } else {
            builder = RenderUtil.getAndBeginFill();
            vertexHolder.set(builder);
        }
        if (CandyTweak.BLOCK_OVERLAY_COLOR_TYPE.get() == ColorType.GRADIENT) {
            top.set(HexUtil.parseInt((String)CandyTweak.BLOCK_OVERLAY_GRADIENT_TOP.get()));
            bottom.set(HexUtil.parseInt((String)CandyTweak.BLOCK_OVERLAY_GRADIENT_BOTTOM.get()));
        }
        if (((Boolean)CandyTweak.PULSATE_BLOCK_OVERLAY.get()).booleanValue()) {
            double alpha = Mth.lerp((double)PULSATE_ANIMATION.getValue(), (double)minAlpha, (double)maxAlpha);
            top.set(new Color((Integer)top.get()).fromAlpha(alpha).get());
            bottom.set(new Color((Integer)bottom.get()).fromAlpha(alpha).get());
        }
        shape.forAllBoxes((x0, y0, z0, x1, y1, z1) -> {
            VertexConsumer buffer = (VertexConsumer)vertexHolder.getOrThrow();
            int argbTop = (Integer)top.get();
            int argbBottom = (Integer)bottom.get();
            float rx0 = (float)(x0 + rx);
            float ry0 = (float)(y0 + ry);
            float rz0 = (float)(z0 + rz);
            float rx1 = (float)(x1 + rx);
            float ry1 = (float)(y1 + ry);
            float rz1 = (float)(z1 + rz);
            float dx = (float)(x1 - x0);
            float dy = (float)(y1 - y0);
            float dz = (float)(z1 - z0);
            buffer.addVertex(matrix, rx0, ry1, rz0).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry1, rz1 - dz).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry0, rz1 - dz).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry0, rz0).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry1, rz0 + dz).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry1, rz1).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry0, rz1).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry0, rz0 + dz).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry1, rz0).setColor(argbTop);
            buffer.addVertex(matrix, rx1 - dx, ry1, rz1).setColor(argbTop);
            buffer.addVertex(matrix, rx1 - dx, ry0, rz1).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry0, rz0).setColor(argbBottom);
            buffer.addVertex(matrix, rx0 + dx, ry1, rz0).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry1, rz1).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry0, rz1).setColor(argbBottom);
            buffer.addVertex(matrix, rx0 + dx, ry0, rz0).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry1, rz0).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry1, rz1 - dz).setColor(argbTop);
            buffer.addVertex(matrix, rx1, ry0 + dy, rz1).setColor(argbTop);
            buffer.addVertex(matrix, rx0, ry0 + dy, rz0 + dz).setColor(argbTop);
            buffer.addVertex(matrix, rx0, ry1 - dy, rz0 + dz).setColor(argbBottom);
            buffer.addVertex(matrix, rx1, ry1 - dy, rz1).setColor(argbBottom);
            buffer.addVertex(matrix, rx1, ry0, rz1 - dz).setColor(argbBottom);
            buffer.addVertex(matrix, rx0, ry0, rz0).setColor(argbBottom);
        });
        if (Minecraft.useShaderTransparency()) {
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch(OVERLAY_RENDER_TYPE);
        }
        if (builder == null) {
            return;
        }
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        if (!Minecraft.useShaderTransparency()) {
            RenderSystem.depthMask((boolean)false);
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderStateShard.VIEW_OFFSET_Z_LAYERING.setupRenderState();
        RenderUtil.endFill(builder);
        if (!Minecraft.useShaderTransparency()) {
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderStateShard.VIEW_OFFSET_Z_LAYERING.clearRenderState();
    }
}

