/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.client.gui.screen.home.overlay.supporter.SupporterOverlay;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.CycleIndex;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public abstract class SupporterRenderer {
    private static final RenderType AUTHOR_VISIBLE_SHADER = RenderType.create((String)"nt_author_shader", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_TEXT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocation.NT_LOGO_64.getLocation(), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    private static final RenderType AUTHOR_SEE_THROUGH_SHADER = RenderType.create((String)"nt_author_see_through_shader", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_TEXT_SEE_THROUGH_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocation.NT_LOGO_64.getLocation(), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
    private static final RenderType SUPPORTER_VISIBLE_SHADER = RenderType.create((String)"nt_supporter_shader", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_TEXT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocation.NT_SUPPORTER_64.getLocation(), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    private static final RenderType SUPPORTER_SEE_THROUGH_SHADER = RenderType.create((String)"nt_supporter_see_through_shader", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_TEXT_SEE_THROUGH_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocation.NT_SUPPORTER_64.getLocation(), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
    private static final Animation ADRENIX_COLOR = Animate.linear(2L, TimeUnit.SECONDS);
    private static final Animation RAINBOW_COLOR = Animate.linear(2L, TimeUnit.SECONDS);
    private static final Animation CAPTAIN_MOVER = Animate.linear(100L, TimeUnit.MILLISECONDS);
    private static final CycleIndex CAPTAIN_CYCLE = new CycleIndex("Captain_3".split(""), true);

    public static boolean isSupporter(Component displayName) {
        if (!((Boolean)CandyTweak.SUPPORTER_TAGS.get()).booleanValue()) {
            return false;
        }
        for (String name : SupporterOverlay.getNameKeys()) {
            if (!name.equals(displayName.getString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotSupporter(Component displayName) {
        return !SupporterRenderer.isSupporter(displayName);
    }

    private static void drawText(IntegerHolder endX, String text, float x, float y, Matrix4f matrix, MultiBufferSource bufferSource, int textColor, int backgroundColor, int packedLight) {
        Font font = GuiUtil.font();
        font.drawInBatch(text, x, y, textColor, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundColor, packedLight);
        int lastX = font.drawInBatch(text, x, y, textColor, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        endX.set(lastX);
    }

    private static void drawBadge(Badge badge, MultiBufferSource bufferSource, PoseStack poseStack, int packedLight, int endX) {
        poseStack.pushPose();
        poseStack.translate((float)endX + 3.0f, -2.5f, 0.0f);
        poseStack.scale(0.2f, 0.2f, 0.2f);
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer seeThrough = bufferSource.getBuffer(badge.getSeeThroughShader());
        seeThrough.addVertex(matrix, 0.0f, 64.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(packedLight);
        seeThrough.addVertex(matrix, 64.0f, 64.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(packedLight);
        seeThrough.addVertex(matrix, 64.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(packedLight);
        seeThrough.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(packedLight);
        VertexConsumer visible = bufferSource.getBuffer(badge.getVisibleShader());
        visible.addVertex(matrix, 0.0f, 64.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(packedLight);
        visible.addVertex(matrix, 64.0f, 64.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(packedLight);
        visible.addVertex(matrix, 64.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(packedLight);
        visible.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(packedLight);
        poseStack.popPose();
    }

    public static int render(Component displayName, float x, float y, PoseStack poseStack, MultiBufferSource bufferSource, int backgroundColor, int packedLight) {
        String name = displayName.getString();
        Matrix4f fontMatrix = poseStack.last().pose();
        IntegerHolder endX = IntegerHolder.create((int)x);
        int transparent = Color.TRANSPARENT.get();
        int translucent = Color.BLACK.fromAlpha(0.016f).get();
        switch (name) {
            case "Adrenix": {
                ADRENIX_COLOR.playOrRewind();
                int color = Color.HSBtoRGB(360.0f, 1.0f, Mth.lerp((float)((float)ADRENIX_COLOR.getValue()), (float)0.4f, (float)1.0f));
                SupporterRenderer.drawText(endX, name, x, y, fontMatrix, bufferSource, color, backgroundColor, packedLight);
                SupporterRenderer.drawBadge(Badge.AUTHOR, bufferSource, poseStack, packedLight, (Integer)endX.get());
                break;
            }
            case "PoeticRainbow": {
                if (RAINBOW_COLOR.isFinished()) {
                    RAINBOW_COLOR.reset();
                    RAINBOW_COLOR.tick();
                }
                RAINBOW_COLOR.play();
                SupporterRenderer.drawText(IntegerHolder.create((int)x), name, x, y, fontMatrix, bufferSource, translucent, backgroundColor, packedLight);
                CollectionUtil.forLoop(Arrays.stream(name.split("")), (letter, index) -> {
                    float offset = (float)index.intValue() / (float)name.length();
                    float degrees = 360.0f * (1.0f - (float)RAINBOW_COLOR.getValue() + offset);
                    float hsb = MathUtil.normalizeInRange(degrees, 0.0f, 360.0f);
                    int color = Color.HSBtoRGB(hsb / 360.0f, 1.0f, 1.0f);
                    SupporterRenderer.drawText(endX, letter, ((Integer)endX.get()).intValue(), y, fontMatrix, bufferSource, color, transparent, packedLight);
                });
                SupporterRenderer.drawBadge(Badge.SUPPORTER, bufferSource, poseStack, packedLight, (Integer)endX.get());
                break;
            }
            case "Captain_3": {
                if (CAPTAIN_MOVER.isFinished()) {
                    CAPTAIN_MOVER.reset();
                    CAPTAIN_CYCLE.cycle();
                }
                CAPTAIN_MOVER.play();
                SupporterRenderer.drawText(IntegerHolder.create((int)x), name, x, y, fontMatrix, bufferSource, translucent, backgroundColor, packedLight);
                CollectionUtil.forLoop(Arrays.stream(name.split("")), (letter, index) -> {
                    int color = SupporterOverlay.getNames().getOrDefault(name, Color.WHITE).get();
                    int jumpY = (int)y + CAPTAIN_CYCLE.get() == index ? -1 : 0;
                    SupporterRenderer.drawText(endX, letter, ((Integer)endX.get()).intValue(), jumpY, fontMatrix, bufferSource, color, transparent, packedLight);
                });
                SupporterRenderer.drawBadge(Badge.SUPPORTER, bufferSource, poseStack, packedLight, (Integer)endX.get());
                break;
            }
            default: {
                Color color = SupporterOverlay.getNames().getOrDefault(name, Color.WHITE);
                SupporterRenderer.drawText(endX, name, x, y, fontMatrix, bufferSource, color.get(), backgroundColor, packedLight);
                SupporterRenderer.drawBadge(Badge.SUPPORTER, bufferSource, poseStack, packedLight, (Integer)endX.get());
            }
        }
        return (Integer)endX.get();
    }

    private static enum Badge {
        AUTHOR(AUTHOR_SEE_THROUGH_SHADER, AUTHOR_VISIBLE_SHADER),
        SUPPORTER(SUPPORTER_SEE_THROUGH_SHADER, SUPPORTER_VISIBLE_SHADER);

        private final RenderType seeThrough;
        private final RenderType visible;

        private Badge(RenderType seeThrough, RenderType visible) {
            this.seeThrough = seeThrough;
            this.visible = visible;
        }

        private RenderType getSeeThroughShader() {
            return this.seeThrough;
        }

        private RenderType getVisibleShader() {
            return this.visible;
        }
    }
}

