/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import java.util.function.Consumer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.listing.StringSet;
import mod.adrenix.nostalgic.util.client.CameraUtil;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class ParticleHelper {
    public static void destroy(Consumer<Particle> add, ClientLevel clientLevel, BlockPos blockPos, BlockState blockState) {
        int posX = blockPos.getX();
        int posY = blockPos.getY();
        int posZ = blockPos.getZ();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    double dx = (double)posX + ((double)x + 0.5) / 4.0;
                    double dy = (double)posY + ((double)y + 0.5) / 4.0;
                    double dz = (double)posZ + ((double)z + 0.5) / 4.0;
                    double speedX = dx - (double)posX - 0.5;
                    double speedY = dy - (double)posY - 0.5;
                    double speedZ = dz - (double)posZ - 0.5;
                    add.accept((Particle)new TerrainParticle(clientLevel, dx, dy, dz, speedX, speedY, speedZ, blockState, blockPos));
                }
            }
        }
    }

    @Nullable
    public static Particle getParticle(Particle particle, ParticleType<?> type, double x, double y, double z) {
        if (((Boolean)CandyTweak.OLD_SWEEP_PARTICLES.get()).booleanValue() && type == ParticleTypes.SWEEP_ATTACK) {
            return null;
        }
        if (((Boolean)CandyTweak.OLD_NO_DAMAGE_PARTICLES.get()).booleanValue() && type == ParticleTypes.DAMAGE_INDICATOR) {
            return null;
        }
        if (((Boolean)CandyTweak.OLD_NO_CRIT_PARTICLES.get()).booleanValue() && type == ParticleTypes.CRIT) {
            return null;
        }
        if (((Boolean)CandyTweak.OLD_NO_MAGIC_HIT_PARTICLES.get()).booleanValue() && type == ParticleTypes.ENCHANTED_HIT) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_UNDERWATER_PARTICLES.get()).booleanValue() && type == ParticleTypes.UNDERWATER) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_WATER_DRIP_PARTICLES.get()).booleanValue() && type == ParticleTypes.DRIPPING_WATER) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_LAVA_PARTICLES.get()).booleanValue() && type == ParticleTypes.LAVA) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_LAVA_DRIP_PARTICLES.get()).booleanValue() && type == ParticleTypes.DRIPPING_LAVA) {
            return null;
        }
        if (((Boolean)CandyTweak.DISABLE_NETHER_PARTICLES.get()).booleanValue() && GameUtil.isInNether() && ParticleHelper.typeEqualTo(type, new ParticleType[]{ParticleTypes.ASH, ParticleTypes.WHITE_ASH, ParticleTypes.WARPED_SPORE, ParticleTypes.CRIMSON_SPORE})) {
            return null;
        }
        if (ParticleHelper.getPlayerParticle(particle, type, x, y, z) == null) {
            return null;
        }
        ResourceLocation key = BuiltInRegistries.PARTICLE_TYPE.getKey(type);
        if (key != null && ((StringSet)CandyTweak.DISABLED_PARTICLES.get()).contains(key.toString())) {
            return null;
        }
        return particle;
    }

    @Nullable
    private static Particle getPlayerParticle(Particle particle, ParticleType<?> type, double x, double y, double z) {
        boolean isEffectParticle = ParticleHelper.typeEqualTo(type, ParticleTypes.ENTITY_EFFECT);
        if (!(((Boolean)CandyTweak.HIDE_FIRST_PERSON_MAGIC_PARTICLES.get()).booleanValue() && CameraUtil.isFirstPerson() && isEffectParticle)) {
            return particle;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            double playerX = player.getX();
            double playerY = player.getY();
            double playerZ = player.getZ();
            boolean isNearX = MathUtil.tolerance(x, playerX, 2.0);
            boolean isNearY = MathUtil.tolerance(y, playerY, 2.0);
            boolean isNearZ = MathUtil.tolerance(z, playerZ, 2.0);
            if (isNearX && isNearY && isNearZ) {
                return null;
            }
        }
        return particle;
    }

    private static boolean typeEqualTo(ParticleType<?> check, ParticleType<?> ... types) {
        for (ParticleType<?> type : types) {
            if (type != check) continue;
            return true;
        }
        return false;
    }
}

