/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.Overlay;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public abstract class LoadingOverlayHelper {
    public static void render(GuiGraphics graphics, ResourceLocation modernLocation) {
        int color;
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        boolean isDarkMode = (Boolean)Minecraft.getInstance().options.darkMojangStudiosBackground().get();
        ResourceLocation background = switch ((Overlay)CandyTweak.OLD_LOADING_OVERLAY.get()) {
            case Overlay.ALPHA -> TextureLocation.MOJANG_ALPHA;
            case Overlay.BETA -> TextureLocation.MOJANG_BETA;
            case Overlay.RELEASE_ORANGE -> TextureLocation.MOJANG_RELEASE_ORANGE;
            case Overlay.RELEASE_BLACK -> TextureLocation.MOJANG_RELEASE_BLACK;
            default -> modernLocation;
        };
        int x = (int)((double)width / 4.0 - 64.0);
        int y = (int)((double)height / 4.0 - 64.0);
        int n = color = isDarkMode ? Color.BLACK.get() : Color.WHITE.get();
        if (((Boolean)CandyTweak.CUSTOM_LOADING_OVERLAY_BACKGROUND.get()).booleanValue()) {
            color = HexUtil.parseInt((String)CandyTweak.LOADING_OVERLAY_BACKGROUND_COLOR.get());
        } else if (CandyTweak.OLD_LOADING_OVERLAY.get() == Overlay.ALPHA) {
            color = Color.MOJANG_PURPLE.get();
        }
        if (Platform.isDevelopmentEnvironment()) {
            background = TextureLocation.DEV_MODE;
            color = Color.BLACK.get();
        }
        graphics.fill(RenderType.guiOverlay(), 0, 0, width, height, color);
        graphics.pose().pushPose();
        graphics.pose().scale(2.0f, 2.0f, 2.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.blit(background, x, y, 0.0f, 0.0f, 128, 128, 128, 128);
        graphics.pose().popPose();
    }

    public static int getProgressBarOffset() {
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        if (Platform.isDevelopmentEnvironment()) {
            return (int)((double)height * 0.85);
        }
        return switch ((Overlay)CandyTweak.OLD_LOADING_OVERLAY.get()) {
            case Overlay.ALPHA -> (int)((double)height * 0.85);
            case Overlay.BETA -> (int)((double)height * 0.95);
            default -> (int)((double)height * 0.69);
        };
    }

    public static int getOutlineProgressBarColor() {
        if (Platform.isDevelopmentEnvironment()) {
            return FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
        }
        if (((Boolean)CandyTweak.CUSTOM_LOADING_PROGRESS_BAR.get()).booleanValue()) {
            return HexUtil.parseInt((String)CandyTweak.PROGRESS_BAR_OUTLINE_COLOR.get());
        }
        Overlay overlay = (Overlay)CandyTweak.OLD_LOADING_OVERLAY.get();
        if (ModTracker.OPTIFINE.isInstalled()) {
            return switch (overlay) {
                default -> throw new MatchException(null, null);
                case Overlay.BETA, Overlay.RELEASE_ORANGE -> FastColor.ARGB32.color((int)255, (int)221, (int)79, (int)59);
                case Overlay.RELEASE_BLACK -> FastColor.ARGB32.color((int)255, (int)221, (int)31, (int)42);
                case Overlay.ALPHA, Overlay.MODERN -> FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
            };
        }
        return switch (overlay) {
            default -> throw new MatchException(null, null);
            case Overlay.BETA, Overlay.RELEASE_ORANGE -> FastColor.ARGB32.color((int)255, (int)221, (int)79, (int)59);
            case Overlay.RELEASE_BLACK -> FastColor.ARGB32.color((int)255, (int)4, (int)7, (int)7);
            case Overlay.ALPHA -> FastColor.ARGB32.color((int)255, (int)142, (int)132, (int)255);
            case Overlay.MODERN -> FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
        };
    }

    public static int getInsideProgressBarColor() {
        if (Platform.isDevelopmentEnvironment()) {
            return FastColor.ARGB32.color((int)255, (int)0, (int)255, (int)0);
        }
        if (((Boolean)CandyTweak.CUSTOM_LOADING_PROGRESS_BAR.get()).booleanValue()) {
            return HexUtil.parseInt((String)CandyTweak.PROGRESS_BAR_INSIDE_COLOR.get());
        }
        return switch ((Overlay)CandyTweak.OLD_LOADING_OVERLAY.get()) {
            default -> throw new MatchException(null, null);
            case Overlay.ALPHA, Overlay.MODERN -> FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
            case Overlay.BETA, Overlay.RELEASE_ORANGE -> FastColor.ARGB32.color((int)255, (int)246, (int)136, (int)62);
            case Overlay.RELEASE_BLACK -> FastColor.ARGB32.color((int)255, (int)221, (int)31, (int)42);
        };
    }
}

