/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import java.util.List;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemSet;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ItemHelper {
    public static void splitStack(ItemStack itemStack, Consumer<ItemStack> consumer) {
        int count = itemStack.getCount();
        if (count >= (Integer)CandyTweak.ITEM_MERGE_LIMIT.get()) {
            consumer.accept(itemStack);
        } else {
            ItemStack instance = itemStack.copy();
            instance.setCount(1);
            for (int i = 0; i < count; ++i) {
                consumer.accept(instance);
            }
        }
    }

    public static void splitEntity(Level level, ItemEntity entity, Consumer<ItemEntity> consumer) {
        int count = entity.getItem().getCount();
        if ((Integer)CandyTweak.ITEM_MERGE_LIMIT.get() <= count) {
            return;
        }
        entity.getItem().setCount(1);
        entity.setDefaultPickUpDelay();
        for (int i = 0; i < Math.max(0, count - 1); ++i) {
            double x = (double)((float)entity.getX() + 0.01f) + Mth.nextDouble((RandomSource)level.random, (double)-0.04, (double)0.04);
            double y = (double)((float)entity.getY() + 0.01f) + Mth.nextDouble((RandomSource)level.random, (double)-0.04, (double)0.04) - (double)EntityType.ITEM.getHeight() / 2.0;
            double z = (double)((float)entity.getZ() + 0.01f) + Mth.nextDouble((RandomSource)level.random, (double)-0.04, (double)0.04);
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, entity.getItem().copy());
            itemEntity.setDefaultPickUpDelay();
            consumer.accept(itemEntity);
        }
    }

    public static boolean canMergeWithNeighbors(ItemStack originStack, List<ItemEntity> neighbors) {
        int mergeLimit = (Integer)CandyTweak.ITEM_MERGE_LIMIT.get();
        int numOfNeighbors = neighbors.size();
        int originSize = originStack.getCount();
        boolean isBelowLimit = numOfNeighbors + 1 < mergeLimit && originSize == 1;
        boolean isNeighborStacked = false;
        for (ItemEntity neighbor : neighbors) {
            if (neighbor.getItem().getCount() <= 1) continue;
            isNeighborStacked = true;
            break;
        }
        return !isBelowLimit || isNeighborStacked;
    }

    public static boolean hasOldDecoration(ItemStack itemStack) {
        if (!((Boolean)CandyTweak.OLD_DURABILITY_COLORS.get()).booleanValue() || ItemUtil.hasCustomBarColor(itemStack)) {
            return false;
        }
        return !((ItemSet)CandyTweak.IGNORED_DURABILITY_COLORS.get()).containsItem(itemStack);
    }
}

