/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class ExplosionHelper {
    public static void addExplosionParticles(Level level, BlockPos blockPos, float radius, double x, double y, double z) {
        Supplier<Float> random = () -> ((RandomSource)level.getRandom()).nextFloat();
        double smokeX = (float)blockPos.getX() + random.get().floatValue();
        double smokeY = (float)blockPos.getY() + random.get().floatValue();
        double smokeZ = (float)blockPos.getZ() + random.get().floatValue();
        double dx = smokeX - x;
        double dy = smokeY - y;
        double dz = smokeZ - z;
        double magnitude = Mth.length((double)dx, (double)dy, (double)dz);
        dx /= magnitude;
        dy /= magnitude;
        dz /= magnitude;
        double rand = 0.5 / (magnitude / (double)radius + 0.1) * (double)random.get().floatValue() * (double)random.get().floatValue() + (double)0.3f;
        double poofX = (smokeX + x) / 2.0;
        double poofY = (smokeY + y) / 2.0;
        double poofZ = (smokeZ + z) / 2.0;
        level.addParticle((ParticleOptions)ParticleTypes.POOF, poofX, poofY, poofZ, dx *= rand, dy *= rand, dz *= rand);
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, smokeX, smokeY, smokeZ, dx, dy, dz);
    }

    public static void addUnoptimizedExplosionParticles(Level level, float radius, double x, double y, double z) {
        ObjectArrayList blocks = new ObjectArrayList();
        for (int offsetX = 0; offsetX < 16; ++offsetX) {
            for (int offsetY = 0; offsetY < 16; ++offsetY) {
                for (int offsetZ = 0; offsetZ < 16; ++offsetZ) {
                    float border;
                    if (offsetX != 0 && offsetX != 15 && offsetY != 0 && offsetY != 15 && offsetZ != 0 && offsetZ != 15) continue;
                    double dx = (float)offsetX / 15.0f * 2.0f - 1.0f;
                    double dy = (float)offsetY / 15.0f * 2.0f - 1.0f;
                    double dz = (float)offsetZ / 15.0f * 2.0f - 1.0f;
                    double magnitude = Mth.length((double)dx, (double)dy, (double)dz);
                    dx /= magnitude;
                    dy /= magnitude;
                    dz /= magnitude;
                    double posX = x;
                    double posY = y;
                    double posZ = z;
                    for (float i = border = radius * (0.7f + level.random.nextFloat() * 0.6f); i > 0.0f; i -= 0.225f) {
                        if (Math.random() > 0.96) {
                            blocks.add((Object)BlockPos.containing((double)posX, (double)posY, (double)posZ));
                        }
                        posX += dx * (double)0.3f;
                        posY += dy * (double)0.3f;
                        posZ += dz * (double)0.3f;
                    }
                }
            }
        }
        Util.shuffle((List)blocks, (RandomSource)level.random);
        for (BlockPos blockPos : blocks) {
            ExplosionHelper.addExplosionParticles(level, blockPos, radius, x, y, z);
        }
    }
}

