/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.adrenix.nostalgic.helper.swing.SwingType;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.data.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public abstract class PlayerArmHelper {
    public static final Holder<SwingType> SWING_TYPE = Holder.create(SwingType.ATTACK);

    public static void oldSwing(PoseStack poseStack, float swingProgress) {
        float progress = Mth.sin((float)((float)Math.PI * swingProgress));
        float scale = 1.0f - 0.3f * progress;
        poseStack.translate(-0.12f * progress, 0.085f * progress, 0.0f);
        poseStack.scale(scale, scale, scale);
    }

    public static boolean oldClassicSwing(PoseStack poseStack, HumanoidArm arm, ItemStack holding, float swingProgress, float equippedProgress) {
        boolean isAttack = (Boolean)AnimationTweak.OLD_CLASSIC_ATTACK_SWING.get();
        boolean isUseItem = (Boolean)AnimationTweak.OLD_CLASSIC_USE_SWING.get();
        if (!isAttack && !isUseItem) {
            return false;
        }
        float flip = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        SwingType swingType = SWING_TYPE.get();
        if (isAttack && swingType == SwingType.ATTACK) {
            float x = -0.4f * Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
            float y = 0.2f * Mth.sin((float)(Mth.sqrt((float)swingProgress) * ((float)Math.PI * 2)));
            float z = -0.2f * Mth.sin((float)(swingProgress * (float)Math.PI));
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(flip * 0.56f, -0.52f + equippedProgress * -0.6f, -0.72f);
            poseStack.translate(flip * x, y, z);
            if (!GameUtil.isModelFlat(holding)) {
                poseStack.mulPose(Axis.YP.rotationDegrees(flip * Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI)) * 80.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(flip * -Mth.sin((float)(swingProgress * swingProgress * (float)Math.PI)) * 20.0f));
            }
            return true;
        }
        if (isUseItem && swingType == SwingType.USE) {
            float rotateProgress = Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(flip * 0.56f, -0.52f + equippedProgress * -0.6f, -0.72f);
            poseStack.translate(0.0f, rotateProgress * -0.15f, 0.0f);
            return true;
        }
        return false;
    }
}

