/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.config.factory;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import mod.adrenix.nostalgic.config.factory.ConfigMeta;
import mod.adrenix.nostalgic.config.factory.GsonFactory;
import mod.adrenix.nostalgic.config.factory.LoaderException;

public class GsonSerializer<T extends ConfigMeta> {
    private final Class<T> config;

    public GsonSerializer(Class<T> config) {
        this.config = config;
    }

    public void write(T config, Path path) throws LoaderException {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
            GsonFactory.BUILDER.toJson(config, (Appendable)writer);
            writer.close();
        }
        catch (IOException exception) {
            throw new LoaderException(exception);
        }
    }

    public T read(Path path) throws LoaderException {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                BufferedReader reader = Files.newBufferedReader(path);
                ConfigMeta config = (ConfigMeta)GsonFactory.BUILDER.fromJson((Reader)reader, this.config);
                reader.close();
                return (T)config;
            }
            catch (JsonParseException | IOException exception) {
                throw new LoaderException(exception);
            }
        }
        return this.getDefault();
    }

    public T getDefault() {
        try {
            Constructor<T> constructor = this.config.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((ConfigMeta)constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }
}

