/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.config.factory;

import java.io.IOException;
import java.nio.file.Path;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.factory.ConfigMeta;
import mod.adrenix.nostalgic.config.factory.ConfigPermissions;
import mod.adrenix.nostalgic.config.factory.GsonSerializer;
import mod.adrenix.nostalgic.config.factory.LoaderException;
import mod.adrenix.nostalgic.util.common.io.BackupFile;
import org.jetbrains.annotations.Nullable;

public class ConfigHandler<T extends ConfigMeta> {
    private final Path path;
    private final Class<T> config;
    private final GsonSerializer<T> serializer;
    private final ConfigPermissions permissions;
    private final Runnable onLoad;
    private final Runnable onSave;
    @Nullable
    private T loaded;

    public ConfigHandler(Class<T> config, Path path, ConfigPermissions permissions, Runnable onLoad, Runnable onSave) {
        this.path = path;
        this.config = config;
        this.onLoad = onLoad;
        this.onSave = onSave;
        this.permissions = permissions;
        this.serializer = new GsonSerializer<T>(config);
    }

    void init() {
        this.startup();
        if (this.load()) {
            this.save();
        }
    }

    public void setLoaded(@Nullable T configInstance) {
        this.loaded = configInstance;
        if (this.loaded == null) {
            NostalgicTweaks.LOGGER.warn("[Config Handler] Aborted runtime loading of %s since it was null", this.config.getSimpleName());
            return;
        }
        try {
            this.loaded.validate();
            this.onLoad.run();
            if (this.permissions == ConfigPermissions.READ_WRITE) {
                NostalgicTweaks.LOGGER.info("[Config Handler] Successfully loaded runtime %s", this.config.getSimpleName());
            } else {
                NostalgicTweaks.LOGGER.info("[Config Handler] Successfully loaded temporary %s", this.config.getSimpleName());
            }
        }
        catch (LoaderException exception) {
            NostalgicTweaks.LOGGER.error("[Config Handler] Failed runtime loading of %s\n%s", this.config.getSimpleName(), exception);
        }
    }

    @Nullable
    public T getLoaded() {
        return this.loaded;
    }

    public T getDefault() {
        return this.serializer.getDefault();
    }

    public Path getPath() {
        return this.path;
    }

    public void export(Path path) {
        try {
            this.serializer.write(this.loaded, path);
        }
        catch (LoaderException exception) {
            NostalgicTweaks.LOGGER.error("[Config Handler] Could not write config to the given path\n%s", exception);
        }
    }

    private void startup() {
        try {
            if (this.permissions == ConfigPermissions.READ_WRITE) {
                BackupFile.startup(this.path);
            }
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("[Config Handler] Could not create a startup backup config file\n%s", exception.toString());
        }
    }

    public boolean backup() {
        try {
            if (this.permissions == ConfigPermissions.READ_WRITE) {
                BackupFile.save(this.path);
            }
            return true;
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("[Config Handler] Could not create a backup config file\n%s", exception);
            return false;
        }
    }

    public void save() {
        try {
            if (this.permissions == ConfigPermissions.READ_ONLY) {
                return;
            }
            this.serializer.write(this.loaded, this.path);
            this.onSave.run();
            NostalgicTweaks.LOGGER.info("[Config Handler] Successfully saved %s", this.config.getSimpleName());
        }
        catch (LoaderException exception) {
            NostalgicTweaks.LOGGER.error("[Config Handler] Failed to save config %s\n%s", this.config.getSimpleName(), exception);
        }
    }

    public boolean load() {
        try {
            this.loaded = this.serializer.read(this.path);
            if (this.loaded == null) {
                throw new LoaderException(new Throwable(String.format("[Config Handler] Could not properly read config file (%s)", this.path)));
            }
            this.loaded.validate();
            this.onLoad.run();
            NostalgicTweaks.LOGGER.info("[Config Handler] Successfully loaded %s", this.config.getSimpleName());
            return true;
        }
        catch (LoaderException exception) {
            NostalgicTweaks.LOGGER.error("[Config Handler] Failed to load %s\n%s", this.config.getSimpleName(), exception);
            if (this.permissions == ConfigPermissions.READ_WRITE) {
                this.reset();
                this.onLoad.run();
                NostalgicTweaks.LOGGER.error("[Config Handler] Config file was reset - see backup file to retrieve deleted data");
            }
            return false;
        }
    }

    public void reset() {
        this.backup();
        this.loaded = this.serializer.getDefault();
        try {
            this.loaded.validate();
        }
        catch (LoaderException exception) {
            throw new RuntimeException("[Config Handler] Could not create a default config file", exception);
        }
        this.save();
    }
}

