/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.config.cache;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.ClientConfig;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.config.factory.ConfigMeta;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.common.data.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigReflect {
    public static void setClientField(Tweak<?> tweak, Object value) {
        ConfigReflect.setField(tweak, ClientConfig.class, ConfigCache.client(), value);
    }

    public static void setServerField(Tweak<?> tweak, Object value) {
        ConfigReflect.setField(tweak, ServerConfig.class, ConfigCache.server(), value);
    }

    public static <M extends ConfigMeta> void setManualField(Class<M> classType, M configInstance, Tweak<?> tweak, Object value) {
        ConfigReflect.setField(tweak, classType, configInstance, value);
    }

    public static void syncTweak(Tweak<?> tweak) {
        if (NostalgicTweaks.isClient()) {
            ConfigReflect.setTweak(tweak, ClientConfig.class, ConfigCache.client());
        } else {
            ConfigReflect.setTweak(tweak, ServerConfig.class, ConfigCache.server());
        }
    }

    private static Optional<Field> getFieldFromClass(Class<?> classType, Tweak<?> tweak) {
        return Arrays.stream(classType.getFields()).filter(field -> field.getName().equals(tweak.getJsonId())).findFirst();
    }

    private static Optional<Field> getFieldFromSubclass(Class<?> classType, Tweak<?> tweak) {
        String categoryKey = tweak.getCategory().getJsonId().toLowerCase(Locale.ROOT);
        return Arrays.stream(classType.getFields()).filter(field -> field.getType().toString().contains("class")).filter(field -> field.getName().toLowerCase(Locale.ROOT).contains(categoryKey)).findFirst();
    }

    private static void cannotFindFieldInConfig(String name, Object value) {
        if (value != null) {
            NostalgicTweaks.LOGGER.error("Could not find (%s) to apply value (%s)", name, value);
        } else {
            NostalgicTweaks.LOGGER.error("Could not find (%s)", name);
        }
    }

    public static <M extends ConfigMeta> Pair<Optional<Field>, Object> findField(Tweak<?> tweak, Class<M> classType, Object configInstance) {
        if (tweak.getContainer().isRoot()) {
            return new Pair<Optional<Field>, Object>(ConfigReflect.getFieldFromClass(classType, tweak), configInstance);
        }
        Optional<Field> fromCategory = ConfigReflect.getFieldFromSubclass(classType, tweak);
        if (fromCategory.isPresent()) {
            Field field = fromCategory.get();
            try {
                return new Pair<Optional<Field>, Object>(ConfigReflect.getFieldFromClass(field.getType(), tweak), field.get(configInstance));
            }
            catch (IllegalAccessException exception) {
                NostalgicTweaks.LOGGER.error("Could not access subclass field (%s) with parent class (%s)", field, configInstance);
            }
        }
        return new Pair<Optional<Field>, Object>(Optional.empty(), configInstance);
    }

    @Nullable
    public static <M extends ConfigMeta> Object getFieldValue(Tweak<?> tweak, Class<M> classType, Object configInstance) {
        Pair<Optional<Field>, Object> pair = ConfigReflect.findField(tweak, classType, configInstance);
        Optional<Field> found = pair.left();
        Object parentClass = pair.right();
        if (found.isEmpty()) {
            ConfigReflect.cannotFindFieldInConfig(tweak.getJsonId(), null);
            return null;
        }
        Field field = found.get();
        try {
            return field.get(parentClass);
        }
        catch (IllegalAccessException exception) {
            NostalgicTweaks.LOGGER.error("Could not access field (%s)\n%s", field, exception);
            return null;
        }
    }

    private static <M extends ConfigMeta> void setField(Tweak<?> tweak, Class<M> classType, Object configInstance, Object value) {
        Pair<Optional<Field>, Object> pair = ConfigReflect.findField(tweak, classType, configInstance);
        Optional<Field> found = pair.left();
        Object parentClass = pair.right();
        if (found.isEmpty()) {
            ConfigReflect.cannotFindFieldInConfig(tweak.getJsonId(), value);
            return;
        }
        Field field = found.get();
        try {
            field.set(parentClass, value);
        }
        catch (IllegalAccessException exception) {
            NostalgicTweaks.LOGGER.error("Could not access field (%s)\n%s", field, exception);
        }
    }

    private static <T, M extends ConfigMeta> void setTweak(Tweak<T> tweak, Class<M> classType, Object configInstance) {
        Pair<Optional<Field>, Object> pair = ConfigReflect.findField(tweak, classType, configInstance);
        Optional<Field> found = pair.left();
        Object parentClass = pair.right();
        if (found.isEmpty()) {
            ConfigReflect.cannotFindFieldInConfig(tweak.getJsonId(), null);
            return;
        }
        Field field = found.get();
        try {
            tweak.setDisk(field.get(parentClass));
        }
        catch (IllegalAccessException exception) {
            NostalgicTweaks.LOGGER.error("Could not access field (%s)\n%s", field, exception);
        }
    }
}

