/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.config.cache;

import java.nio.file.Path;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.ClientConfig;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.cache.ConfigReflect;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;

public abstract class ConfigCache {
    private static boolean clientInitialized = false;
    private static boolean serverInitialized = false;
    private static ClientConfig clientCache;
    private static ServerConfig serverCache;

    public static ClientConfig client() {
        if (!clientInitialized) {
            ConfigCache.preloadClient();
        }
        return clientCache;
    }

    public static ServerConfig server() {
        if (!serverInitialized) {
            ConfigCache.preloadServer();
        }
        return serverCache;
    }

    private static void reloadClient() {
        clientCache = ConfigBuilder.getConfig(ClientConfig.class);
        TweakPool.values().forEach(ConfigReflect::syncTweak);
        TweakPool.values().forEach(TweakMeta::sync);
        TweakValidator.check(ClientConfig.class);
    }

    private static void reloadServer() {
        serverCache = ConfigBuilder.getConfig(ServerConfig.class);
        TweakPool.filter(Tweak::isMultiplayerLike).forEach(ConfigReflect::syncTweak);
        TweakValidator.check(ServerConfig.class);
    }

    private static void preloadClient() {
        if (NostalgicTweaks.isServer()) {
            throw new AssertionError((Object)String.format("[%s] Cannot initialize client config for server.", "Nostalgic Tweaks"));
        }
        NostalgicTweaks.LOGGER.info("[Config Cache] Initializing client config prematurely for mixin compatibility");
        ConfigCache.initClient();
    }

    private static void preloadServer() {
        NostalgicTweaks.LOGGER.info("[Config Cache] Initializing server config prematurely for mixin compatibility");
        ConfigCache.initServer();
    }

    public static void initClient() {
        if (clientInitialized) {
            return;
        }
        clientInitialized = true;
        ConfigBuilder.create(ClientConfig.class, ConfigCache::reloadClient);
        Container.scanForIssues();
        NostalgicTweaks.LOGGER.info("[Config Cache] Loaded %d client tweaks", TweakPool.values().size());
    }

    public static void initServer() {
        if (serverInitialized) {
            return;
        }
        serverInitialized = true;
        ConfigBuilder.create(ServerConfig.class, ConfigCache::reloadServer);
        Container.scanForIssues();
        String message = "[Config Cache] Loaded %d server tweaks";
        NostalgicTweaks.LOGGER.info(message, TweakPool.filter(Tweak::isMultiplayerLike).toList().size());
    }

    public static Path path() {
        return ConfigBuilder.getHandler().getPath();
    }

    public static void save() {
        ConfigBuilder.getHandler().save();
    }
}

