/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.slider.color;

import mod.adrenix.nostalgic.client.gui.widget.slider.AbstractSlider;
import mod.adrenix.nostalgic.client.gui.widget.slider.color.ColorSliderBuilder;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.ColorElement;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.GuiGraphics;

public class ColorSlider
extends AbstractSlider<ColorSliderBuilder, ColorSlider> {
    protected final Color color;
    protected final ColorElement element;

    public static ColorSliderBuilder create(Color color, ColorElement element) {
        return new ColorSliderBuilder(color, element);
    }

    protected ColorSlider(ColorSliderBuilder builder) {
        super(builder);
        this.color = builder.color;
        this.element = builder.element;
        ((ColorSliderBuilder)this.builder).handleWidth(3);
        builder.backgroundRenderer(this::renderBackground);
        builder.handleRenderer(this::renderHandle);
    }

    public ColorElement getElement() {
        return this.element;
    }

    protected void renderHandle(ColorSlider slider, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int outline = this.isFocused() ? Color.LIGHT_BLUE.get() : -11184811;
        int handle = this.isHoveredOrFocused() ? -3355444 : -5592406;
        RenderUtil.beginBatching();
        RenderUtil.outline(graphics, (float)this.x, (float)this.y, (float)this.width, (float)this.height, this.isActive() ? outline : -13421773);
        RenderUtil.outline(graphics, (float)this.getHandleX(), (float)this.y, (float)this.getHandleWidth(), (float)this.height, this.isActive() ? handle : -10066330);
        RenderUtil.endBatching();
    }

    protected void renderBackground(ColorSlider slider, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.beginBatching();
        graphics.pose().pushPose();
        graphics.pose().translate((double)this.x + 1.0, (double)this.y + 1.0, 0.0);
        int innerW = this.width - 2;
        int innerH = this.height - 2;
        int outerW = this.width - 1;
        Color sbColor = switch (this.element) {
            case ColorElement.SATURATION -> new Color(this.color.getHueAsRGB());
            case ColorElement.BRIGHTNESS -> new Color(Color.HSBtoRGB(this.color.getHue(), this.color.getSaturation(), 1.0f));
            default -> Color.WHITE;
        };
        switch (this.element) {
            case HUE: {
                int diff = (int)((float)innerW / 6.0f);
                int last = diff * 6 + Math.abs(innerW - diff * 6);
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)diff, (float)innerH, Color.RED, Color.YELLOW);
                RenderUtil.fromLeftGradient(graphics, (float)diff, 0.0f, (float)(diff * 2), (float)innerH, Color.YELLOW, Color.GREEN);
                RenderUtil.fromLeftGradient(graphics, (float)(diff * 2), 0.0f, (float)(diff * 3), (float)innerH, Color.GREEN, Color.CYAN);
                RenderUtil.fromLeftGradient(graphics, (float)(diff * 3), 0.0f, (float)(diff * 4), (float)innerH, Color.CYAN, Color.BLUE);
                RenderUtil.fromLeftGradient(graphics, (float)(diff * 4), 0.0f, (float)(diff * 5), (float)innerH, Color.BLUE, Color.PINK);
                RenderUtil.fromLeftGradient(graphics, (float)(diff * 5), 0.0f, (float)last, (float)innerH, Color.PINK, Color.RED);
                break;
            }
            case SATURATION: {
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)innerW, (float)innerH, Color.WHITE, sbColor);
                break;
            }
            case BRIGHTNESS: {
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)innerW, (float)innerH, Color.BLACK, sbColor);
                break;
            }
            case RED: {
                Color from = new Color(0, this.color.getGreen(), this.color.getBlue());
                Color to = new Color(255, this.color.getGreen(), this.color.getBlue());
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)innerW, (float)innerH, from, to);
                break;
            }
            case GREEN: {
                Color from = new Color(this.color.getRed(), 0, this.color.getBlue());
                Color to = new Color(this.color.getRed(), 255, this.color.getBlue());
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)innerW, (float)innerH, from, to);
                break;
            }
            case BLUE: {
                Color from = new Color(this.color.getRed(), this.color.getGreen(), 0);
                Color to = new Color(this.color.getRed(), this.color.getGreen(), 255);
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)innerW, (float)innerH, from, to);
                break;
            }
            case ALPHA: {
                int size = 3;
                for (int row = 1; row <= 6; ++row) {
                    Color primary = MathUtil.isOdd(row) ? Color.GRAY : Color.WHITE;
                    Color secondary = MathUtil.isOdd(row) ? Color.WHITE : Color.GRAY;
                    for (int i = 0; i < (int)((float)outerW / (float)size) * size; i += size) {
                        RenderUtil.fill(graphics, (float)i, (float)((row - 1) * size), (float)(i + size), (float)(row * size), MathUtil.isEven(i) ? primary : secondary);
                    }
                }
                RenderUtil.fromLeftGradient(graphics, 0.0f, 0.0f, (float)innerW, (float)innerH, this.color.fromAlpha(0.0), this.color.fromAlpha(1.0));
            }
        }
        if (this.isInactive()) {
            RenderUtil.fill(graphics, 0.0f, 0.0f, (float)this.width, (float)this.height, -1526726656);
        }
        graphics.pose().popPose();
        RenderUtil.endBatching();
    }
}

