/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.slider;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.ActiveBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.TooltipBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.slider.AbstractSlider;
import mod.adrenix.nostalgic.client.gui.widget.slider.SliderRenderer;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSliderMaker<Builder extends AbstractSliderMaker<Builder, Slider>, Slider extends AbstractSlider<Builder, Slider>>
extends DynamicBuilder<Builder, Slider>
implements LayoutBuilder<Builder, Slider>,
ActiveBuilder<Builder, Slider>,
VisibleBuilder<Builder, Slider>,
TooltipBuilder<Builder, Slider> {
    protected Number minValue;
    protected Number maxValue;
    protected Consumer<Number> valueConsumer;
    protected Supplier<Number> valueSupplier;
    @Nullable
    protected Consumer<Slider> onValueChange = null;
    @Nullable
    protected SliderRenderer<Builder, Slider> backgroundRenderer = null;
    @Nullable
    protected SliderRenderer<Builder, Slider> effectsRenderer = null;
    @Nullable
    protected SliderRenderer<Builder, Slider> handleRenderer = null;
    @Nullable
    protected Supplier<Number> interval = null;
    protected int roundTo = 2;
    protected int handleWidth = 8;
    protected boolean useRounding = false;
    protected boolean scrollRequiresFocus = true;
    protected boolean clickSoundOnRelease = true;
    protected Supplier<Component> title = Component::empty;
    protected Supplier<Component> suffix = Component::empty;
    protected Supplier<Component> separator = () -> Component.literal((String)": ");
    protected Function<Number, String> formatter = Object::toString;

    protected AbstractSliderMaker(Number minValue, Number maxValue, Consumer<Number> valueConsumer, Supplier<Number> valueSupplier) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueConsumer = valueConsumer;
        this.valueSupplier = valueSupplier;
    }

    protected AbstractSliderMaker(Number minValue, Number maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueConsumer = number -> {};
        this.valueSupplier = () -> 0;
    }

    public Builder title(Supplier<Component> supplier) {
        this.title = supplier;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder title(Component title) {
        return this.title(() -> title);
    }

    public Builder title(Translation langKey) {
        return this.title(() -> langKey.get(new Object[0]));
    }

    public Builder suffix(Supplier<Component> supplier) {
        this.suffix = supplier;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder suffix(Component suffix) {
        return this.suffix(() -> suffix);
    }

    public Builder suffix(Translation langKey) {
        return this.suffix(() -> langKey.get(new Object[0]));
    }

    public Builder suffix(String suffix) {
        return this.suffix((Component)Component.literal((String)suffix));
    }

    public Builder separator(Supplier<Component> supplier) {
        this.separator = supplier;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder separator(Component separator) {
        return this.separator(() -> separator);
    }

    public Builder separator(Translation langKey) {
        return this.separator(() -> langKey.get(new Object[0]));
    }

    public Builder formatter(Function<Number, String> function) {
        this.formatter = function;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder interval(@Nullable Supplier<Number> supplier) {
        this.interval = supplier;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder interval(Number number) {
        return this.interval(() -> number);
    }

    public Builder roundTo(int place) {
        this.useRounding = true;
        this.roundTo = place;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder handleWidth(int width) {
        this.handleWidth = width;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder noClickSound() {
        this.clickSoundOnRelease = false;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder scrollWithoutFocus() {
        this.scrollRequiresFocus = false;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder onChange(Consumer<Slider> consumer) {
        this.onValueChange = consumer;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder onChange(Runnable runnable) {
        return this.onChange((Slider slider) -> runnable.run());
    }

    public Builder handleRenderer(@Nullable SliderRenderer<Builder, Slider> renderer) {
        this.handleRenderer = renderer;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder effectsRenderer(@Nullable SliderRenderer<Builder, Slider> renderer) {
        this.effectsRenderer = renderer;
        return (Builder)((AbstractSliderMaker)this.self());
    }

    public Builder backgroundRenderer(@Nullable SliderRenderer<Builder, Slider> renderer) {
        this.backgroundRenderer = renderer;
        return (Builder)((AbstractSliderMaker)this.self());
    }
}

