/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.scrollbar;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.LayoutBuilder;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.VisibleBuilder;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.Scrollbar;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarType;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;

public class ScrollbarBuilder
extends DynamicBuilder<ScrollbarBuilder, Scrollbar>
implements LayoutBuilder<ScrollbarBuilder, Scrollbar>,
VisibleBuilder<ScrollbarBuilder, Scrollbar> {
    final ScrollbarType scrollbarType;
    final IntSupplier contentSize;
    final DoubleSupplier averageScrollAmount;
    int size = 6;
    int minSize = 16;
    Animation animation = Animate.linear(1L, TimeUnit.SECONDS);
    Color scrollColor = new Color(85, 85, 85);
    Color borderColor = new Color(192, 192, 192);
    Color backgroundColor = new Color(49, 49, 49);
    Consumer<Scrollbar> onScroll = scrollbar -> {};

    protected ScrollbarBuilder(ScrollbarType scrollbarType, IntSupplier contentSize, DoubleSupplier averageScrollAmount) {
        this.scrollbarType = scrollbarType;
        this.contentSize = contentSize;
        this.averageScrollAmount = averageScrollAmount;
        this.canFocus = BooleanSupplier.NEVER;
    }

    @Override
    public ScrollbarBuilder self() {
        return this;
    }

    @Override
    public ScrollbarBuilder size(int size) {
        this.size = size;
        return this;
    }

    public ScrollbarBuilder scrollColor(Color color) {
        this.scrollColor = color;
        return this;
    }

    public ScrollbarBuilder borderColor(Color color) {
        this.borderColor = color;
        return this;
    }

    public ScrollbarBuilder backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public ScrollbarBuilder minimum(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public ScrollbarBuilder animation(Animation animator) {
        this.animation = animator;
        return this;
    }

    public ScrollbarBuilder onScroll(Consumer<Scrollbar> consumer) {
        this.onScroll = consumer;
        return this;
    }

    public ScrollbarBuilder onScroll(Runnable runnable) {
        this.onScroll = scrollbar -> runnable.run();
        return this;
    }

    @Override
    protected Scrollbar construct() {
        switch (this.scrollbarType) {
            case VERTICAL: {
                this.defaultWidth = this.size;
                break;
            }
            case HORIZONTAL: {
                this.defaultHeight = this.size;
            }
        }
        if (this.visible == null) {
            this.visible = scrollbar -> scrollbar.getMaxScrollAmount() > 0;
        }
        return new Scrollbar(this);
    }
}

