/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.scrollbar;

import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarBuilder;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarContent;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarType;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.client.timer.PartialTick;
import mod.adrenix.nostalgic.util.common.data.CacheValue;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public class Scrollbar
extends DynamicWidget<ScrollbarBuilder, Scrollbar> {
    private double scrollAmount = 0.0;
    private double scrollTo = 0.0;
    private double lastScrollTo = 0.0;
    private boolean dragging = false;
    private boolean smoothScroll = false;
    private final ScrollbarContent content = new ScrollbarContent(CacheValue.create(builder.contentSize::getAsInt));

    public static ScrollbarBuilder vertical(IntSupplier contentSize, DoubleSupplier averageScrollAmount) {
        return new ScrollbarBuilder(ScrollbarType.VERTICAL, contentSize, averageScrollAmount);
    }

    public static ScrollbarBuilder horizontal(IntSupplier contentSize, DoubleSupplier averageScrollAmount) {
        return new ScrollbarBuilder(ScrollbarType.HORIZONTAL, contentSize, averageScrollAmount);
    }

    protected Scrollbar(ScrollbarBuilder builder) {
        super(builder);
        ((ScrollbarBuilder)this.getBuilder()).addFunction(this.content);
    }

    public ScrollbarType getScrollbarType() {
        return ((ScrollbarBuilder)this.getBuilder()).scrollbarType;
    }

    public boolean isVertical() {
        return ((ScrollbarBuilder)this.getBuilder()).scrollbarType == ScrollbarType.VERTICAL;
    }

    public boolean isHorizontal() {
        return ((ScrollbarBuilder)this.getBuilder()).scrollbarType == ScrollbarType.HORIZONTAL;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isSmoothScrolling() {
        return (Boolean)ModTweak.SMOOTH_SCROLL.fromCache() != false && !Screen.hasControlDown();
    }

    public void setScrollAmount(double amount) {
        this.scrollTo = this.scrollAmount = Mth.clamp((double)amount, (double)0.0, (double)this.getMaxScrollAmount());
        ((ScrollbarBuilder)this.getBuilder()).onScroll.accept(this);
    }

    private void setAnimationScrollAmount(double amount) {
        this.scrollAmount = Mth.clamp((double)amount, (double)0.0, (double)this.getMaxScrollAmount());
        if (MathUtil.tolerance(this.scrollAmount, this.scrollTo, 0.01)) {
            this.scrollAmount = this.scrollTo;
        }
        ((ScrollbarBuilder)this.getBuilder()).onScroll.accept(this);
    }

    public void clamp() {
        this.scrollAmount = Mth.clamp((double)this.scrollAmount, (double)0.0, (double)this.getMaxScrollAmount());
    }

    public void updateContentSize() {
        this.content.update();
    }

    public void setSmoothScrollAmount(double amount) {
        this.lastScrollTo = this.getScrollAmount();
        this.scrollTo = Mth.clamp((double)amount, (double)0.0, (double)this.getMaxScrollAmount());
        ((ScrollbarBuilder)this.getBuilder()).animation.reset();
        ((ScrollbarBuilder)this.getBuilder()).animation.play();
        ((ScrollbarBuilder)this.getBuilder()).onScroll.accept(this);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public int getMaxScrollAmount() {
        return Math.max(0, this.content.getSize() - (this.isVertical() ? this.height : this.width));
    }

    public int getScrollLength() {
        int base = this.isVertical() ? this.height : this.width;
        int value = (int)Math.round(Math.pow(base, 2.0) / (double)this.content.getSize());
        return Mth.clamp((int)value, (int)((ScrollbarBuilder)this.getBuilder()).minSize, (int)(this.isVertical() ? this.height : this.width));
    }

    public double getScrollStart() {
        int barSize = this.isVertical() ? this.height : this.width;
        return Math.max(0.0, this.scrollAmount * (double)(barSize - this.getScrollLength()) / (double)this.getMaxScrollAmount());
    }

    public double getScrollEnd() {
        return this.getScrollStart() + (double)this.getScrollLength();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInvalidClick(mouseX, mouseY, button)) {
            return false;
        }
        switch (((ScrollbarBuilder)this.getBuilder()).scrollbarType) {
            case VERTICAL: {
                int startY = this.y + (int)Math.round(this.getScrollStart());
                int width = ((ScrollbarBuilder)this.getBuilder()).size;
                int height = this.getScrollLength();
                this.dragging = MathUtil.isWithinBox(mouseX, mouseY, this.x, startY, width, height);
                break;
            }
            case HORIZONTAL: {
                int startX = this.x + (int)Math.round(this.getScrollStart());
                int width = this.getScrollLength();
                int height = ((ScrollbarBuilder)this.getBuilder()).size;
                this.dragging = MathUtil.isWithinBox(mouseX, mouseY, startX, this.y, width, height);
            }
        }
        if (!this.dragging && MathUtil.isWithinBox(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            double d = this.getMaxScrollAmount();
            double clickAmount = d * (switch (((ScrollbarBuilder)this.getBuilder()).scrollbarType) {
                default -> throw new MatchException(null, null);
                case ScrollbarType.VERTICAL -> 1.0 - ((double)this.getEndY() - mouseY) / (double)this.height;
                case ScrollbarType.HORIZONTAL -> 1.0 - ((double)this.getEndX() - mouseX) / (double)this.width;
            });
            if (this.isSmoothScrolling()) {
                this.setSmoothScrollAmount(clickAmount);
            } else {
                this.setScrollAmount(clickAmount);
            }
            this.dragging = true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.onDrag(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return false;
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.isInactive() || this.isInvisible()) {
            return;
        }
        if (((ScrollbarBuilder)this.getBuilder()).animation.isNotFinished()) {
            ((ScrollbarBuilder)this.getBuilder()).animation.stop();
        }
        double drag = this.isVertical() ? dragY : dragX;
        double base = this.isVertical() ? (double)this.height : (double)this.width;
        double max = Math.max(1.0, (double)this.getMaxScrollAmount());
        double delta = Math.max(1.0, max / (base - (double)this.getScrollLength()));
        this.setScrollAmount(this.getScrollAmount() + drag * delta);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.dragging) {
            return false;
        }
        if (this.isInactive() || this.isInvisible()) {
            return false;
        }
        if (this.isVertical() && Screen.hasShiftDown()) {
            return false;
        }
        if (this.isHorizontal() && !Screen.hasShiftDown()) {
            return false;
        }
        double averageScrollAmount = Mth.clamp((double)((ScrollbarBuilder)this.getBuilder()).averageScrollAmount.getAsDouble(), (double)6.8, (double)12.0);
        if (this.isSmoothScrolling()) {
            this.scrollTo = Mth.clamp((double)(this.scrollTo - deltaY * averageScrollAmount), (double)0.0, (double)this.getMaxScrollAmount());
            this.smoothScroll = true;
            if (((ScrollbarBuilder)this.getBuilder()).animation.isNotFinished()) {
                ((ScrollbarBuilder)this.getBuilder()).animation.stop();
            }
        } else {
            this.setScrollAmount(this.scrollAmount - deltaY * averageScrollAmount);
            this.scrollTo = this.scrollAmount;
        }
        return true;
    }

    private void animate(float partialTick) {
        boolean isMaxReached;
        if (this.dragging) {
            return;
        }
        if (((ScrollbarBuilder)this.getBuilder()).animation.isNotFinished()) {
            this.setAnimationScrollAmount(Mth.lerp((double)((ScrollbarBuilder)this.getBuilder()).animation.getValue(), (double)this.lastScrollTo, (double)this.scrollTo));
        }
        if (((ScrollbarBuilder)this.getBuilder()).animation.isFinished()) {
            ((ScrollbarBuilder)this.getBuilder()).animation.reset();
            this.setAnimationScrollAmount(Mth.lerp((double)partialTick, (double)this.scrollAmount, (double)this.scrollTo));
        }
        boolean bl = isMaxReached = this.getScrollAmount() >= (double)this.getMaxScrollAmount() && this.scrollTo >= (double)this.getMaxScrollAmount();
        if (((ScrollbarBuilder)this.getBuilder()).animation.isNotFinished() && (isMaxReached || this.isInvisible())) {
            if (isMaxReached) {
                this.setScrollAmount(this.getMaxScrollAmount());
            }
            ((ScrollbarBuilder)this.getBuilder()).animation.stop();
        }
        if (this.smoothScroll) {
            this.setAnimationScrollAmount(Mth.lerp((double)partialTick, (double)this.scrollAmount, (double)this.scrollTo));
            if (this.scrollAmount == this.scrollTo) {
                this.smoothScroll = false;
            }
        }
        if (partialTick >= 1.0f) {
            this.setScrollAmount(this.scrollTo);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        partialTick = PartialTick.realtime();
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        this.clamp();
        this.animate(partialTick);
        graphics.pose().pushPose();
        graphics.pose().translate((double)this.x, (double)this.y, 0.0);
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, 0.0f, 0.0f, (float)this.width, (float)this.height, ((ScrollbarBuilder)this.getBuilder()).backgroundColor.get());
        float scrollStart = (float)this.getScrollStart();
        float scrollEnd = (float)this.getScrollEnd();
        switch (((ScrollbarBuilder)this.getBuilder()).scrollbarType) {
            case VERTICAL: {
                RenderUtil.fill(graphics, 0.0f, scrollStart, (float)this.width, scrollEnd, ((ScrollbarBuilder)this.getBuilder()).scrollColor.get());
                RenderUtil.fill(graphics, 0.0f, scrollStart, (float)(this.width - 1), scrollEnd - 1.0f, ((ScrollbarBuilder)this.getBuilder()).borderColor.get());
                break;
            }
            case HORIZONTAL: {
                RenderUtil.fill(graphics, scrollStart, 0.0f, scrollEnd, (float)this.height, ((ScrollbarBuilder)this.getBuilder()).scrollColor.get());
                RenderUtil.fill(graphics, scrollStart, 0.0f, scrollEnd - 1.0f, (float)(this.height - 1), ((ScrollbarBuilder)this.getBuilder()).borderColor.get());
            }
        }
        RenderUtil.endBatching();
        graphics.pose().popPose();
        this.content.update();
    }
}

