/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.client.gui.tooltip.TooltipManager;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.DynamicWidget;
import mod.adrenix.nostalgic.client.gui.widget.dynamic.WidgetHolder;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRow;
import mod.adrenix.nostalgic.client.gui.widget.list.AbstractRowMaker;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListBuilder;
import mod.adrenix.nostalgic.client.gui.widget.list.RowListRenderer;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.Scrollbar;
import mod.adrenix.nostalgic.client.gui.widget.scrollbar.ScrollbarBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextBuilder;
import mod.adrenix.nostalgic.client.gui.widget.text.TextWidget;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.array.UniqueArrayList;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import mod.adrenix.nostalgic.util.common.data.RecursionAvoidance;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RowList
extends DynamicWidget<RowListBuilder, RowList>
implements ContainerEventHandler,
TooltipManager {
    protected GuiEventListener focusedListener;
    protected AbstractRow<?, ?> focusedRow;
    protected boolean isDragging;
    protected final Scrollbar scrollbar;
    protected final TextWidget emptyMessage;
    protected final UniqueArrayList<DynamicWidget<?, ?>> internal;
    protected final UniqueArrayList<DynamicWidget<?, ?>> children;
    protected final UniqueArrayList<AbstractRow<?, ?>> visibleRows;
    protected final UniqueArrayList<AbstractRow<?, ?>> rows;
    protected final RecursionAvoidance pathFinder = RecursionAvoidance.create();

    public static RowListBuilder create() {
        return new RowListBuilder();
    }

    protected RowList(RowListBuilder builder) {
        super(builder);
        this.internal = new UniqueArrayList();
        this.children = new UniqueArrayList();
        this.visibleRows = new UniqueArrayList();
        this.rows = new UniqueArrayList();
        this.scrollbar = ((ScrollbarBuilder)((ScrollbarBuilder)((ScrollbarBuilder)Scrollbar.vertical(this::getContentHeight, this::getAverageRowHeight).animation(Animate.easeInOutCircular(1L, TimeUnit.SECONDS)).backgroundColor(((RowListBuilder)this.getBuilder()).scrollbarBackground).onVisibleChange(this::setPositionForRows)).pos(this::getScrollbarStartX, this::getY)).height(this::getHeight)).build(this.internal::add);
        this.emptyMessage = builder.emptyMessage == null ? (TextWidget)TextWidget.create((Component)Component.empty()).build() : ((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)TextWidget.create(builder.emptyMessage).posX(this::getX)).width(this::getWidth)).centerInWidgetY(this)).centerAligned().visibleIf(this.visibleRows::isEmpty)).build(this.internal::add);
        ((RowListBuilder)this.getBuilder()).addFollowers(this.internal);
    }

    public Stream<AbstractRow<?, ?>> getInsideAndVisibleRows() {
        return this.visibleRows.stream().filter(AbstractRow::isInsideViewingArea);
    }

    public UniqueArrayList<DynamicWidget<?, ?>> getTooltipWidgets() {
        return this.getInsideAndVisibleRows().flatMap(WidgetHolder::getWidgetStream).collect(Collectors.toCollection(UniqueArrayList::new));
    }

    @Override
    public Collection<DynamicWidget<?, ?>> getMouseTooltipWidgets() {
        if (this.isMouseOutside(this.getMouseX(), this.getMouseY())) {
            return new UniqueArrayList();
        }
        return this.getTooltipWidgets();
    }

    public UniqueArrayList<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focusedListener;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.setFocused(focused, true);
    }

    public void setFocused(@Nullable GuiEventListener focused, boolean smoothScrollToRow) {
        if (this.focusedListener != null) {
            this.focusedListener.setFocused(false);
        }
        if (focused instanceof AbstractRow) {
            AbstractRow row2;
            this.focusedRow = row2 = (AbstractRow)focused;
            if (smoothScrollToRow) {
                this.setSmoothScrollOn(row2);
            } else {
                this.setScrollOn(row2);
            }
        } else if (focused != null) {
            focused.setFocused(true);
            this.visibleRows.stream().filter(AbstractRow::isWidgetFocused).findFirst().ifPresent(row -> {
                this.focusedRow = row;
                this.setScrollOn((AbstractRow<?, ?>)row);
            });
        } else {
            this.focusedRow = null;
        }
        this.focusedListener = focused;
    }

    @Nullable
    protected ComponentPath nextTabPath(FocusNavigationEvent.TabNavigation event) {
        GuiEventListener lastListener = this.focusedListener;
        boolean cancelNavigation = false;
        ComponentPath rowPath = this.focusedRow != null ? this.focusedRow.nextFocusPath((FocusNavigationEvent)event) : (event.forward() ? NullableResult.get(this.visibleRows.getFirst(), row -> row.nextFocusPath((FocusNavigationEvent)event)) : NullableResult.get(this.visibleRows.getLast(), row -> row.nextFocusPath((FocusNavigationEvent)event)));
        if (rowPath instanceof ComponentPath.Path) {
            ComponentPath.Path nextPath = (ComponentPath.Path)rowPath;
            this.setFocused(nextPath.childPath().component());
        }
        if (this.focusedListener == lastListener && this.focusedRow != null) {
            int index = this.visibleRows.indexOf(this.focusedRow);
            if (index == -1) {
                cancelNavigation = true;
            } else {
                rowPath = event.forward() ? this.visibleRows.map(index + 1, row -> row.nextFocusPath((FocusNavigationEvent)event)) : this.visibleRows.map(index - 1, row -> row.nextFocusPath((FocusNavigationEvent)event));
                if (rowPath instanceof ComponentPath.Path) {
                    ComponentPath.Path nextPath = (ComponentPath.Path)rowPath;
                    this.setFocused(nextPath.childPath().component());
                }
            }
        }
        if (this.focusedListener == null || cancelNavigation) {
            return super.nextFocusPath((FocusNavigationEvent)event);
        }
        if (this.focusedListener != lastListener) {
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)this.focusedListener));
        }
        if (this.focusedRow == this.visibleRows.getLast() && this.getScreen() != null) {
            ComponentPath screenPath = this.pathFinder.process(() -> {
                this.setFocused(null);
                return this.getScreen().nextFocusPath((FocusNavigationEvent)event);
            });
            if (screenPath == null) {
                return this.pathFinder.process(() -> {
                    this.getScreen().setFocused(null);
                    return this.getScreen().nextFocusPath((FocusNavigationEvent)event);
                });
            }
            return screenPath;
        }
        return null;
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        FocusNavigationEvent.TabNavigation navigation;
        ComponentPath tabPath;
        if (this.isInactive() || this.isInvisible() || this.pathFinder.isProcessing()) {
            return null;
        }
        if (event instanceof FocusNavigationEvent.TabNavigation && (tabPath = this.nextTabPath(navigation = (FocusNavigationEvent.TabNavigation)event)) != null) {
            return tabPath;
        }
        return this.pathFinder.process(() -> this.getNextPath(event));
    }

    @Nullable
    protected ComponentPath getNextPath(FocusNavigationEvent event) {
        if (this.getScreen() == null) {
            return null;
        }
        ComponentPath nextPath = super.nextFocusPath(event);
        if (this.focusedListener != null && nextPath == null && this.getScreen().nextFocusPath(event) != null) {
            this.focusedListener.setFocused(false);
            this.focusedListener = null;
            return null;
        }
        return nextPath;
    }

    protected void setOverrideFocus(AbstractRow<?, ?> row) {
        row.getFocusedWidget().ifPresent(widget -> {
            if (this.focusedListener != null && this.focusedListener != widget) {
                this.focusedListener.setFocused(false);
            }
            this.focusedListener = widget;
            this.focusedRow = row;
        });
    }

    public void clearFocus() {
        this.focusedRow = null;
        this.visibleRows.stream().map(AbstractRow::getFocusedWidget).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(focused -> focused.setFocused(false));
    }

    public void focusOnFirst() {
        this.visibleRows.stream().filter(AbstractRow::hasFocusable).findFirst().ifPresent(AbstractRow::focusOnFirst);
    }

    public Scrollbar getScrollbar() {
        return this.scrollbar;
    }

    public TextWidget getEmptyMessage() {
        return this.emptyMessage;
    }

    public UniqueArrayList<AbstractRow<?, ?>> getRows() {
        return this.rows;
    }

    public UniqueArrayList<AbstractRow<?, ?>> getVisibleRows() {
        return this.visibleRows;
    }

    public Optional<AbstractRow<?, ?>> getLastVisibleRow() {
        if (this.visibleRows.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.visibleRows.getLast());
    }

    protected void addVisibleRow(AbstractRow<?, ?> row) {
        if (row.isInvisible()) {
            return;
        }
        this.visibleRows.add(row);
        this.children.addAll(row.widgets);
    }

    public void addAll(Collection<AbstractRow<?, ?>> rows) {
        for (AbstractRow<?, ?> row : rows) {
            this.addBottomRow(row);
        }
    }

    public void addTopRow(AbstractRow<?, ?> row) {
        this.rows.addFirst(row);
        if (row.isVisible()) {
            this.visibleRows.addFirst(row);
            this.children.addAll(row.widgets);
        }
    }

    public void addBottomRow(AbstractRow<?, ?> row) {
        this.rows.add(row);
        this.addVisibleRow(row);
    }

    public void addBelowRow(AbstractRow<?, ?> row, AbstractRow<?, ?> below) {
        int index = this.rows.indexOf(below) + 1;
        if (index > this.rows.size()) {
            this.rows.add(row);
            this.addVisibleRow(row);
            return;
        }
        this.rows.add(index, row);
        if (row.isVisible()) {
            this.visibleRows.add(index, row);
            this.children.addAll(row.widgets);
        }
    }

    public void removeRow(AbstractRow<?, ?> row) {
        this.children.removeAll(row.widgets);
        this.children.remove(row);
        this.rows.remove(row);
        this.visibleRows.remove(row);
        if (row == this.focusedRow) {
            this.clearFocus();
        }
    }

    public void clear() {
        this.children.clear();
        this.rows.clear();
        this.visibleRows.clear();
        this.resetScrollAmount();
        this.clearFocus();
    }

    public Optional<AbstractRow<?, ?>> getRowAtPoint(double mouseX, double mouseY) {
        return this.visibleRows.stream().filter(row -> row.isMouseOver(mouseX, mouseY)).findFirst();
    }

    public int getRowMargin() {
        return ((RowListBuilder)this.getBuilder()).verticalMargin + this.getRowSeparatorMargin();
    }

    public int getRowSeparatorMargin() {
        int separatorPadding = ((RowListBuilder)this.getBuilder()).separatorPadding;
        int separatorHeight = ((RowListBuilder)this.getBuilder()).separatorHeight;
        return ((RowListBuilder)this.getBuilder()).useSeparators ? separatorPadding + separatorHeight : 0;
    }

    public int getRowStartX() {
        if (((RowListBuilder)this.getBuilder()).centerRows) {
            return (int)MathUtil.center(this.getX(), this.getRowWidth(), this.getWidth());
        }
        return this.getX() + ((RowListBuilder)this.getBuilder()).horizontalMargin;
    }

    public int getRowEndX() {
        return this.getRowStartX() + this.getRowWidth();
    }

    public int getRowWidth() {
        int defaultWidth = ((RowListBuilder)this.getBuilder()).defaultRowWidth;
        if (defaultWidth == 0) {
            return (this.scrollbar.isVisible() ? this.getScrollbarStartX() : this.getEndX()) - this.getRowStartX() - ((RowListBuilder)this.getBuilder()).horizontalMargin;
        }
        return defaultWidth;
    }

    public int getRowCount() {
        return this.visibleRows.size();
    }

    public double getAverageRowHeight() {
        return (double)this.visibleRows.stream().mapToInt(DynamicWidget::getHeight).sum() / (double)this.getRowCount();
    }

    public int getContentHeight() {
        return ((RowListBuilder)this.getBuilder()).verticalMargin + ((RowListBuilder)this.getBuilder()).topMargin * 2 + this.visibleRows.stream().mapToInt(AbstractRow::getHeightWithMargin).sum();
    }

    public int getScrollbarStartX() {
        if (((RowListBuilder)this.getBuilder()).leftAlignedScrollbar) {
            int endX = this.getVisibleRows().stream().mapToInt(DynamicWidget::getEndX).max().orElse(0);
            return endX + ((RowListBuilder)this.getBuilder()).scrollbarLeftMargin;
        }
        return this.getEndX() - ((RowListBuilder)this.getBuilder()).scrollbarWidth;
    }

    public double getScrollAmount() {
        return this.scrollbar.getScrollAmount();
    }

    public void resetScrollAmount() {
        this.scrollbar.setScrollAmount(0.0);
    }

    public void setScrollAmount(double amount) {
        this.updateRowsWithoutSync();
        this.scrollbar.setScrollAmount(amount);
    }

    public void setSmoothScrollAmount(double amount) {
        this.updateRowsWithoutSync();
        this.scrollbar.setSmoothScrollAmount(amount);
    }

    public void setSmoothScrollOn(AbstractRow<?, ?> row) {
        this.centerScrollOn(row, true);
    }

    public void setScrollOn(AbstractRow<?, ?> row) {
        this.centerScrollOn(row, false);
    }

    private void centerScrollOn(AbstractRow<?, ?> row, boolean isSmooth) {
        double amount;
        if (row.isInvisible()) {
            return;
        }
        this.updateRowsWithoutSync();
        if (CollectionUtil.last(this.visibleRows).stream().anyMatch(last -> last.equals(row))) {
            amount = this.scrollbar.getMaxScrollAmount();
        } else {
            int rowHeight = ((RowListBuilder)this.getBuilder()).verticalMargin + row.getHeightWithMargin();
            int itemHeight = this.visibleRows.stream().takeWhile(next -> !next.equals(row)).mapToInt(AbstractRow::getHeightWithMargin).sum();
            amount = (double)itemHeight + (double)rowHeight / 2.0 - (double)this.getHeight() / 2.0;
        }
        this.scrollbar.updateContentSize();
        if (isSmooth) {
            this.setSmoothScrollAmount(amount);
        } else {
            this.setScrollAmount(amount);
        }
    }

    private boolean isEventListened(Predicate<DynamicWidget<?, ?>> predicate) {
        return CollectionUtil.test(this.getInsideAndVisibleRows().filter(AbstractRow::isInsideViewingArea).flatMap(WidgetHolder::getVisibleWidgets), predicate);
    }

    public boolean isMouseOutside(double mouseX, double mouseY) {
        return !this.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInvalidPoint(mouseX, mouseY)) {
            return false;
        }
        this.scrollbar.mouseClicked(mouseX, mouseY, button);
        if (this.scrollbar.isDragging()) {
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            boolean isWidgetClicked = this.isEventListened(widget -> {
                boolean isClicked = widget.mouseClicked(mouseX, mouseY, button);
                if (isClicked) {
                    this.clearFocus();
                    widget.setClickFocus();
                }
                return isClicked;
            });
            if (isWidgetClicked) {
                return true;
            }
            if (this.visibleRows.stream().anyMatch(row -> row.mouseClicked(mouseX, mouseY, button))) {
                return true;
            }
        }
        this.clearFocus();
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isInvalidPoint(mouseX, mouseY)) {
            return false;
        }
        if (this.scrollbar.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return this.isEventListened(widget -> widget.mouseReleased(mouseX, mouseY, button));
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInvalidPoint(mouseX, mouseY) && !this.scrollbar.isDragging()) {
            return false;
        }
        if (this.scrollbar.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.isEventListened(widget -> widget.mouseDragged(mouseX, mouseY, button, dragX, dragY));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isInvalidPoint(mouseX, mouseY)) {
            return false;
        }
        boolean isEventListened = this.isEventListened(widget -> widget.mouseScrolled(mouseX, mouseY, deltaX, deltaY));
        if (isEventListened) {
            return true;
        }
        return this.scrollbar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isInactive() || this.isInvisible()) {
            return false;
        }
        return this.isEventListened(widget -> widget.keyPressed(keyCode, scanCode, modifiers));
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.isInactive() || this.isInvisible()) {
            return false;
        }
        return this.isEventListened(widget -> widget.keyReleased(keyCode, scanCode, modifiers));
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.isInactive() || this.isInvisible()) {
            return false;
        }
        return this.isEventListened(widget -> widget.charTyped(codePoint, modifiers));
    }

    @Override
    public void tick() {
        this.rows.stream().map(AbstractRow::getWidgets).forEach(widgets -> widgets.forEach(DynamicWidget::tick));
    }

    private void setPositionForRows() {
        DynamicWidget.sync(this.rows);
        int verticalMargin = ((RowListBuilder)this.getBuilder()).verticalMargin;
        int topMargin = ((RowListBuilder)this.getBuilder()).topMargin;
        int rowStartX = this.getRowStartX();
        int rowStartY = this.getY() + topMargin + verticalMargin - (int)Math.round(this.getScrollAmount());
        int rowWidth = this.getRowWidth();
        boolean isVisibilityChanged = false;
        for (AbstractRow abstractRow : this.rows) {
            if (abstractRow.isVisibilityChanged()) {
                isVisibilityChanged = true;
            }
            if (abstractRow.isInvisible()) continue;
            abstractRow.update(rowStartX, rowStartY, rowWidth);
            rowStartY += abstractRow.getHeightWithMargin();
        }
        if (isVisibilityChanged) {
            this.visibleRows.clear();
            this.children.clear();
            this.rows.forEach((Consumer<AbstractRow<?, ?>>)((Consumer<AbstractRow>)this::addVisibleRow));
            DynamicWidget.sync(this.rows);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.isInvisible()) {
            return;
        }
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = this.getEndX();
        int y1 = this.getEndY();
        int width = this.getWidth();
        int height = this.getHeight();
        int scrollAmount = (int)Math.round(this.getScrollAmount());
        boolean isBatched = RenderUtil.isBatching();
        if (isBatched) {
            RenderUtil.endBatching();
        }
        if (((RowListBuilder)this.getBuilder()).backgroundRenderer != RowListRenderer.EMPTY) {
            ((RowListBuilder)this.getBuilder()).backgroundRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
        } else {
            boolean isLevelAbsent;
            boolean bl = isLevelAbsent = Minecraft.getInstance().level == null;
            if (isLevelAbsent && ((RowListBuilder)this.getBuilder()).renderBackgroundDirt) {
                BufferBuilder builder = RenderUtil.getAndBeginTexture(TextureLocation.DIRT_BACKGROUND);
                if (!((RowListBuilder)this.getBuilder()).renderBackgroundOpacity) {
                    RenderSystem.setShaderColor((float)0.125f, (float)0.125f, (float)0.125f, (float)1.0f);
                }
                RenderUtil.blitTexture((VertexConsumer)builder, graphics, x0, y0, (float)x1, (float)(y1 + scrollAmount), width, height, 32, 32);
                RenderUtil.endTexture(builder);
            }
            if (((RowListBuilder)this.getBuilder()).renderBackgroundOpacity) {
                int color = -553648128;
                if (((RowListBuilder)this.getBuilder()).backgroundOpacity != null) {
                    color = new Color(Color.BLACK, (double)((RowListBuilder)this.getBuilder()).backgroundOpacity.getAsFloat()).get();
                }
                RenderUtil.fill(graphics, (float)x0, (float)y0, (float)x1, (float)y1, color);
            }
            if (((RowListBuilder)this.getBuilder()).useMenuBackground) {
                ResourceLocation background = isLevelAbsent ? TextureLocation.MENU_LIST_BACKGROUND : TextureLocation.LEVEL_MENU_LIST_BACKGROUND;
                ResourceLocation header = isLevelAbsent ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
                ResourceLocation footer = isLevelAbsent ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
                RenderSystem.enableBlend();
                graphics.blit(background, x0, y0, (float)x1, (float)(y1 + scrollAmount), width, height, 32, 32);
                graphics.blit(header, x0, y0 - 2, 0.0f, 0.0f, width, 2, 32, 2);
                graphics.blit(footer, x0, y1, 0.0f, 0.0f, width, 2, 32, 2);
                RenderSystem.disableBlend();
            }
        }
        if (((RowListBuilder)this.getBuilder()).useScissorRendering) {
            if (((RowListBuilder)this.getBuilder()).scissorRectangle == null) {
                RenderUtil.pushZoneScissor(x0, y0, x1, y1);
            } else {
                Rectangle rectangle = ((RowListBuilder)this.getBuilder()).scissorRectangle.get();
                RenderUtil.pushZoneScissor(rectangle.startX(), rectangle.startY(), rectangle.endX(), rectangle.endY());
            }
        }
        RenderUtil.batch(() -> this.updateAndRenderRows(graphics, mouseX, mouseY, partialTick));
        if (((RowListBuilder)this.getBuilder()).useScissorRendering) {
            RenderUtil.popScissor();
        }
        if (((RowListBuilder)this.getBuilder()).renderTopAndBottomDirt) {
            BufferBuilder builder = RenderUtil.getAndBeginTexture(TextureLocation.DIRT_BACKGROUND);
            float shadow = 0.49803922f;
            int screenWidth = GuiUtil.getScreenWidth();
            int screenHeight = GuiUtil.getScreenHeight();
            RenderSystem.setShaderColor((float)shadow, (float)shadow, (float)shadow, (float)1.0f);
            RenderUtil.blitTexture((VertexConsumer)builder, graphics, 0, 0, 0.0f, 0.0f, screenWidth, y0, 32, 32);
            RenderUtil.blitTexture((VertexConsumer)builder, graphics, 0, y1, 0.0f, 0.0f, screenWidth, screenHeight - y1, 32, 32);
            RenderUtil.endTexture(builder);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (((RowListBuilder)this.getBuilder()).renderTopAndBottomShadow || ((RowListBuilder)this.getBuilder()).renderTopAndBottomDirt) {
            RenderUtil.fromTopGradient(graphics, (float)x0, (float)y0, (float)x1, (float)(y0 + 4), Color.BLACK, Color.BLACK.fromAlpha(0));
            RenderUtil.fromTopGradient(graphics, (float)x0, (float)(y1 - 4), (float)x1, (float)y1, Color.BLACK.fromAlpha(0), Color.BLACK);
        }
        DynamicWidget.renderWithoutSync(this.internal, graphics, mouseX, mouseY, partialTick);
        if (((RowListBuilder)this.getBuilder()).postRenderer != RowListRenderer.EMPTY) {
            ((RowListBuilder)this.getBuilder()).postRenderer.accept(this, graphics, mouseX, mouseY, partialTick);
        }
        if (isBatched) {
            RenderUtil.beginBatching();
        }
        if (this.scrollbar.isInvisible() && this.getScrollAmount() > 0.0) {
            this.setScrollAmount(0.0);
        }
        this.renderDebug(graphics);
    }

    private void renderSeparator(AbstractRow<?, ?> row, GuiGraphics graphics) {
        if (CollectionUtil.last(this.visibleRows).orElse(null) == row || !((RowListBuilder)this.getBuilder()).useSeparators) {
            return;
        }
        int endY = row.getEndY();
        int offset = ((RowListBuilder)this.getBuilder()).separatorPadding;
        int height = ((RowListBuilder)this.getBuilder()).separatorHeight + offset;
        Color color = ((RowListBuilder)this.getBuilder()).separatorColor;
        if (endY + height < this.getY() || endY + offset > this.getEndY()) {
            return;
        }
        RenderUtil.fill(graphics, (float)row.getX(), (float)(endY + offset), (float)row.getEndX(), (float)(endY + height), color.get());
    }

    private void renderRow(AbstractRow<?, ?> row, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.setOverrideFocus(row);
        this.renderSeparator(row, graphics);
        if (row.isOutside()) {
            row.renderHidden(graphics, mouseX, mouseY, partialTick);
            return;
        }
        this.renderRowHighlight(row, graphics, mouseX, mouseY);
        row.render(graphics, mouseX, mouseY, partialTick);
        if (row.isWidgetFocused() && ((RowListBuilder)this.getBuilder()).showSelectionBorder) {
            RenderUtil.outline(graphics, (float)row.getX(), (float)row.getY(), (float)row.getWidth(), (float)row.getHeight(), Color.FRENCH_SKY_BLUE);
        }
    }

    private void renderRowHighlight(AbstractRow<?, ?> row, GuiGraphics graphics, int mouseX, int mouseY) {
        Color fill;
        Animation animator;
        Optional<Animation> rowAnimator = row.getHighlightAnimation();
        Animation listAnimator = ((RowListBuilder)this.getBuilder()).rowHighlightAnimation;
        boolean isRowIgnored = rowAnimator.isEmpty() || ((AbstractRowMaker)row.getBuilder()).ignoreHighlight;
        boolean isListIgnored = listAnimator == null || !((RowListBuilder)this.getBuilder()).useHighlightsWhen.getAsBoolean();
        boolean isFocused = row.isWidgetFocused();
        if (isRowIgnored && isListIgnored) {
            return;
        }
        if (rowAnimator.isEmpty()) {
            ((AbstractRowMaker)row.getBuilder()).highlight(((RowListBuilder)this.getBuilder()).rowHighlightAlpha, listAnimator.copy());
        }
        if ((animator = (Animation)row.getHighlightAnimation().orElse(null)) == null) {
            return;
        }
        if (row.isMouseOver(mouseX, mouseY) || isFocused) {
            animator.play();
        } else {
            animator.rewind();
        }
        Color color = rowAnimator.isPresent() ? row.getHighlightColor() : ((RowListBuilder)this.getBuilder()).rowHighlightColor;
        double transparency = rowAnimator.isPresent() ? row.getHighlightAlpha() : ((RowListBuilder)this.getBuilder()).rowHighlightAlpha;
        double override = row.isMouseOver(mouseX, mouseY) ? 1.0 : 0.0;
        double normalized = (double)((RowListBuilder)this.getBuilder()).overrideHighlightOpacity.getAsInt() / 100.0;
        double opacity = ((RowListBuilder)this.getBuilder()).useOverrideHighlights.getAsBoolean() ? normalized : transparency;
        double fade = (Boolean)ModTweak.DISPLAY_ROW_HIGHLIGHT_FADE.fromCache() != false ? animator.getValue() : override;
        float alpha = (float)Mth.clamp((double)(opacity * fade), (double)0.0, (double)1.0);
        Color unfocused = new Color(color, (double)alpha);
        Color focused = new Color(0.53f, 0.68f, 1.0f, alpha);
        Color color2 = fill = isFocused ? focused : unfocused;
        if ((double)alpha == 0.0) {
            return;
        }
        RenderUtil.pauseBatching();
        RenderUtil.fill(graphics, (float)row.getX(), (float)row.getY(), (float)row.getEndX(), (float)row.getEndY(), fill.get());
        RenderUtil.resumeBatching();
    }

    private void updateRowsWithoutSync() {
        this.setPositionForRows();
        DynamicWidget.syncWithoutCache(this.internal);
    }

    private void updateAndRenderRows(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.setPositionForRows();
        DynamicWidget.sync(this.internal);
        this.visibleRows.forEach((Consumer<AbstractRow<?, ?>>)((Consumer<AbstractRow>)row -> this.renderRow((AbstractRow<?, ?>)row, graphics, mouseX, mouseY, partialTick)));
    }
}

