/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.keybinding;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.widget.button.AbstractButton;
import mod.adrenix.nostalgic.client.gui.widget.keybinding.KeybindingBuilder;
import mod.adrenix.nostalgic.tweak.factory.TweakBinding;
import mod.adrenix.nostalgic.util.client.KeyboardUtil;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class KeybindingWidget
extends AbstractButton<KeybindingBuilder, KeybindingWidget> {
    private final TweakBinding tweak;
    private final KeyMapping mapping;

    public static KeybindingBuilder create(TweakBinding tweak) {
        return new KeybindingBuilder(tweak);
    }

    protected KeybindingWidget(KeybindingBuilder builder, Consumer<KeybindingWidget> onPress) {
        super(builder, onPress);
        this.tweak = builder.tweak;
        this.mapping = builder.mapping;
        builder.title(this::setTitle);
    }

    public void reset() {
        InputConstants.Key defaultKey = this.mapping.getDefaultKey();
        Minecraft.getInstance().options.setKey(this.mapping, defaultKey);
        this.tweak.setCacheAndDiskThenSave(defaultKey.getValue());
        KeyMapping.resetMapping();
        this.setFocused(false);
    }

    protected void setKey(int keyCode, int scanCode) {
        if (KeyboardUtil.isEsc(keyCode)) {
            Minecraft.getInstance().options.setKey(this.mapping, InputConstants.UNKNOWN);
            this.tweak.setCacheAndDiskThenSave(InputConstants.UNKNOWN.getValue());
        } else {
            InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
            Minecraft.getInstance().options.setKey(this.mapping, key);
            this.tweak.setCacheAndDiskThenSave(key.getValue());
        }
        KeyMapping.resetMapping();
        this.setFocused(false);
    }

    protected Component setTitle() {
        if (this.isFocused()) {
            return Component.literal((String)"> ").append((Component)this.mapping.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.YELLOW)).append(" <").withStyle(ChatFormatting.YELLOW);
        }
        if (this.mapping.isUnbound()) {
            return Lang.Binding.UNBOUND.withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC);
        }
        if (KeyboardUtil.isMappingConflict(this.mapping)) {
            return this.mapping.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.RED);
        }
        return this.mapping.getTranslatedKeyMessage();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFocused() && this.isActive() && modifiers == 0) {
            this.setKey(keyCode, scanCode);
            this.setFocused(false);
            return true;
        }
        return false;
    }
}

