/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.gui.widget.input;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.client.gui.overlay.types.color.ColorPicker;
import mod.adrenix.nostalgic.client.gui.widget.input.AbstractInputMaker;
import mod.adrenix.nostalgic.client.gui.widget.input.ColorInput;
import mod.adrenix.nostalgic.client.gui.widget.input.HexInput;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;

public class ColorInputBuilder
extends AbstractInputMaker<ColorInputBuilder, ColorInput> {
    protected final Color color;
    protected boolean opaqueColor = false;
    protected boolean useColorPicker = true;
    protected boolean displayColorBox = true;
    protected Consumer<ColorPicker> onPickerClose = picker -> {};

    protected ColorInputBuilder(Color color) {
        this.color = color;
        this.startWith = HexUtil.parseString(color.getIntComponents());
    }

    @Override
    public ColorInputBuilder self() {
        return this;
    }

    public ColorInputBuilder opaque() {
        this.opaqueColor = true;
        this.widget.ifPresent(input -> input.setInput(HexInput.update(input.getInput(), this.opaqueColor)));
        return this;
    }

    public ColorInputBuilder hidePipette() {
        this.useColorPicker = false;
        return this;
    }

    public ColorInputBuilder hideColor() {
        this.displayColorBox = false;
        return this;
    }

    public ColorInputBuilder colorPicker(Consumer<ColorPicker> onClose) {
        this.onPickerClose = onClose;
        return this;
    }

    @Override
    public ColorInputBuilder onInput(BiConsumer<ColorInput, String> responder) {
        return (ColorInputBuilder)super.onInput((Input widget, String typed) -> {
            widget.setInput(HexInput.update(typed, this.opaqueColor));
            responder.accept((ColorInput)widget, (String)typed);
        });
    }

    @Override
    protected ColorInput construct() {
        if (this.responder == null) {
            this.onInput((String string) -> {});
        }
        return new ColorInput(this);
    }
}

